/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.interniprenos.gui.interniNalog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikaldokument;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.ArtikalinterniracunPK;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.reports.PzDataSource;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.util.DopunaPoProdaji;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.util.PzSwingUtility;

public class Dopuna
extends PzDialogInsert {
    private PzPanel mainPanel;
    private PzButton btnOk;
    private PzDateField krajnjiDatum;
    private PzDateField pocetniDatum;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private Interniracun interninalog;
    private Artikalinterniracun artintrac;
    private ArtikalinterniracunPK artintracpk;
    private Vector<DopunaPoProdaji> zaReport;

    public Dopuna(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public Dopuna(PzDialog dialog, boolean izmena, Object data1, Object data2) {
        super(dialog, izmena, (PzTable)data1, data2);
        this.interninalog = (Interniracun)data2;
    }

    protected void initGUI() {
        try {
            this.setTitle("Dopuna internog naloga po prodaji iz maloprodaje");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            mainPanelLayout.columnWidths = new int[]{20, 90, 100, 20};
            mainPanelLayout.rowHeights = new int[]{35, 30, 50};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.btnOk = new PzButton();
            this.mainPanel.add((Component)this.btnOk, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOk.setText("Potvrdi");
            this.btnOk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/check.png")));
            this.btnOk.setPreferredSize(new Dimension(160, 30));
            this.btnOk.setActionCommand("OK");
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.jLabel2 = new JLabel();
            this.mainPanel.add((Component)this.jLabel2, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel2.setText("Krajnji datum:");
            this.krajnjiDatum = new PzDateField();
            this.mainPanel.add((Component)this.krajnjiDatum, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.krajnjiDatum.setPreferredSize(new Dimension(80, 25));
            this.krajnjiDatum.setFont(new Font("Tahoma", 0, 14));
            this.pocetniDatum = new PzDateField();
            this.mainPanel.add((Component)this.pocetniDatum, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.pocetniDatum.setPreferredSize(new Dimension(80, 25));
            this.pocetniDatum.setFont(new Font("Tahoma", 0, 14));
            this.jLabel1 = new JLabel();
            this.mainPanel.add((Component)this.jLabel1, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setText("Po\u010detni datum:");
            this.setPreferredSize(new Dimension(350, 200));
            this.setResizable(false);
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManager.getEm();
        String actionCommand = ((PzButton)e.getSource()).getActionCommand();
        if (actionCommand.equals("OK")) {
            try {
                boolean preracunCijena = true;
                int rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Automatsko prera\u010dunavanje ulaznih cena?", (String)"Prera\u010dunavanje cena", null, (boolean)false);
                if (rez != 0) {
                    preracunCijena = false;
                }
                Query q = em.createQuery("SELECT e FROM Artikaldokument e WHERE e.dokument.datPrometa >=:dat1 AND e.dokument.datPrometa <=:dat2 AND (e.dokument.tip=:tip1 OR e.dokument.tip=:tip2) AND e.dokument.radnajedinica=:rj AND e.dokument.arhiviran=1 AND e.dokument.storno=0");
                q.setParameter("dat1", (Object)this.pocetniDatum.getVal());
                q.setParameter("dat2", (Object)this.krajnjiDatum.getVal());
                q.setParameter("tip1", (Object)"FAKTURA");
                q.setParameter("tip2", (Object)"FISKALNI_RACUN");
                q.setParameter("rj", (Object)this.interninalog.getUlaznaRJ());
                this.zaReport = new Vector();
                Vector artikalfakture = (Vector)q.getResultList();
                q = em.createQuery("SELECT e FROM Artikaldokument e WHERE e.dokument.datPrometa >=:dat1 AND e.dokument.datPrometa <=:dat2 AND (e.dokument.tip=:tip1 OR e.dokument.tip=:tip2) AND e.dokument.radnajedinica=:rj AND e.dokument.arhiviran=1 AND e.dokument.storno=1");
                q.setParameter("dat1", (Object)this.pocetniDatum.getVal());
                q.setParameter("dat2", (Object)this.krajnjiDatum.getVal());
                q.setParameter("tip1", (Object)"FAKTURA");
                q.setParameter("tip2", (Object)"FISKALNI_RACUN");
                q.setParameter("rj", (Object)this.interninalog.getUlaznaRJ());
                Vector artikalfaktureStorno = (Vector)q.getResultList();
                if (artikalfakture.size() == 0) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Nema podataka za dopunu.", "Obave\u0161tenje", 1);
                    return;
                }
                try {
                    em.getTransaction().begin();
                    ArrayList<Artikalinterniracun> listaStavki = new ArrayList<Artikalinterniracun>();
                    listaStavki.addAll(this.interninalog.getArtikalinterniracuns());
                    ArrayList<Artikalinterniracun> dodatnaListaStavki = new ArrayList<Artikalinterniracun>();
                    this.dopuniStavke(artikalfakture, false, listaStavki, dodatnaListaStavki, preracunCijena, em);
                    this.dopuniStavke(artikalfaktureStorno, true, listaStavki, dodatnaListaStavki, preracunCijena, em);
                    if (preracunCijena) {
                        for (Artikalinterniracun a : listaStavki) {
                            if (a.getTemp() != 1.0) continue;
                            BigDecimal ukupnaKolicina = BDConverter.getKolicina((double)a.getKolicina());
                            BigDecimal ukupnaVrednost = BDConverter.getIznos((double)(a.getKolicina() * a.getUlCena()));
                            this.interninalog.setVredNaUlazu(this.interninalog.getVredNaUlazu().subtract(BDConverter.getIznos((double)(a.getKolicina() * a.getUlCena()))));
                            this.interninalog.setVredNaIzlazu(this.interninalog.getVredNaIzlazu().subtract(BDConverter.getIznos((double)(a.getKolicina() * a.getIzlCena()))));
                            for (Artikalinterniracun air : dodatnaListaStavki) {
                                if (!air.getId().getSfrProizvod().equals(a.getId().getSfrProizvod())) continue;
                                ukupnaKolicina = ukupnaKolicina.add(BDConverter.getKolicina((double)air.getKolicina()));
                                ukupnaVrednost = ukupnaVrednost.add(BDConverter.getIznos((double)(air.getKolicina() * air.getUlCena())));
                            }
                            BigDecimal preracunataCijena = BDConverter.getProdCena((double)(ukupnaVrednost.doubleValue() / ukupnaKolicina.doubleValue()));
                            a.setUlCena(preracunataCijena.doubleValue());
                            a.setKolicina(ukupnaKolicina.doubleValue());
                            this.interninalog.setVredNaUlazu(this.interninalog.getVredNaUlazu().add(BDConverter.getIznos((double)(a.getKolicina() * a.getUlCena()))));
                            this.interninalog.setVredNaIzlazu(this.interninalog.getVredNaIzlazu().add(BDConverter.getIznos((double)(a.getKolicina() * a.getIzlCena()))));
                        }
                        Interniracun intrac = (Interniracun)em.find(Interniracun.class, (Object)this.interninalog.getIdDok());
                        intrac.setVredNaUlazu(this.interninalog.getVredNaUlazu());
                        intrac.setVredNaIzlazu(this.interninalog.getVredNaIzlazu());
                    }
                    for (Artikalinterniracun a : listaStavki) {
                        if (a.getKolicina() == 0.0) continue;
                        if (!this.interninalog.getArtikalinterniracuns().contains(a)) {
                            this.getTable().insert((PzEntity)a, em);
                            continue;
                        }
                        em.merge((Object)a);
                    }
                    em.getTransaction().commit();
                    this.getTable().commitInsert();
                    this.getTable().refreshData();
                    if (this.zaReport.size() != 0) {
                        this.showReport();
                    }
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                        this.getTable().removeSelectedEntity(false, false);
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                }
            }
            finally {
                em.close();
                this.dispose();
            }
        }
    }

    private void dopuniStavke(Vector<Artikaldokument> artikalfakture, boolean storno, ArrayList<Artikalinterniracun> listaStavki, ArrayList<Artikalinterniracun> dodatnaListaStavki, boolean preracunCijena, EntityManager em) throws Exception {
        for (Artikaldokument artfaktura : artikalfakture) {
            double nabcen;
            Artikalinterniracun naNalogu;
            if (artfaktura.getTaksa("PDV").getOznTarGr().startsWith("U")) continue;
            boolean dalje = true;
            double kolicina = 0.0;
            boolean ima = false;
            String sifra = artfaktura.getId().getSfrProizvod();
            if (sifra.equals("17700") || sifra.equals("7869")) {
                System.out.println("--------");
            }
            if ((naNalogu = this.nadjiStavku(artfaktura.getId().getSfrProizvod(), listaStavki)) != null) {
                ima = true;
                kolicina = naNalogu.getKolicina();
                if (artfaktura.getCena() != naNalogu.getUlCena()) {
                    if (storno) {
                        this.zaReport.add(new DopunaPoProdaji("Vec uneto sa drugom cenom", artfaktura.getId().getSfrProizvod(), -artfaktura.getKolicina(), artfaktura.getCena()));
                    } else {
                        this.zaReport.add(new DopunaPoProdaji("Vec uneto sa drugom cenom", artfaktura.getId().getSfrProizvod(), artfaktura.getKolicina(), artfaktura.getCena()));
                        naNalogu.setTemp(1.0);
                    }
                    dalje = false;
                    if (preracunCijena) {
                        Artikalinterniracun naDodatnojListi = this.nadjiDodatnuStavku(artfaktura.getId().getSfrProizvod(), artfaktura.getCena(), dodatnaListaStavki);
                        if (naDodatnojListi == null) {
                            if (!storno) {
                                Artikalinterniracun dodartintrac = new Artikalinterniracun();
                                ArtikalinterniracunPK dodartintracpk = new ArtikalinterniracunPK(this.interninalog.getIdDok(), artfaktura.getId().getSfrProizvod(), 1);
                                dodartintrac.setId(dodartintracpk);
                                dodartintrac.setKolicina(artfaktura.getKolicina());
                                dodartintrac.setUlCena(BDConverter.getProdCena((double)artfaktura.getCena()).doubleValue());
                                dodatnaListaStavki.add(dodartintrac);
                            }
                        } else if (storno) {
                            if (naDodatnojListi.getKolicina() - artfaktura.getKolicina() >= 0.0) {
                                naDodatnojListi.setKolicina(naDodatnojListi.getKolicina() - artfaktura.getKolicina());
                            }
                        } else {
                            naDodatnojListi.setKolicina(naDodatnojListi.getKolicina() + artfaktura.getKolicina());
                        }
                    }
                }
            }
            if (!dalje) continue;
            Stanje naStanju = (Stanje)em.find(Stanje.class, (Object)new StanjePK(artfaktura.getId().getSfrProizvod(), this.interninalog.getIzlaznaRJ()));
            if (naStanju == null) {
                nabcen = 0.0;
                if (storno) {
                    this.zaReport.add(new DopunaPoProdaji("Cena u velikoprodaji je = 0", artfaktura.getId().getSfrProizvod(), -artfaktura.getKolicina(), artfaktura.getCena()));
                } else {
                    this.zaReport.add(new DopunaPoProdaji("Cena u velikoprodaji je = 0", artfaktura.getId().getSfrProizvod(), artfaktura.getKolicina(), artfaktura.getCena()));
                }
            } else {
                nabcen = naStanju.getProdCena();
            }
            if (nabcen == 0.0) continue;
            if (!ima) {
                Artikal artikal;
                if (storno || (artikal = (Artikal)PzEntityManager.find(Artikal.class, (Object)artfaktura.getId().getSfrProizvod())) == null) continue;
                this.artintrac = new Artikalinterniracun();
                this.artintracpk = new ArtikalinterniracunPK(this.interninalog.getIdDok(), artikal.getSfrProizvod(), this.interninalog.getNextRBrojArtikli());
                this.artintrac.setId(this.artintracpk);
                this.artintrac.init(artikal, (PzDokument)this.interninalog);
                if (storno) {
                    this.artintrac.setKolicina(-artfaktura.getKolicina());
                } else {
                    this.artintrac.setKolicina(artfaktura.getKolicina());
                }
                this.artintrac.setNaziv(artikal.getNaziv());
                this.artintrac.setIzlCena(nabcen);
                this.artintrac.setUlCena(BDConverter.getProdCena((double)artfaktura.getCena()).doubleValue());
                this.artintrac.setJm(artikal.getJedMere());
                this.artintrac.setProcRabata(0.0);
                this.artintrac.setProcMarze(0.0);
                this.artintrac.setCvProdajnaIznos(naStanju == null ? 0.0 : naStanju.getProdCena());
                this.artintrac.setIzlProdCena(naStanju == null ? new BigDecimal(0.0) : BDConverter.getProdCena((double)naStanju.getProdCena()));
                this.artintrac.setIzlProsNabCena(naStanju == null ? new BigDecimal(0.0) : naStanju.getProsNabCena());
                Stanje stanjeUlaz = (Stanje)em.find(Stanje.class, (Object)new StanjePK(artfaktura.getId().getSfrProizvod(), this.interninalog.getUlaznaRJ()));
                this.artintrac.setUlProdCena(BDConverter.getProdCena((double)this.artintrac.getUlCena()));
                this.artintrac.setUlProsNabCena(stanjeUlaz == null ? new BigDecimal(0.0) : stanjeUlaz.getProsNabCena());
                this.artintrac.setInterniracun(this.interninalog);
                listaStavki.add(this.artintrac);
                this.interninalog.setVredNaIzlazu(this.interninalog.getVredNaIzlazu().add(BDConverter.getIznos((double)(this.artintrac.getKolicina() * this.artintrac.getIzlCena()))));
                this.interninalog.setVredNaUlazu(this.interninalog.getVredNaUlazu().add(BDConverter.getIznos((double)(this.artintrac.getKolicina() * this.artintrac.getUlCena()))));
                Interniracun intrac = (Interniracun)em.find(Interniracun.class, (Object)this.interninalog.getIdDok());
                intrac.setVredNaIzlazu(this.interninalog.getVredNaIzlazu());
                intrac.setVredNaUlazu(this.interninalog.getVredNaUlazu());
                if (!PzParameter.getParameterValue((String)"INT_NAL_FORM_ALOC").equals("true")) continue;
                if (storno) {
                    naStanju.setAlocKolicina(naStanju.getAlocKolicina() - artfaktura.getKolicina());
                    continue;
                }
                naStanju.setAlocKolicina(naStanju.getAlocKolicina() + artfaktura.getKolicina());
                continue;
            }
            if (storno) {
                if (kolicina - artfaktura.getKolicina() >= 0.0) {
                    naNalogu.setKolicina(kolicina - artfaktura.getKolicina());
                    this.interninalog.setVredNaIzlazu(this.interninalog.getVredNaIzlazu().add(BDConverter.getIznos((double)(-artfaktura.getKolicina() * naNalogu.getIzlCena()))));
                    this.interninalog.setVredNaUlazu(this.interninalog.getVredNaUlazu().add(BDConverter.getIznos((double)(-artfaktura.getKolicina() * naNalogu.getUlCena()))));
                } else {
                    this.zaReport.add(new DopunaPoProdaji("Nedovoljna kol\u010dina na nalogu", artfaktura.getId().getSfrProizvod(), artfaktura.getKolicina(), artfaktura.getCena()));
                }
            } else {
                naNalogu.setKolicina(kolicina + artfaktura.getKolicina());
                this.interninalog.setVredNaIzlazu(this.interninalog.getVredNaIzlazu().add(BDConverter.getIznos((double)(artfaktura.getKolicina() * naNalogu.getIzlCena()))));
                this.interninalog.setVredNaUlazu(this.interninalog.getVredNaUlazu().add(BDConverter.getIznos((double)(artfaktura.getKolicina() * naNalogu.getUlCena()))));
            }
            Interniracun intrac = (Interniracun)em.find(Interniracun.class, (Object)this.interninalog.getIdDok());
            intrac.setVredNaIzlazu(this.interninalog.getVredNaIzlazu());
            intrac.setVredNaUlazu(this.interninalog.getVredNaUlazu());
            if (PzParameter.getParameterValue((String)"INT_NAL_FORM_ALOC").equals("true")) {
                if (storno) {
                    if (kolicina - artfaktura.getKolicina() >= 0.0) {
                        naStanju.setAlocKolicina(naStanju.getAlocKolicina() - artfaktura.getKolicina());
                    }
                } else {
                    naStanju.setAlocKolicina(naStanju.getAlocKolicina() + artfaktura.getKolicina());
                }
            }
            listaStavki.remove(naNalogu);
            listaStavki.add(naNalogu);
        }
    }

    private Artikalinterniracun nadjiStavku(String sifra, List<Artikalinterniracun> listaStavki) {
        for (Artikalinterniracun air : listaStavki) {
            if (!air.getId().getSfrProizvod().equals(sifra)) continue;
            return air;
        }
        return null;
    }

    private Artikalinterniracun nadjiDodatnuStavku(String sifra, double cena, List<Artikalinterniracun> listaStavki) {
        for (Artikalinterniracun air : listaStavki) {
            if (!air.getId().getSfrProizvod().equals(sifra) || air.getUlCena() != cena) continue;
            return air;
        }
        return null;
    }

    public void showReport() {
        try {
            Vector<Radnajedinica> data = new Vector<Radnajedinica>();
            data.addElement(this.interninalog.getUlaznaRJ());
            Vector<Vector<DopunaPoProdaji>> param2 = new Vector<Vector<DopunaPoProdaji>>();
            param2.addElement(this.zaReport);
            PzDataSource ds = new PzDataSource(data, param2);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("title", "");
            params.put("rj", this.interninalog.getRjUlaz());
            params.put("pocetniDatum", this.pocetniDatum.getVal());
            params.put("krajnjiDatum", this.krajnjiDatum.getVal());
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)"rs/pezar/reports/compiled/dopuna_po_prodaji.jasper", params, (String)"");
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void onInsert() {
    }

    protected void onUpdate() {
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Dopuna internog naloga po prodaji iz maloprodaje");
        this.setHeaderIcon("rs/pezar/interniprenos/resource/img/product_text.png");
    }

    protected void setHeaderOnUpdate() {
    }
}

