/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.interniprenos.gui.interniNalog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.interniprenos.PzExtensionLoader;
import rs.pezar.interniprenos.gui.PzDialogDokumenti;
import rs.pezar.sifarnici.gui.PzDialogUsera;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.UserLockUtility;

public class UzmiOdDrugogUSERa
extends PzDialog {
    private PzButton btnPotvrdi;
    private PzPanel plTabela;
    private PzPanel panelMain;
    private PzTable tabela;
    private JScrollPane scTabela;
    private PzPanel plGlavni;
    private PzButton btnOdaberi;
    private PzTextField userOpis;
    private PzTextField user;
    private JLabel jLabel1;
    private PzPanel panelUser;

    public UzmiOdDrugogUSERa(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Preuzimanje od drugog korisnika");
            this.panelMain = new PzPanel();
            this.panelMain.setPaintGradient(true);
            BorderLayout jPanel1Layout1 = new BorderLayout();
            this.getContentPane().add((Component)this.panelMain, "Center");
            this.panelMain.setLayout((LayoutManager)jPanel1Layout1);
            this.plGlavni = new PzPanel();
            this.plGlavni.setOpaque(false);
            this.panelMain.add((Component)this.plGlavni);
            GridBagLayout plGlavniLayout = new GridBagLayout();
            plGlavniLayout.rowWeights = new double[]{0.1, 0.0};
            plGlavniLayout.rowHeights = new int[]{7, 40};
            plGlavniLayout.columnWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            plGlavniLayout.columnWidths = new int[]{346, 20, 7, 20};
            this.plGlavni.setLayout((LayoutManager)plGlavniLayout);
            this.scTabela = new JScrollPane();
            this.plGlavni.add((Component)this.scTabela, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
            this.scTabela.setBackground(new Color(211, 242, 210));
            this.plTabela = new PzPanel();
            this.scTabela.setViewportView((Component)this.plTabela);
            BorderLayout jPanel1Layout = new BorderLayout();
            this.plTabela.setLayout((LayoutManager)jPanel1Layout);
            this.tabela = new PzTable();
            this.tabela.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    EntityManager em = PzEntityManager.getEm();
                    try {
                        try {
                            UzmiOdDrugogUSERa.this.preuzmi(UzmiOdDrugogUSERa.this.user.getVal(), em);
                        }
                        catch (UserLockUtility.UserLockException userLockException) {
                            PzSwingUtility.showErrorMessage((Component)((Object)UzmiOdDrugogUSERa.this), (String)"Izabrani korisnik na svom ra\u010dunaru trenutno ima aktivan ekran sa internim nalozima u pripremi.\nDa biste mogli da preuzmete njegove interne naloge u pripremi, korisnik mora da zatvori ekran sa internim nalozima u pripremi.\nPoku\u0161ajte ponovo.");
                            em.close();
                        }
                        catch (Exception ex) {
                            PzMysqlExceptionHandler.handle(null, (Throwable)ex);
                            em.close();
                        }
                    }
                    finally {
                        em.close();
                    }
                }
            });
            this.btnPotvrdi = new PzButton();
            this.plGlavni.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
            this.btnPotvrdi.setText("Preuzmi");
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/check.png")));
            this.btnPotvrdi.setEnabled(false);
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setActionCommand("Potvrdi");
            this.panelUser = new PzPanel();
            this.panelUser.setOpaque(false);
            this.panelMain.add((Component)this.panelUser, (Object)"North");
            GridBagLayout panelUserLayout = new GridBagLayout();
            this.panelUser.setPreferredSize(new Dimension(1378, 79));
            panelUserLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            panelUserLayout.rowHeights = new int[]{7, 25, 40};
            panelUserLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            panelUserLayout.columnWidths = new int[]{64, 120, 380, 7};
            this.panelUser.setLayout((LayoutManager)panelUserLayout);
            this.jLabel1 = new JLabel();
            this.panelUser.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 13, 0, 0), 0, 0));
            this.jLabel1.setText("Korisnik");
            this.user = new PzTextField();
            this.panelUser.add((Component)this.user, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.user.setFKField(Pzuser.class, PzDialogUsera.class, true, null);
            this.user.requestFocus();
            this.userOpis = new PzTextField();
            this.panelUser.add((Component)this.userOpis, (Object)new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 1, 11), 0, 0));
            this.userOpis.setEditable(false);
            this.userOpis.setFocusable(false);
            this.btnOdaberi = new PzButton();
            this.panelUser.add((Component)this.btnOdaberi, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
            this.btnOdaberi.setText("Potvrdi");
            this.btnOdaberi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/check.png")));
            this.btnOdaberi.addActionListener((ActionListener)((Object)this));
            this.btnOdaberi.setActionCommand("odaberi");
            this.pack();
            this.setRestorable(false);
            this.setMinimumSize(new Dimension(700, 350));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        String username = this.user.getVal();
        if (username.equals(PzExtensionLoader.getLoggedUser().getPzusername())) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Ulogovani ste kao izabrani korisnik! Odaberite drugog!", "Gre\u0161ka", 0);
            this.user.requestFocus();
        } else {
            EntityManager em = PzEntityManager.getEm();
            try {
                try {
                    if (actionCommand.equals("odaberi")) {
                        this.initializeTable(username, em);
                    } else if (actionCommand.equals("Potvrdi")) {
                        this.preuzmi(username, em);
                    }
                }
                catch (UserLockUtility.UserLockException userLockException) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Izabrani korisnik na svom ra\u010dunaru trenutno ima aktivan ekran sa fakturama u pripremi.\nDa biste mogli da preuzmete njegove fakture u pripremi, korisnik mora da zatvori ekran  sa fakturama u pripremi.\nPoku\u0161ajte ponovo.");
                    em.close();
                }
                catch (Exception ex) {
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
                    em.close();
                }
            }
            finally {
                em.close();
            }
        }
    }

    private void preuzmi(String username, EntityManager em) throws Exception {
        UserLockUtility.lockObject((String)username, (String)"fup");
        int rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Da li ste sigurni?!", (String)"Preuzimanje internog racuna od drugog korisnika", null, (boolean)true);
        if (rez == 0) {
            this.updateFaktura();
            ((PzDialogDokumenti)((Object)this.getParent())).refreshTable();
            this.initializeTable(username, em);
        }
        UserLockUtility.unLockObject((String)username, (String)"fup");
    }

    private void updateFaktura() throws Exception {
        Interniracun r = (Interniracun)this.tabela.getSelectedEntity();
        r.setUserKraj((Pzuser)PzEntityManager.find(Pzuser.class, (Object)PzExtensionLoader.getLoggedUser().getPzusername()));
        PzEntityManager.update((Object)r);
    }

    private void initializeTable(String username, EntityManager em) {
        Query q = null;
        String upit = "SELECT r FROM Interniracun r where r.userKraj.pzusername=:user and r.arhiviran = 0";
        upit = String.valueOf(upit) + " order by r.idDok";
        q = em.createQuery(upit);
        q.setParameter("user", (Object)username);
        Vector data = (Vector)q.getResultList();
        this.tabela.setData(data, Faktura.class);
        this.scTabela.setViewportView((Component)this.tabela);
        this.tabela.getTableHeader().setFocusable(false);
        this.tabela.requestFocusInWindow();
        if (this.tabela.getAllEntities().size() > 0) {
            this.tabela.setRowSelectionInterval(0, 0);
            this.btnPotvrdi.setEnabled(true);
        } else {
            this.btnPotvrdi.setEnabled(false);
            this.user.requestFocus();
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Pzuser) {
            Pzuser u = (Pzuser)entity;
            this.user.setText(u.getPzusername());
            this.userOpis.setText(String.valueOf(u.getIme()) + " " + u.getPrezime());
        }
    }

    public static Object getGUIBuilderInstance() {
        return new UzmiOdDrugogUSERa(Boolean.FALSE);
    }

    public UzmiOdDrugogUSERa(Boolean initGUI) {
    }
}

