/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.interniprenos.gui.povratnica;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikaldokument;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.ArtikalinterniracunPK;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.reports.PzDataSource;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.util.DopunaPoProdaji;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;

public class Dopuna
extends PzDialogInsert {
    private PzPanel mainPanel;
    private PzButton btnOk;
    private PzDateField krajnjiDatum;
    private PzDateField pocetniDatum;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private Interniracun povratnica;
    private Artikalinterniracun artintrac;
    private ArtikalinterniracunPK artintracpk;
    private Vector<DopunaPoProdaji> zaReport;

    public Dopuna(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public Dopuna(PzDialog dialog, boolean izmena, Object data1, Object data2) {
        super(dialog, izmena, (PzTable)data1, data2);
        this.povratnica = (Interniracun)data2;
    }

    protected void initGUI() {
        try {
            this.setTitle("Dopuna povratnice po prodaji");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            mainPanelLayout.columnWidths = new int[]{20, 90, 100, 20};
            mainPanelLayout.rowHeights = new int[]{35, 30, 50};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.btnOk = new PzButton();
            this.mainPanel.add((Component)this.btnOk, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOk.setText("Potvrdi");
            this.btnOk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/check.png")));
            this.btnOk.setPreferredSize(new Dimension(160, 30));
            this.btnOk.setActionCommand("OK");
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.jLabel2 = new JLabel();
            this.mainPanel.add((Component)this.jLabel2, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel2.setText("Krajnji datum:");
            this.krajnjiDatum = new PzDateField();
            this.mainPanel.add((Component)this.krajnjiDatum, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.krajnjiDatum.setPreferredSize(new Dimension(80, 25));
            this.krajnjiDatum.setFont(new Font("Tahoma", 0, 14));
            this.pocetniDatum = new PzDateField();
            this.mainPanel.add((Component)this.pocetniDatum, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.pocetniDatum.setPreferredSize(new Dimension(80, 25));
            this.pocetniDatum.setFont(new Font("Tahoma", 0, 14));
            this.jLabel1 = new JLabel();
            this.mainPanel.add((Component)this.jLabel1, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setText("Po\u010detni datum:");
            this.setPreferredSize(new Dimension(350, 200));
            this.setResizable(false);
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManager.getEm();
        String actionCommand = ((PzButton)e.getSource()).getActionCommand();
        if (actionCommand.equals("OK")) {
            try {
                Query q = em.createQuery("SELECT e FROM Artikaldokument e WHERE e.dokument.datPrometa >=:dat1 AND e.dokument.datPrometa <=:dat2 AND (e.dokument.tip=:tip1 OR e.dokument.tip=:tip2) AND e.dokument.radnajedinica=:rj AND e.dokument.arhiviran=1 AND e.dokument.storno=0");
                q.setParameter("dat1", (Object)this.pocetniDatum.getVal());
                q.setParameter("dat2", (Object)this.krajnjiDatum.getVal());
                q.setParameter("tip1", (Object)"FAKTURA");
                q.setParameter("tip2", (Object)"FISKALNI_RACUN");
                q.setParameter("rj", (Object)this.povratnica.getIzlaznaRJ());
                this.zaReport = new Vector();
                Vector artikalfakture = (Vector)q.getResultList();
                q = em.createQuery("SELECT e FROM Artikaldokument e WHERE e.dokument.datPrometa >=:dat1 AND e.dokument.datPrometa <=:dat2 AND (e.dokument.tip=:tip1 OR e.dokument.tip=:tip2) AND e.dokument.radnajedinica=:rj AND e.dokument.arhiviran=1 AND e.dokument.storno=1");
                q.setParameter("dat1", (Object)this.pocetniDatum.getVal());
                q.setParameter("dat2", (Object)this.krajnjiDatum.getVal());
                q.setParameter("tip1", (Object)"FAKTURA");
                q.setParameter("tip2", (Object)"FISKALNI_RACUN");
                q.setParameter("rj", (Object)this.povratnica.getIzlaznaRJ());
                Vector artikalfaktureStorno = (Vector)q.getResultList();
                if (artikalfaktureStorno.size() == 0) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Nema podataka za dopunu.", "Obave\u0161tenje", 1);
                    return;
                }
                try {
                    em.getTransaction().begin();
                    ArrayList<Artikalinterniracun> listaStavki = new ArrayList<Artikalinterniracun>();
                    listaStavki.addAll(this.povratnica.getArtikalinterniracuns());
                    this.dopuniStavke(artikalfaktureStorno, true, listaStavki, em);
                    this.dopuniStavke(artikalfakture, false, listaStavki, em);
                    for (Artikalinterniracun a : listaStavki) {
                        if (!this.povratnica.getArtikalinterniracuns().contains(a)) {
                            this.getTable().insert((PzEntity)a, em);
                            continue;
                        }
                        em.merge((Object)a);
                    }
                    em.getTransaction().commit();
                    this.getTable().commitInsert();
                    this.getTable().refreshData();
                    if (this.zaReport.size() != 0) {
                        this.showReport();
                    }
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                        this.getTable().removeSelectedEntity(false, false);
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                }
            }
            finally {
                em.close();
                this.dispose();
            }
        }
    }

    private void dopuniStavke(Vector<Artikaldokument> artikalfakture, boolean storno, ArrayList<Artikalinterniracun> listaStavki, EntityManager em) throws Exception {
        boolean prnc = false;
        boolean veleprodaja = this.povratnica.getUlaznaRJ().getgTip().equals("V");
        if (this.povratnica.getUlaznaRJ().getNacinVodjenja().equals("PRNC")) {
            prnc = true;
        }
        for (Artikaldokument artfaktura : artikalfakture) {
            double nabcen;
            Stanje naStanju;
            Artikalinterniracun naNalogu;
            double kolicina = 0.0;
            boolean ima = false;
            String sifra = artfaktura.getId().getSfrProizvod();
            if (sifra.equals("46639071")) {
                System.out.println("--------");
            }
            if ((naNalogu = this.nadjiStavku(artfaktura.getId().getSfrProizvod(), listaStavki)) != null) {
                ima = true;
                kolicina = naNalogu.getKolicina();
            }
            if ((naStanju = (Stanje)em.find(Stanje.class, (Object)new StanjePK(artfaktura.getId().getSfrProizvod(), this.povratnica.getIzlaznaRJ()))) == null) {
                nabcen = 0.0;
                if (storno) {
                    this.zaReport.add(new DopunaPoProdaji("Cena u maloprodaji je = 0", artfaktura.getId().getSfrProizvod(), artfaktura.getKolicina(), artfaktura.getCena()));
                } else {
                    this.zaReport.add(new DopunaPoProdaji("Cena u maloprodaji je = 0", artfaktura.getId().getSfrProizvod(), -artfaktura.getKolicina(), artfaktura.getCena()));
                }
            } else {
                nabcen = naStanju.getProdCena();
            }
            if (nabcen == 0.0) continue;
            if (!ima) {
                if (!storno) continue;
                Artikal artikal = (Artikal)PzEntityManager.find(Artikal.class, (Object)artfaktura.getId().getSfrProizvod());
                Stanje stanjeVeleprodaja = (Stanje)em.find(Stanje.class, (Object)new StanjePK(artfaktura.getId().getSfrProizvod(), this.povratnica.getUlaznaRJ()));
                if (artikal == null) continue;
                this.artintrac = new Artikalinterniracun();
                this.artintracpk = new ArtikalinterniracunPK(this.povratnica.getIdDok(), artikal.getSfrProizvod(), this.povratnica.getNextRBrojArtikli());
                this.artintrac.setId(this.artintracpk);
                this.artintrac.init(artikal, (PzDokument)this.povratnica);
                this.artintrac.setKolicina(artfaktura.getKolicina());
                this.artintrac.setNaziv(artikal.getNaziv());
                this.artintrac.setIzlCena(nabcen);
                if (stanjeVeleprodaja != null) {
                    if (veleprodaja && prnc) {
                        this.artintrac.setUlCena(stanjeVeleprodaja.getProsNabCena().doubleValue());
                    } else {
                        this.artintrac.setUlCena(stanjeVeleprodaja.getProdCena());
                    }
                } else {
                    this.artintrac.setUlCena(BDConverter.getIznos((double)(naStanju.getProdCena() / (1.0 + artikal.getTarifnaGrupa("PDV").getStopa() / 100.0))).doubleValue());
                }
                this.artintrac.setJm(artikal.getJedMere());
                this.artintrac.setProcRabata(0.0);
                this.artintrac.setProcMarze(0.0);
                this.artintrac.setCvProdajnaIznos(this.artintrac.getUlCena());
                this.artintrac.setIzlProdCena(naStanju == null ? new BigDecimal(0.0) : BDConverter.getProdCena((double)naStanju.getProdCena()));
                this.artintrac.setIzlProsNabCena(naStanju == null ? new BigDecimal(0.0) : naStanju.getProsNabCena());
                if (prnc) {
                    this.artintrac.setUlProdCena(stanjeVeleprodaja == null ? new BigDecimal(0.0) : BDConverter.getProdCena((double)stanjeVeleprodaja.getProdCena()));
                    this.artintrac.setUlProsNabCena(BDConverter.getPrnc((double)this.artintrac.getUlCena()));
                } else {
                    this.artintrac.setUlProdCena(BDConverter.getProdCena((double)this.artintrac.getUlCena()));
                    this.artintrac.setUlProsNabCena(stanjeVeleprodaja == null ? new BigDecimal(0.0) : stanjeVeleprodaja.getProsNabCena());
                }
                this.artintrac.setInterniracun(this.povratnica);
                listaStavki.add(this.artintrac);
                this.povratnica.setVredNaIzlazu(this.povratnica.getVredNaIzlazu().add(BDConverter.getIznos((double)(this.artintrac.getKolicina() * this.artintrac.getIzlCena()))));
                this.povratnica.setVredNaUlazu(this.povratnica.getVredNaUlazu().add(BDConverter.getIznos((double)(this.artintrac.getKolicina() * this.artintrac.getUlCena()))));
                Interniracun intrac = (Interniracun)em.find(Interniracun.class, (Object)this.povratnica.getIdDok());
                intrac.setVredNaIzlazu(this.povratnica.getVredNaIzlazu());
                intrac.setVredNaUlazu(this.povratnica.getVredNaUlazu());
                if (!PzParameter.getParameterValue((String)"INT_NAL_FORM_ALOC").equals("true")) continue;
                naStanju.setAlocKolicina(naStanju.getAlocKolicina() + artfaktura.getKolicina());
                continue;
            }
            if (storno) {
                naNalogu.setKolicina(kolicina + artfaktura.getKolicina());
                this.povratnica.setVredNaIzlazu(this.povratnica.getVredNaIzlazu().add(BDConverter.getIznos((double)(artfaktura.getKolicina() * naNalogu.getIzlCena()))));
                this.povratnica.setVredNaUlazu(this.povratnica.getVredNaUlazu().add(BDConverter.getIznos((double)(artfaktura.getKolicina() * naNalogu.getUlCena()))));
            } else if (kolicina - artfaktura.getKolicina() >= 0.0) {
                naNalogu.setKolicina(kolicina - artfaktura.getKolicina());
                this.povratnica.setVredNaIzlazu(this.povratnica.getVredNaIzlazu().add(BDConverter.getIznos((double)(-artfaktura.getKolicina() * naNalogu.getIzlCena()))));
                this.povratnica.setVredNaUlazu(this.povratnica.getVredNaUlazu().add(BDConverter.getIznos((double)(-artfaktura.getKolicina() * naNalogu.getUlCena()))));
            } else {
                this.zaReport.add(new DopunaPoProdaji("Nedovoljna kol\u010dina na povratnici", artfaktura.getId().getSfrProizvod(), artfaktura.getKolicina(), artfaktura.getCena()));
            }
            Interniracun intrac = (Interniracun)em.find(Interniracun.class, (Object)this.povratnica.getIdDok());
            intrac.setVredNaIzlazu(this.povratnica.getVredNaIzlazu());
            intrac.setVredNaUlazu(this.povratnica.getVredNaUlazu());
            if (PzParameter.getParameterValue((String)"INT_NAL_FORM_ALOC").equals("true")) {
                if (storno) {
                    naStanju.setAlocKolicina(naStanju.getAlocKolicina() + artfaktura.getKolicina());
                } else if (kolicina - artfaktura.getKolicina() >= 0.0) {
                    naStanju.setAlocKolicina(naStanju.getAlocKolicina() - artfaktura.getKolicina());
                }
            }
            listaStavki.remove(naNalogu);
            if (naNalogu.getKolicina() == 0.0) continue;
            listaStavki.add(naNalogu);
        }
    }

    private Artikalinterniracun nadjiStavku(String sifra, List<Artikalinterniracun> listaStavki) {
        for (Artikalinterniracun air : listaStavki) {
            if (!air.getId().getSfrProizvod().equals(sifra)) continue;
            return air;
        }
        return null;
    }

    public void showReport() {
        try {
            Vector<Radnajedinica> data = new Vector<Radnajedinica>();
            data.addElement(this.povratnica.getIzlaznaRJ());
            Vector<Vector<DopunaPoProdaji>> param2 = new Vector<Vector<DopunaPoProdaji>>();
            param2.addElement(this.zaReport);
            PzDataSource ds = new PzDataSource(data, param2);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("title", "");
            params.put("rj", this.povratnica.getIzlaznaRJ());
            params.put("pocetniDatum", this.pocetniDatum.getVal());
            params.put("krajnjiDatum", this.krajnjiDatum.getVal());
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)"rs/pezar/reports/compiled/dopuna_po_prodaji.jasper", params, (String)"");
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void onInsert() {
    }

    protected void onUpdate() {
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Dopuna povratnice po prodaji iz maloprodaje");
        this.setHeaderIcon("rs/pezar/interniprenos/resource/img/product_text.png");
    }

    protected void setHeaderOnUpdate() {
    }
}

