/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.interniprenos.transformation;

import java.awt.Component;
import java.sql.Date;
import java.util.HashMap;
import javax.persistence.EntityManager;
import rs.pezar.core.transformation.DefaultDokumentTransformer;
import rs.pezar.core.transformation.DokumentTransformer;
import rs.pezar.core.transformation.TransformationException;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.interniprenos.gui.PzDialogDokumenti;
import rs.pezar.interniprenos.gui.PzDialogInterniNalogPregled;
import rs.pezar.interniprenos.transformation.InterniNalogTransformerParametri;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;
import util.PzInterniNalogUtil;

public class InterniNalogTransformer
extends DokumentTransformer {
    public static final String TRANSFORMER = "INTERNI_NALOG_TRANSFORMER";
    public static final String PARAMETER_RJ_IZLAZ = "IZLAZNA_RJ";
    public static final String PARAMETER_RJ_ULAZ = "ULAZNA_RJ";
    public static final String PARAMETER_TIP = "TIP_DOKUMENTA";
    private static final String PARAMETER_MARZA = "MARZA";
    private boolean priprema = false;

    public HashMap<String, Object> getDokumentParameters(PzDialog parent, Lista l) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        try {
            this.setParametars(parent, parameters);
        }
        catch (TransformationException e) {
            PzSwingUtility.showErrorMessage((Component)parent, (String)e.getMessage());
        }
        if (parameters.get(PARAMETER_RJ_ULAZ) == null) {
            return null;
        }
        parameters.put(PARAMETER_TIP, "INTERNI_NALOG");
        parent.getSession().putParameter(TRANSFORMER, parameters);
        parent.showDialog(InterniNalogTransformerParametri.class);
        parent.getSession().putParameter(TRANSFORMER, null);
        if (parameters.get(PARAMETER_MARZA) == null) {
            return null;
        }
        return parameters;
    }

    private void setParametars(PzDialog parent, HashMap<String, Object> parameters) throws TransformationException {
        Radnajedinica izlaznaRJ = PzDialogRJ.getRJ((PzDialog)parent, (String[])new String[]{"V", "VR", "VS", "T", "G"});
        Radnajedinica ulaznaRJ = PzDialogRJ.getRJ((PzDialog)parent, (String[])new String[]{"EL", "EV", "ET", "ELK", "EP", "EW", "ELR"});
        if (izlaznaRJ != null && ulaznaRJ != null) {
            if (izlaznaRJ.getgTip().equals("G") && !ulaznaRJ.getpTip().equals("P") && !ulaznaRJ.getpTip().equals("W")) {
                throw new TransformationException("Gre\u0161ka! Prodavnica ulaza nije prodavnica SOPSTVENIH PROIZVODA");
            }
            if (izlaznaRJ.getgTip().equals("V") && (ulaznaRJ.getpTip().equals("P") || ulaznaRJ.getpTip().equals("W") || ulaznaRJ.getpTip().equals("T"))) {
                throw new TransformationException("Gre\u0161ka! Prodavnica ulaza nije prodavnica TRGOVA\u010cKE ROBE");
            }
            if (izlaznaRJ.getgTip().equals("T") && !ulaznaRJ.getpTip().equals("T")) {
                throw new TransformationException("Gre\u0161ka! Prodavnica ulaza nije KONSIGNACIONA prodavnica");
            }
        }
        parameters.put(PARAMETER_RJ_IZLAZ, izlaznaRJ);
        parameters.put(PARAMETER_RJ_ULAZ, ulaznaRJ);
    }

    public PzDokument getDokumentToTransform(PzDialog parent) {
        PzChoice[] choices = new PzChoice[]{new PzChoice("Interni nalog iz arhive", (Object)"ARHIVA"), new PzChoice("Interni nalog u pripremi", (Object)"U_PRIPREMI")};
        String choice = (String)PzDialogChoice.showPzDialogChoice((PzDialog)parent, (PzChoice[])choices, (String)"Izabor internog naloga");
        if (choice == null) {
            return null;
        }
        if (choice.equals("ARHIVA")) {
            return PzDialogInterniNalogPregled.getInterniRacunIzArhive(parent);
        }
        this.priprema = true;
        return PzDialogDokumenti.getInterniRacunUPripermi(parent, "Interniracun");
    }

    public PzDokument toDokument(Lista l, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        System.out.println("Lista ima artikala:" + l.getArtikallistas().size());
        return PzInterniNalogUtil.toInterniRacun(l, parameters, em);
    }

    public Lista toLista(PzDokument dokument, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        Lista l = new DefaultDokumentTransformer(Interniracun.class, Artikalinterniracun.class).toLista(dokument, parameters, em);
        if (this.priprema) {
            l.setNaslov("INTERNI NALOG OD " + PzDateUtility.formatDate((Date)dokument.getDatum()));
        }
        return l;
    }

    public String getName() {
        return "Transformator internog naloga";
    }

    public String getDescription() {
        return null;
    }
}

