/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.interniprenos.transformation;

import java.awt.Component;
import java.sql.Date;
import java.util.HashMap;
import javax.persistence.EntityManager;
import rs.pezar.core.transformation.DefaultDokumentTransformer;
import rs.pezar.core.transformation.DokumentTransformer;
import rs.pezar.core.transformation.TransformationException;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.interniprenos.gui.PzDialogDokumentiPrimopredajnica;
import rs.pezar.interniprenos.gui.PzDialogPrimopredajnicaPregled;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;
import util.PzInterniNalogUtil;

public class PrimopredajnicaTransformer
extends DokumentTransformer {
    public static final String TRANSFORMER = "FAKTURA_TRANSFORMER";
    public static final String PARAMETER_RJ_IZLAZ = "IZLAZNA_RJ";
    public static final String PARAMETER_RJ_ULAZ = "ULAZNA_RJ";
    public static final String PARAMETER_TIP = "TIP_DOKUMENTA";
    private boolean priprema;

    public HashMap<String, Object> getDokumentParameters(PzDialog parent, Lista l) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        try {
            this.setParametars(parent, parameters);
        }
        catch (TransformationException e) {
            PzSwingUtility.showErrorMessage((Component)parent, (String)e.getMessage());
        }
        parameters.put(PARAMETER_TIP, "PRIMO_PREDAJNICA");
        if (parameters.get(PARAMETER_RJ_ULAZ) == null) {
            return null;
        }
        return parameters;
    }

    private void setParametars(PzDialog parent, HashMap<String, Object> parameters) throws TransformationException {
        Radnajedinica izlaznaRJ = PzDialogRJ.getRJ((PzDialog)parent, (String[])new String[]{"V", "VR", "VS", "EL", "EV", "ET", "ELK", "EP", "EW", "ELR"});
        Radnajedinica ulaznaRJ = PzDialogRJ.getRJ((PzDialog)parent, (String[])new String[]{"V", "VR", "VS", "EL", "EV", "ET", "ELK", "EP", "EW", "ELR"});
        if (izlaznaRJ != null && ulaznaRJ != null) {
            if (izlaznaRJ.getId().getOznOgranak().equals(ulaznaRJ.getId().getOznOgranak()) && izlaznaRJ.getId().getOznRj().equals(ulaznaRJ.getId().getOznRj())) {
                throw new TransformationException("Gre\u0161ka! Morate odabrati razli\u010dite radne jedinice");
            }
            if (izlaznaRJ.getgTip().equals("V") && !ulaznaRJ.getgTip().equals("V")) {
                throw new TransformationException("Gre\u0161ka! Ulazni magacin mora da bude VELIKOPRODAJA");
            }
            if (izlaznaRJ.getgTip().equals("E") && !ulaznaRJ.getgTip().equals("E")) {
                throw new TransformationException("Gre\u0161ka! Ulazni magacin mora da bude MALOPRODAJA");
            }
            if (izlaznaRJ.getgTip().equals("E") && ulaznaRJ.getgTip().equals("E")) {
                if ((izlaznaRJ.getpTip().equals("L") || izlaznaRJ.getpTip().equals("V")) && !ulaznaRJ.getpTip().equals("L") && !ulaznaRJ.getpTip().equals("V")) {
                    throw new TransformationException("Gre\u0161ka! Ne me\u0161aju se prodavnice trgova\u010dke robe i sopstvenih proizvoda");
                }
                if ((izlaznaRJ.getpTip().equals("P") || izlaznaRJ.getpTip().equals("W")) && !ulaznaRJ.getpTip().equals("P") && !ulaznaRJ.getpTip().equals("W")) {
                    throw new TransformationException("Gre\u0161ka! Ne me\u0161aju se prodavnice trgova\u010dke robe i sopstvenih proizvoda");
                }
            }
            parameters.put(PARAMETER_RJ_IZLAZ, izlaznaRJ);
            parameters.put(PARAMETER_RJ_ULAZ, ulaznaRJ);
        }
    }

    public PzDokument getDokumentToTransform(PzDialog parent) {
        PzChoice[] choices = new PzChoice[]{new PzChoice("Primopredajnica iz arhive", (Object)"ARHIVA"), new PzChoice("Primopredajnica u pripremi", (Object)"U_PRIPREMI")};
        String choice = (String)PzDialogChoice.showPzDialogChoice((PzDialog)parent, (PzChoice[])choices, (String)"Izabor primopredajnice");
        if (choice == null) {
            return null;
        }
        if (choice.equals("ARHIVA")) {
            return PzDialogPrimopredajnicaPregled.getInterniRacunIzArhive(parent);
        }
        this.priprema = true;
        return PzDialogDokumentiPrimopredajnica.getInterniRacunUPripermi(parent, "Interniracun");
    }

    public PzDokument toDokument(Lista l, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        return PzInterniNalogUtil.toInterniRacun(l, parameters, em);
    }

    public Lista toLista(PzDokument dokument, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        Lista l = new DefaultDokumentTransformer(Interniracun.class, Artikalinterniracun.class).toLista(dokument, parameters, em);
        if (this.priprema) {
            l.setNaslov("PRIMO_PREDAJNICA OD " + PzDateUtility.formatDate((Date)dokument.getDatum()));
        }
        return l;
    }

    public String getName() {
        return "Transformator primopredajnice";
    }

    public String getDescription() {
        return null;
    }
}

