/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application.session;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JFrame;
import org.jdesktop.application.session.PropertySupport;
import org.jdesktop.application.session.WindowState;
import org.jdesktop.application.utils.SwingHelper;

public class WindowProperty
implements PropertySupport {
    private void checkComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (!(component instanceof Window)) {
            throw new IllegalArgumentException("invalid component");
        }
    }

    private int getScreenCount() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length;
    }

    @Override
    public Object getSessionState(Component c) {
        GraphicsConfiguration gc;
        this.checkComponent(c);
        int frameState = 0;
        if (c instanceof Frame) {
            frameState = ((Frame)c).getExtendedState();
        }
        Rectangle gcBounds = (gc = c.getGraphicsConfiguration()) == null ? null : gc.getBounds();
        Rectangle frameBounds = c.getBounds();
        if (c instanceof JFrame && (frameState & 6) != 0) {
            frameBounds = SwingHelper.getWindowNormalBounds((JFrame)c);
        }
        if (frameBounds.isEmpty()) {
            return null;
        }
        return new WindowState(frameBounds, gcBounds, this.getScreenCount(), frameState);
    }

    @Override
    public void setSessionState(Component c, Object state) {
        this.checkComponent(c);
        if (state != null && !(state instanceof WindowState)) {
            throw new IllegalArgumentException("invalid state");
        }
        Window w = (Window)c;
        WindowState windowState = (WindowState)state;
        SwingHelper.putWindowNormalBounds(w, windowState.getBounds());
        if (!w.isLocationByPlatform() && state != null) {
            Rectangle gcBounds0 = windowState.getGraphicsConfigurationBounds();
            if (gcBounds0 != null && SwingHelper.isResizable(w)) {
                if (SwingHelper.computeVirtualGraphicsBounds().contains(gcBounds0.getLocation())) {
                    w.setBounds(windowState.getBounds());
                } else {
                    w.setSize(windowState.getBounds().getSize());
                }
            }
            if (w instanceof Frame) {
                ((Frame)w).setExtendedState(windowState.getFrameState());
            }
        }
    }
}

