/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.databaseEngine;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import rs.pezar.kasa.databaseEngine.exception.FiscalBaseException;
import rs.pezar.msg.device.cashregister.data.Article;
import rs.pezar.msg.device.interfaces.cashRegister.BillInterface;

public class DatabaseEngine {
    private Connection conn;
    private String databasePath;
    private String baseName;

    public DatabaseEngine(String workingDirectory, String workingSubfolder, String baseName) throws FiscalBaseException {
        File path;
        if (workingSubfolder == null) {
            workingSubfolder = "";
        }
        if (workingDirectory == null) {
            workingDirectory = "\\pezardevice";
        }
        if (!(path = new File(String.valueOf(workingDirectory) + "\\" + workingSubfolder + "\\")).exists() && !path.mkdirs()) {
            throw new FiscalBaseException("Nemoguce kreirati direktorijum za smestanje fiskalne baze");
        }
        this.databasePath = String.valueOf(workingDirectory) + "\\" + workingSubfolder + "\\" + baseName;
        this.baseName = baseName;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void setConnection(Connection connection) {
        this.conn = connection;
    }

    private void openConn() throws FiscalBaseException {
        try {
            Class.forName("org.sqlite.JDBC");
            this.conn = DriverManager.getConnection("jdbc:sqlite:" + this.databasePath + ".db");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FiscalBaseException("Otvaranje fiskalne baze neuspelo, putanja: " + this.databasePath);
        }
    }

    private void closeConn() throws FiscalBaseException {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new FiscalBaseException("Zatvaranje fiskalne baze neuspelo, putanja: " + this.databasePath);
        }
    }

    public void createDatabase() throws FiscalBaseException {
        this.openConn();
        try {
            Statement stat = this.conn.createStatement();
            stat.executeUpdate("create table if not exists " + this.baseName + " (plu, sifra, naziv);");
            stat.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new FiscalBaseException("Zatvaranje fiskalne baze neuspelo, putanja: " + this.databasePath);
        }
        this.closeConn();
    }

    public void deletePluRecord(String plu) throws FiscalBaseException {
        this.openConn();
        try {
            Statement stat = this.conn.createStatement();
            int brRecords = stat.executeUpdate("delete from " + this.baseName + " where plu='" + Integer.parseInt(plu) + "';");
            System.out.print("Broj obrisanih u fiskalnoj bazi:" + brRecords);
            stat.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new FiscalBaseException("Brisanje artikla iz baze neuspelo, putanja: " + this.databasePath);
        }
        this.closeConn();
    }

    public void setPlu(String sifra, String plu, String naziv) throws FiscalBaseException {
        this.openConn();
        try {
            PreparedStatement prep = this.conn.prepareStatement("insert into " + this.baseName + " values (?, ?, ?);");
            prep.setString(1, plu);
            prep.setString(2, sifra);
            prep.setString(3, naziv);
            prep.addBatch();
            this.conn.setAutoCommit(false);
            prep.executeBatch();
            this.conn.setAutoCommit(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FiscalBaseException("Upisivanje u bazu neuspelo, baza: " + this.databasePath);
        }
        this.closeConn();
    }

    public String getSifra(String plu) throws FiscalBaseException {
        String sifra = null;
        this.openConn();
        try {
            Statement stat = this.conn.createStatement();
            ResultSet rs = stat.executeQuery(String.format("select sifra,plu from " + this.baseName + " where plu='%s';", plu));
            while (rs.next()) {
                sifra = rs.getString("sifra");
            }
            rs.close();
            stat.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FiscalBaseException("Citanje iz baze neuspelo, baza: " + this.databasePath);
        }
        this.closeConn();
        return sifra;
    }

    public String getNaziv(String sifra) throws FiscalBaseException {
        String naziv = null;
        this.openConn();
        try {
            Statement stat = this.conn.createStatement();
            ResultSet rs = stat.executeQuery(String.format("select naziv from " + this.baseName + " where sifra='%s';", sifra));
            while (rs.next()) {
                naziv = rs.getString("naziv");
            }
            rs.close();
            stat.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FiscalBaseException("Citanje naziva iz baze neuspelo, baza: " + this.databasePath);
        }
        this.closeConn();
        return naziv;
    }

    public String getPlu(String sifra) throws FiscalBaseException {
        String plu = null;
        this.openConn();
        try {
            Statement stat = this.conn.createStatement();
            ResultSet rs = stat.executeQuery(String.format("select sifra,plu from " + this.baseName + " where sifra='%s';", sifra));
            while (rs.next()) {
                plu = rs.getString("plu");
            }
            rs.close();
            stat.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FiscalBaseException("Citanje plu-a iz baze neuspelo, baza: " + this.databasePath);
        }
        return plu;
    }

    public void dropDatabase() throws FiscalBaseException {
        Statement stat;
        this.openConn();
        try {
            stat = this.conn.createStatement();
            stat.executeUpdate("drop table if exists " + this.baseName + ";");
            stat.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new FiscalBaseException("Drop funkcija nad fiskalnom bazom neuspela.");
        }
        this.closeConn();
        this.openConn();
        try {
            stat = this.conn.createStatement();
            stat.executeUpdate("create table if not exists " + this.baseName + " (plu, sifra, naziv);");
            stat.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new FiscalBaseException("Create funkcija nad fiskalnom bazom neuspela.");
        }
        this.closeConn();
    }

    public Integer getNumberOfRows() throws FiscalBaseException {
        Integer numberOfRows;
        this.openConn();
        try {
            Statement stat = this.conn.createStatement();
            ResultSet rs = stat.executeQuery(String.format("select COUNT(plu) FROM " + this.baseName + " AS count;", new Object[0]));
            numberOfRows = rs.getInt(1);
            rs.close();
            stat.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FiscalBaseException("Citanje iz baze neuspelo, baza: " + this.databasePath);
        }
        this.closeConn();
        return numberOfRows;
    }

    public Integer getMaxTemp() throws FiscalBaseException {
        Integer temp;
        this.openConn();
        try {
            Statement stat = this.conn.createStatement();
            ResultSet rs = stat.executeQuery("select max(sifra) FROM " + this.baseName + " WHERE sifra like 'temp%';");
            String tempStr = rs.getString(1);
            temp = tempStr == null || "".equals(tempStr) ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(tempStr.replace("temp", "")));
            rs.close();
            stat.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FiscalBaseException("Citanje iz baze neuspelo, baza: " + this.databasePath);
        }
        this.closeConn();
        return temp;
    }

    public void checkNames(BillInterface bill) throws FiscalBaseException {
        Integer length = bill.getArticles().size();
        int i = 0;
        while (i < length) {
            String naziv = this.getNaziv(((Article)bill.getArticles().get(i)).getSifra());
            String naziv1 = ((Article)bill.getArticles().get(i)).getName();
            if (naziv != null && !naziv1.equals(naziv)) {
                throw new FiscalBaseException("Detektovana promena naziva artikla u bazi, da bi mogli da odstampate ovaj racun,\npotrebno je da prvo ispraznite sve artikle iz baze ili da vratite stari naziv. Sifra:" + ((Article)bill.getArticles().get(i)).getSifra() + ", naziv:" + ((Article)bill.getArticles().get(i)).getNameNoPlu() + ", naziv u printeru:" + naziv.substring(2, naziv.length()) + ", pozicija na racunu: " + String.valueOf(i + 1));
            }
            ++i;
        }
    }
}

