/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.fsm;

import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.util.HashMap;
import java.util.TooManyListenersException;
import rs.pezar.kasa.cashregister.CashRegisterControl;
import rs.pezar.kasa.commporthandler.DevicePort;
import rs.pezar.kasa.exceptions.GeneralException;
import rs.pezar.kasa.fsm.State;
import rs.pezar.kasa.fsm.StateLogger;
import rs.pezar.kasa.messages.Messages;

public class InitState
extends State {
    public static final String STATE_NAME = "INIT_STATE";
    CashRegisterControl control;
    DevicePort crport;
    Messages returnedData;
    StateLogger loggedPort;

    public InitState(HashMap<String, Object> params) {
        this.stateName = STATE_NAME;
        this.returnedData = (Messages)params.get("DATA");
        this.control = (CashRegisterControl)params.get("CONTROL");
        this.loggedPort = (StateLogger)params.get("LOGGEDPORT");
        this.crport = this.loggedPort.getDevicePort();
    }

    @Override
    public synchronized void run() {
        this.initialSequence();
    }

    public void initialSequence() {
        try {
            this.crport.OpenPort();
        }
        catch (GeneralException e) {
            this.nextState = 5;
            this.returnedData.addError("ERROR|FSM:Greska prilikom citanja sa COM porta");
            e.printStackTrace();
        }
        catch (PortInUseException e) {
            this.nextState = 5;
            this.returnedData.addError("ERROR|FSM:COM Port je zauzet");
            e.printStackTrace();
        }
        catch (IOException e) {
            this.nextState = 5;
            this.returnedData.addError("ERROR|FSM:Greska prilikom pisanja na COM port");
            e.printStackTrace();
        }
        catch (UnsupportedCommOperationException e) {
            this.nextState = 5;
            this.returnedData.addError("ERROR|FSM:Greska prilikom pisanja na COM port");
            e.printStackTrace();
        }
        catch (TooManyListenersException e) {
            this.nextState = 5;
            this.returnedData.addError("ERROR|FSM:Greska prilikom pisanja na COM port");
            e.printStackTrace();
        }
        catch (Exception e) {
            this.nextState = 5;
            e.printStackTrace();
        }
        this.nextState = 2;
    }
}

