/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.fsm;

import java.io.IOException;
import rs.pezar.kasa.commporthandler.DevicePort;
import rs.pezar.kasa.exceptions.GeneralException;
import rs.pezar.kasa.roundlogger.DeviceLogger;

public class StateLogger {
    DeviceLogger deviceLogger;
    DevicePort devicePort;

    public StateLogger(DeviceLogger deviceLogger, DevicePort devicePort) {
        this.deviceLogger = deviceLogger;
        this.devicePort = devicePort;
    }

    public void loggedWrite(String message, int length, String logId, String text) throws IOException {
        this.deviceLogger.logData(logId, "D", message.substring(0, message.lastIndexOf(3) + 1).getBytes(), text);
        this.devicePort.writeToPort(message, length);
    }

    public void writeToPort(byte[] message, int length, String logId, String text) throws IOException {
        this.deviceLogger.logData(logId, "D", message, text);
        this.devicePort.writeToPort(message, length);
    }

    public byte[] loggedRead(int secondsToWait, String logId, String text) throws GeneralException, InterruptedException {
        byte[] from = this.devicePort.readFromPort(secondsToWait);
        this.deviceLogger.logData(logId, "U", from, text);
        return from;
    }

    public DeviceLogger getDeviceLogger() {
        return this.deviceLogger;
    }

    public void setDeviceLogger(DeviceLogger deviceLogger) {
        this.deviceLogger = deviceLogger;
    }

    public DevicePort getDevicePort() {
        return this.devicePort;
    }

    public void setDevicePort(DevicePort devicePort) {
        this.devicePort = devicePort;
    }
}

