/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.roundlogger;

import java.text.SimpleDateFormat;
import java.util.Vector;
import rs.pezar.kasa.roundlogger.LogHelper.LogHelper;
import rs.pezar.kasa.roundlogger.buffer.TransactBuffer;
import rs.pezar.kasa.roundlogger.buffer.TransactBufferEntity;
import rs.pezar.kasa.roundlogger.resources.TxtLogger;

public class DeviceLogger {
    public static final boolean TRANSACT_lOG = true;
    public static final byte LOG_LIMIT_TRANSACTIONS = 100;
    public static final byte TO_FILE = 1;
    public static final byte TO_IOSTREAM = 16;
    public static final String resourceName = "log.txt";
    TxtLogger txtLogger;
    TransactBuffer buffer;
    Integer transactionId;
    private SimpleDateFormat ft;
    private Vector<String> idsToLog;
    private boolean transactionShouldBeLogged = false;
    LogHelper deviceLogHelper;
    String resourcePath;
    Byte resourceType;

    public DeviceLogger(String resourcePath, Byte resourceType) {
        this.resourcePath = resourcePath;
        this.resourceType = resourceType;
        this.buffer = new TransactBuffer();
        this.transactionId = 0;
        this.ft = new SimpleDateFormat("[dd.MM.yy@hh:mm:ssa]");
        this.idsToLog = null;
    }

    public DeviceLogger(Vector<String> idsToLog, String resourcePath, Byte resourceType) {
        this.resourcePath = resourcePath;
        this.resourceType = resourceType;
        this.buffer = new TransactBuffer();
        this.transactionId = 0;
        this.ft = new SimpleDateFormat("[dd.MM.yy@hh:mm:ssa]");
        this.idsToLog = idsToLog;
    }

    public DeviceLogger(Vector<String> idsToLog) {
        this.buffer = new TransactBuffer();
        this.transactionId = 0;
        this.ft = new SimpleDateFormat("[dd.MM.yy@hh:mm:ssa]");
        this.idsToLog = idsToLog;
    }

    public void setLogHelper(LogHelper deviceLogHelper) {
        this.deviceLogHelper = deviceLogHelper;
    }

    public void logData(String entityId, String dataType, byte[] data, String text) {
        if (text == null && this.deviceLogHelper != null) {
            text = this.deviceLogHelper.getHelp(data);
        }
        this.buffer.addData(entityId, dataType, data, text);
        if (this.idsToLog != null && this.idsToLog.contains(entityId)) {
            this.transactionShouldBeLogged = true;
        }
    }

    public void newTransaction() {
        this.buffer.newTransaction();
        this.transactionId = this.transactionId + 1;
        this.transactionShouldBeLogged = false;
    }

    public void putTransaction() {
        for (TransactBufferEntity entity : this.buffer.getData()) {
            if (!this.shouldBeLogged(entity.getEntityId())) continue;
            if ((this.resourceType & 0x10) == 16) {
                this.toIoStream(entity);
            }
            if ((this.resourceType & 1) != 1 || this.txtLogger == null) continue;
            this.txtLogger.toTxt(this.transactionId, entity);
        }
    }

    private void toIoStream(TransactBufferEntity entity) {
        System.out.println("trId: " + this.transactionId + ":" + this.ft.format(entity.getDateTime()) + ":" + entity.getEntityId() + ":" + entity.getData() + ":" + entity.getDataText() + ":" + entity.getDataType() + ":" + entity.getText());
    }

    private void toFile(TransactBufferEntity entity) {
    }

    private boolean shouldBeLogged(String id) {
        if (this.idsToLog == null) {
            return true;
        }
        return this.transactionShouldBeLogged;
    }

    public void setResource(String resourcePath, Byte resourceType) {
        this.resourcePath = resourcePath;
        this.resourceType = resourceType;
        if ((resourceType & 1) == 1) {
            this.txtLogger = new TxtLogger(resourcePath, resourceName);
        }
    }
}

