/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.roundlogger.logViewer.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import rs.pezar.kasa.roundlogger.logViewer.gui.Packet;

public class Viewer
extends JFrame
implements ActionListener {
    private JTable table;
    private Packet packet;
    private JButton btnLoadLogFile;

    public Viewer() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setTitle("Device log viewer");
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "Center");
        GridBagLayout gbl_panel = new GridBagLayout();
        int[] nArray = new int[4];
        nArray[1] = 900;
        gbl_panel.columnWidths = nArray;
        int[] nArray2 = new int[6];
        nArray2[1] = 240;
        nArray2[3] = 188;
        gbl_panel.rowHeights = nArray2;
        gbl_panel.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 1.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        this.btnLoadLogFile = new JButton("Load log file");
        this.btnLoadLogFile.addActionListener(this);
        GridBagConstraints gbc_btnLoadLogFile = new GridBagConstraints();
        gbc_btnLoadLogFile.anchor = 17;
        gbc_btnLoadLogFile.insets = new Insets(0, 0, 5, 5);
        gbc_btnLoadLogFile.gridx = 1;
        gbc_btnLoadLogFile.gridy = 0;
        panel.add((Component)this.btnLoadLogFile, gbc_btnLoadLogFile);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.insets = new Insets(0, 0, 5, 5);
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 1;
        gbc_scrollPane.gridy = 1;
        panel.add((Component)scrollPane, gbc_scrollPane);
        this.table = new JTable();
        this.table.setSelectionMode(0);
        this.table.setModel(new DefaultTableModel(new Object[][]{new Object[6]}, new String[]{"id", "time", "state", "origin", "data", "description"}));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(0).setMaxWidth(40);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(1).setMaxWidth(150);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(120);
        this.table.getColumnModel().getColumn(2).setMaxWidth(120);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(15);
        this.table.getColumnModel().getColumn(3).setMaxWidth(15);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(5).setMaxWidth(1000);
        scrollPane.setViewportView(this.table);
        this.packet = new Packet();
        GridBagConstraints gbc_packet = new GridBagConstraints();
        gbc_packet.insets = new Insets(0, 0, 5, 5);
        gbc_packet.fill = 1;
        gbc_packet.gridx = 1;
        gbc_packet.gridy = 3;
        panel.add((Component)this.packet, gbc_packet);
        this.setDefaultCloseOperation(3);
        this.table.getSelectionModel().addListSelectionListener(this.getTableChangeListener());
        this.pack();
        this.actionPerformed(new ActionEvent(this.btnLoadLogFile, 1, ""));
    }

    private ListSelectionListener getTableChangeListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                int viewRow = Viewer.this.table.getSelectedRow();
                if (viewRow > 0) {
                    int modelRow = Viewer.this.table.convertRowIndexToModel(viewRow);
                    String data = Viewer.this.table.getModel().getValueAt(modelRow, 0) + ":" + Viewer.this.table.getModel().getValueAt(modelRow, 1) + ":" + Viewer.this.table.getModel().getValueAt(modelRow, 2) + ":" + Viewer.this.table.getModel().getValueAt(modelRow, 3) + ":" + Viewer.this.table.getModel().getValueAt(modelRow, 4) + ":" + Viewer.this.table.getModel().getValueAt(modelRow, 5);
                    Viewer.this.packet.setData(data);
                }
            }
        };
    }

    public void importFile(File file) {
        int j = 0;
        while (j < ((DefaultTableModel)this.table.getModel()).getRowCount()) {
            ((DefaultTableModel)this.table.getModel()).removeRow(j);
            ++j;
        }
        File oFile = file;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        Object[] lineEntries1 = new String[6];
        try {
            fis = new FileInputStream(oFile);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            while (dis.available() != 0) {
                String line = dis.readLine();
                String[] lineEntries = line.split(":");
                lineEntries1[0] = lineEntries[1];
                lineEntries1[1] = String.valueOf(lineEntries[2]) + "." + lineEntries[3] + "." + lineEntries[4];
                lineEntries1[2] = lineEntries[5];
                lineEntries1[5] = lineEntries[9].equals("null") ? "X" : lineEntries[9];
                lineEntries1[3] = lineEntries[8].equals("null") ? "X" : lineEntries[8];
                lineEntries1[4] = lineEntries[7];
                ((DefaultTableModel)this.table.getModel()).addRow(lineEntries1);
            }
            fis.close();
            bis.close();
            dis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Viewer viewer = new Viewer();
        viewer.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource().equals(this.btnLoadLogFile)) {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(2);
            fc.showDialog(this, "Izaberi");
            this.importFile(fc.getSelectedFile().getAbsoluteFile());
        }
    }
}

