/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.roundlogger.resources;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import rs.pezar.kasa.roundlogger.buffer.TransactBufferEntity;

public class TxtLogger {
    private String logPath;
    private String logName;
    private FileWriter fstream;
    private BufferedWriter out;
    private SimpleDateFormat ft;

    public TxtLogger(String logPath, String logName) {
        this.logPath = logPath;
        this.logName = logName;
        this.ft = new SimpleDateFormat("[dd.MM.yy@hh:mm:ssa]");
        this.createLog();
    }

    private void createLog() {
        try {
            File f = new File(this.logPath);
            if (!f.exists()) {
                f.mkdirs();
            }
            if (!(f = new File(String.valueOf(this.logPath) + "\\" + this.logName)).exists()) {
                f.createNewFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void toTxt(Integer transactionId, TransactBufferEntity entity) {
        try {
            this.fstream = new FileWriter(String.valueOf(this.logPath) + "\\" + this.logName, true);
            this.out = new BufferedWriter(this.fstream);
            this.out.write("trId: " + transactionId + ":" + this.ft.format(entity.getDateTime()) + ":" + entity.getEntityId() + ":" + entity.getData() + ":" + entity.getDataText() + ":" + entity.getDataType() + ":" + entity.getText() + "\n");
            this.out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

