/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.testing.testCase;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.apache.commons.configuration.ConfigurationException;
import rs.pezar.kasa.testing.parser.TestParser;
import rs.pezar.kasa.testing.testCase.TestCase;
import rs.pezar.msg.device.cashregister.data.CashRegisterBill;
import rs.pezar.msg.device.cashregister.data.CashRegisterControl;
import rs.pezar.msg.device.interfaces.DeviceDriverInterface;

public class TestCaseSuite
extends JDialog
implements ActionListener {
    private JPanel panel_3;
    private Vector<TestCase> testPool;
    private DeviceDriverInterface driver;
    private JTextArea txtRezultat;
    private JScrollPane scrollPane;
    private JTextPane textopis;

    public TestCaseSuite(DeviceDriverInterface driver) {
        this.setTitle("Automatizovano testiranje");
        this.driver = driver;
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "Center");
        GridBagLayout gbl_panel = new GridBagLayout();
        int[] nArray = new int[3];
        nArray[0] = 237;
        nArray[1] = 675;
        gbl_panel.columnWidths = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 350;
        nArray2[1] = 10;
        gbl_panel.rowHeights = nArray2;
        gbl_panel.columnWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JPanel panel_4 = new JPanel();
        panel_4.setBorder(new EmptyBorder(10, 10, 10, 5));
        GridBagConstraints gbc_panel_4 = new GridBagConstraints();
        gbc_panel_4.fill = 1;
        gbc_panel_4.insets = new Insets(0, 0, 5, 5);
        gbc_panel_4.gridx = 0;
        gbc_panel_4.gridy = 0;
        panel.add((Component)panel_4, gbc_panel_4);
        panel_4.setLayout(new BoxLayout(panel_4, 0));
        JScrollPane scrollPane_2 = new JScrollPane();
        scrollPane_2.setPreferredSize(new Dimension(200, 350));
        panel_4.add(scrollPane_2);
        scrollPane_2.setBorder(new LineBorder(SystemColor.inactiveCaption));
        this.panel_3 = new JPanel();
        scrollPane_2.setViewportView(this.panel_3);
        this.panel_3.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.panel_3.setLayout(new BoxLayout(this.panel_3, 1));
        JButton btnPokreniTest = new JButton("Pokreni test");
        panel_4.add(btnPokreniTest);
        btnPokreniTest.addActionListener(this);
        JPanel panel_2 = new JPanel();
        panel_2.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints gbc_panel_2 = new GridBagConstraints();
        gbc_panel_2.insets = new Insets(0, 0, 5, 0);
        gbc_panel_2.fill = 1;
        gbc_panel_2.gridx = 1;
        gbc_panel_2.gridy = 0;
        panel.add((Component)panel_2, gbc_panel_2);
        panel_2.setLayout(new BorderLayout(0, 0));
        this.scrollPane = new JScrollPane();
        panel_2.add((Component)this.scrollPane, "Center");
        this.txtRezultat = new JTextArea();
        this.txtRezultat.setEditable(false);
        this.txtRezultat.setFont(new Font("Monospaced", 0, 11));
        this.scrollPane.setViewportView(this.txtRezultat);
        JLabel lblRezultatiTestova = new JLabel("Rezultati testova:");
        lblRezultatiTestova.setFont(new Font("Tahoma", 1, 11));
        panel_2.add((Component)lblRezultatiTestova, "North");
        JPanel panel_1 = new JPanel();
        panel_1.setPreferredSize(new Dimension(10, 400));
        panel_1.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.gridwidth = 2;
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 1;
        panel.add((Component)panel_1, gbc_panel_1);
        panel_1.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setPreferredSize(new Dimension(200, 200));
        scrollPane_1.setVerticalScrollBarPolicy(22);
        scrollPane_1.setHorizontalScrollBarPolicy(32);
        panel_1.add(scrollPane_1);
        this.textopis = new JTextPane();
        this.textopis.setEditable(false);
        this.textopis.setFont(new Font("Monospaced", 1, 13));
        scrollPane_1.setViewportView(this.textopis);
        JLabel lblFckinLabel = new JLabel("Opis testova:");
        lblFckinLabel.setFont(new Font("Tahoma", 1, 11));
        panel_1.add((Component)lblFckinLabel, "North");
        try {
            this.addTests();
        }
        catch (ConfigurationException configurationException) {
            JOptionPane.showMessageDialog(this, "Greska u ucitavanju testova", "Greska", 0);
        }
        this.pack();
    }

    private void addTests() throws ConfigurationException {
        this.testPool = new Vector();
        String opis = this.textopis.getText();
        File dir = new File("testovi");
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String temp = name.substring(name.length() - 4);
                String temp1 = ".xml";
                return temp.equalsIgnoreCase(temp1);
            }
        };
        File[] file = dir.listFiles(filter);
        int i = 0;
        while (i < file.length) {
            TestCase test = this.loadTest(file[i].getPath());
            this.panel_3.add(test);
            opis = String.valueOf(opis) + "TEST: " + test.getIme() + "\n";
            opis = String.valueOf(opis) + "OPIS: \n\t" + test.getOpis().replace("|", "\n") + "\n";
            opis = String.valueOf(opis) + "\n";
            this.testPool.add(test);
            ++i;
        }
        this.textopis.setText(opis);
    }

    private TestCase loadTest(String resource) {
        TestParser tp = new TestParser();
        TestCase test = new TestCase(this.driver);
        CashRegisterBill bill = null;
        CashRegisterControl control = null;
        try {
            bill = tp.loadBill(resource);
        }
        catch (Exception exception) {
            bill = null;
        }
        try {
            control = tp.loadControl(resource);
        }
        catch (Exception exception) {
            control = null;
        }
        if (bill != null && bill.getArticles() != null && bill.getArticles().size() > 0) {
            test.setCashRegisterBill(bill);
        }
        if (control != null && control.getControlCode() != null) {
            test.setCashRegisteControl(control);
        }
        test.setIme(tp.getIme());
        test.setOpis(tp.getOpis());
        if (!(bill != null && bill.getArticles() != null && bill.getArticles().size() >= 0 || control != null && control.getControlCode() != null)) {
            test.setOpis("Test nije lepo ucitan. Proveri xml format.");
        }
        return test;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        HashMap<String, String> results = null;
        this.txtRezultat.setText("");
        for (TestCase jCheckBox : this.testPool) {
            if (!jCheckBox.isSelected()) continue;
            results = jCheckBox.executeTest();
            String result = this.txtRezultat.getText();
            if (results != null) {
                String message = results.get("MESSAGE");
                String infos = results.get("INFO");
                String code = results.get("CODE");
                result = String.valueOf(result) + "TEST: " + jCheckBox.getIme() + "\n";
                result = String.valueOf(result) + "CODE: \n\t" + code + "\n";
                result = String.valueOf(result) + "MESSAGE: \n\t" + message + "\n";
                result = String.valueOf(result) + "INFOS: \n\t" + infos.replace(";", "\n\t");
                result = String.valueOf(result) + "\n";
            }
            this.txtRezultat.setText(result);
        }
    }
}

