/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa;

import java.util.HashMap;
import java.util.Vector;
import rs.pezar.core.PzApplication;
import rs.pezar.kasa.Sequencer;
import rs.pezar.kasa.Transformer.EiPosLinkTransformer;
import rs.pezar.kasa.databaseEngine.DatabaseEngine;
import rs.pezar.kasa.putGetEngine.DataGetter;
import rs.pezar.kasa.putGetEngine.PutGetEngine;
import rs.pezar.msg.device.cashregister.data.CashRegisterBill;
import rs.pezar.msg.device.cashregister.data.CashRegisterControl;
import rs.pezar.msg.device.interfaces.DeviceDataInterface;
import rs.pezar.msg.device.interfaces.cashRegister.CashRegisterControlInterface;

public class PosLink {
    public static final String BILL_TYPE = "BILL_TYPE";
    public static final String CONTROL_TYPE = "CONTROL_TYPE";
    public static final String ARTICLE_TYPE = "ARTICLE_TYPE";
    public static final String BASE_NAME = "EiPosLinkDB";
    public static final String WORKING_SUBFOLDER = "EiPosLink";
    public static final String REQUIRED_VERSION = "3.5.3";
    private PutGetEngine putGetEngine;
    private DatabaseEngine databaseEngine;
    private static PosLink instance;

    public PosLink(HashMap<String, String> params) {
        this.putGetEngine = new PutGetEngine(params);
        instance = this;
    }

    public void run() throws Exception {
        String workingFolder = PzApplication.getApplication().getDataFolder().getPath();
        this.databaseEngine = new DatabaseEngine(workingFolder, WORKING_SUBFOLDER, BASE_NAME);
    }

    public HashMap<String, String> runWithTheBill(DeviceDataInterface data) {
        Vector returnData = new Vector();
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, String> restemp = new HashMap();
        CashRegisterBill bill = (CashRegisterBill)data.getData();
        try {
            if (bill.isPreBill()) {
                result.put("CODE", "ERROR");
                result.put("MESSAGE", "Nije dozvoljeno stampanje predracuna.");
            } else {
                String filename = Sequencer.getName(this.databaseEngine);
                String eiBill = EiPosLinkTransformer.transformBill(data, filename);
                System.out.println(eiBill);
                restemp = this.putGetEngine.putGet(eiBill, BILL_TYPE, filename);
                result = this.formatReturnedData(restemp, result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("MESSAGE", e.getMessage());
            result.put("CODE", "ERROR");
        }
        if (result.get("CODE") == null) {
            result.put("CODE", "SUCCESS");
            int i = 0;
            while (i < returnData.size()) {
                result.put("MESSAGE", (String)returnData.elementAt(i));
                ++i;
            }
        }
        String info = "L|No info";
        info = String.valueOf(info) + result.get("INFO");
        result.put("INFO", info);
        return result;
    }

    public DatabaseEngine getDatabaseEngine() {
        return this.databaseEngine;
    }

    public HashMap<String, String> runWithTheControl(DeviceDataInterface data) {
        CashRegisterControl cntrl = (CashRegisterControl)data.getData();
        HashMap<String, String> result = this.executeControl(cntrl);
        return result;
    }

    public HashMap<String, String> executeControl(CashRegisterControl cntrl) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, String> restemp = new HashMap<String, String>();
        try {
            String[] tempControl = EiPosLinkTransformer.transformControl((CashRegisterControlInterface)cntrl);
            this.putGetEngine.put(tempControl[1], CONTROL_TYPE, tempControl[0]);
            restemp.put(DataGetter.INFO_OK, "");
            result = this.formatReturnedData(restemp, result);
        }
        catch (Exception e) {
            result.put("CODE", "ERROR");
            result.put("MESSAGE", e.getMessage());
        }
        String info = "L|OK.";
        info = String.valueOf(info) + result.get("INFO");
        result.put("INFO", info);
        return result;
    }

    private HashMap<String, String> formatReturnedData(HashMap<String, String> returnedData, HashMap<String, String> appender) {
        if (appender == null) {
            appender = new HashMap();
        }
        if (returnedData.containsKey(DataGetter.INFO_ERROR)) {
            String error3 = returnedData.get(DataGetter.INFO_ERROR) == null ? "" : returnedData.get(DataGetter.INFO_ERROR);
            appender.put("CODE", "ERROR");
            appender.put("MESSAGE", error3);
        }
        if (returnedData.containsKey(DataGetter.INFO_OK)) {
            returnedData.get(DataGetter.INFO_OK);
            appender.put("CODE", "SUCCESS");
            appender.put("MESSAGE", "OK");
        }
        if (returnedData.size() == 0) {
            appender.put("CODE", "ERROR");
            appender.put("MESSAGE", "EiPosLink ne vraca podatke, proverite da li ste upalili EiPosLink-ov usluzni program i dobro podesili foldere za komunikaciju sa njim. Za podesavanje pogledajte uputstvo za EiPosLink!");
        }
        return appender;
    }

    public static PosLink getInstance() {
        return instance;
    }

    public static void setInstance(PosLink instance) {
        PosLink.instance = instance;
    }
}

