/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.Transformer;

import java.sql.Connection;
import java.util.Vector;
import rs.pezar.kasa.CTResidentialService;
import rs.pezar.kasa.Control.CtControl;
import rs.pezar.kasa.article.CTArtHeader;
import rs.pezar.kasa.article.CtArticleDefine;
import rs.pezar.kasa.bill.CTBill;
import rs.pezar.kasa.bill.CTBillHeader;
import rs.pezar.kasa.databaseEngine.DatabaseFunctions;
import rs.pezar.kasa.payment.CTPayment;
import rs.pezar.kasa.payment.CTPaymentHeader;
import rs.pezar.msg.device.cashregister.data.Article;
import rs.pezar.msg.device.cashregister.data.CashRegisterBill;
import rs.pezar.msg.device.interfaces.DeviceDataInterface;
import rs.pezar.msg.device.interfaces.cashRegister.BillInterface;
import rs.pezar.msg.device.interfaces.cashRegister.CashRegisterControlInterface;

public class CTTransformer {
    public static String transformArticle(DeviceDataInterface data) throws Exception {
        CashRegisterBill bill = (CashRegisterBill)data.getData();
        CTTransformer.setPlus(bill.getArticles());
        String header = CTArtHeader.getHeader();
        String artPart = CtArticleDefine.getHcpArt(bill);
        String completeArt = String.format(header, artPart);
        return completeArt;
    }

    public static String transformPayment(DeviceDataInterface data) throws Exception {
        CashRegisterBill bill = (CashRegisterBill)data.getData();
        CTTransformer.setPlus(bill.getArticles());
        String header = CTPaymentHeader.getHeader();
        String billPart = CTPayment.getCtPayment((BillInterface)bill);
        String completeBill = String.format(header, billPart);
        return completeBill;
    }

    public static String transformBill(DeviceDataInterface data) throws Exception {
        CashRegisterBill bill = (CashRegisterBill)data.getData();
        CTTransformer.setPlus(bill.getArticles());
        String header = CTBillHeader.getHeader();
        String billPart = CTBill.getCtBill((BillInterface)bill);
        String completeBill = String.format(header, billPart);
        return completeBill;
    }

    public static String transformControl(CashRegisterControlInterface control) throws Exception {
        String temp = CtControl.getctControl(control);
        return temp;
    }

    private static void setPlus(Vector<Article> articles) throws Exception {
        int i = 0;
        while (i < articles.size()) {
            String sifra = articles.get(i).getSifra();
            String naziv = articles.get(i).getName();
            Connection conn = CTResidentialService.getInstance().getDatabaseEngine().getConnection();
            Integer pl = DatabaseFunctions.getPlu(conn, "CTDB", sifra);
            String nazivIzBaze = DatabaseFunctions.getNaziv(conn, "CTDB", sifra);
            if (nazivIzBaze != null && !naziv.equals(nazivIzBaze) && !naziv.equals(pl + " " + nazivIzBaze)) {
                throw new Exception("U bazi postoji artikal sa razlicitim nazivom a istom sifrom, izpraznite i bazu i artikle iz stampaca.");
            }
            if (pl != null) {
                articles.get(i).setPLU(pl);
            } else {
                Integer maxPlu = DatabaseFunctions.getMaxPlu(conn, "CTDB");
                maxPlu = maxPlu + 1;
                DatabaseFunctions.addNewData(conn, maxPlu, sifra, naziv, "CTDB");
                articles.get(i).setPLU(maxPlu);
            }
            ++i;
        }
    }
}

