/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.databaseEngine;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseFunctions {
    public static void createDatabase(String workingDirectory, String subfolder, String name) throws Exception {
        String folder = String.valueOf(workingDirectory) + "\\" + subfolder;
        new File(folder).mkdir();
        Class.forName("org.sqlite.JDBC");
        Connection conn = DriverManager.getConnection("jdbc:sqlite:" + folder + "\\" + name + ".db");
        Statement stat = conn.createStatement();
        stat.executeUpdate("create table if not exists " + name.toUpperCase() + " (plu, sifra, naziv);");
        stat.close();
        conn.close();
    }

    public static Connection openDatabase(String workingDirectory, String subfolder, String name) throws Exception {
        String folder = String.valueOf(workingDirectory) + "\\" + subfolder;
        Class.forName("org.sqlite.JDBC");
        Connection conn = DriverManager.getConnection("jdbc:sqlite:" + folder + "\\" + name + ".db");
        return conn;
    }

    public static void closeDatabase(Connection conn) throws Exception {
        conn.close();
    }

    public static void dropTable(Connection conn, String name) throws Exception {
        Statement stat = conn.createStatement();
        stat.executeUpdate("create table if not exists " + name.toUpperCase() + " (plu, sifra, naziv);");
        stat.executeUpdate("DROP TABLE " + name.toUpperCase());
        stat.executeUpdate("create table if not exists " + name.toUpperCase() + " (plu, sifra, naziv);");
        stat.close();
    }

    public static void addNewData(Connection conn, Integer plu, String sifra, String naziv, String tableName) throws Exception {
        Integer pl = DatabaseFunctions.getPlu(conn, tableName, sifra);
        if (pl != null && !pl.equals(plu)) {
            throw new Exception("Detektovana losa sinhronizacija, morate isprazniti artikle iz stampaca i onda tek izdati racun.");
        }
        String nzv = DatabaseFunctions.getNaziv(conn, tableName, sifra);
        if (nzv != null && !nzv.equals(naziv)) {
            throw new Exception("Detektovana promena naziva na sifri, morate isprazniti artikle iz stampaca i onda tek izdati racun.");
        }
        if (nzv != null && pl != null && nzv.equals(naziv) && pl.equals(plu)) {
            return;
        }
        PreparedStatement prep = conn.prepareStatement("insert into " + tableName.toUpperCase() + " values (?, ?, ?);");
        prep.setString(1, String.valueOf(plu));
        prep.setString(2, sifra);
        prep.setString(3, naziv);
        prep.addBatch();
        conn.setAutoCommit(false);
        prep.executeBatch();
        conn.setAutoCommit(true);
    }

    public static String getNaziv(Connection conn, String tableName, String sifra) throws Exception {
        String naziv = null;
        Statement stat = conn.createStatement();
        String query = String.format("select naziv from " + tableName.toUpperCase() + " where sifra='%s';", sifra);
        ResultSet rs = stat.executeQuery(query);
        while (rs.next()) {
            naziv = rs.getString("naziv");
        }
        rs.close();
        stat.close();
        return naziv;
    }

    public static Integer getPlu(Connection conn, String tableName, String sifra) throws Exception {
        String plu = null;
        Statement stat = conn.createStatement();
        String query = String.format("select plu from " + tableName.toUpperCase() + " where sifra='%s';", sifra);
        ResultSet rs = stat.executeQuery(query);
        while (rs.next()) {
            plu = rs.getString("plu");
        }
        rs.close();
        stat.close();
        if (plu == null) {
            return null;
        }
        return Integer.valueOf(plu);
    }

    public static String getSifra(Connection conn, String tableName, Integer plu) throws Exception {
        String sifra = null;
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery(String.format("select sifra,plu from " + tableName.toUpperCase() + " where plu='%s';", plu));
        while (rs.next()) {
            sifra = rs.getString("sifra");
        }
        rs.close();
        stat.close();
        return sifra;
    }

    public static Integer getNumberOfRows(Connection conn, String tableName) throws Exception {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery(String.format("select COUNT(plu) FROM " + tableName.toUpperCase() + " AS count;", new Object[0]));
        Integer numberOfRows = rs.getInt(1);
        rs.close();
        stat.close();
        return numberOfRows;
    }

    public static Integer getMaxPlu(Connection conn, String tableName) throws SQLException {
        Integer max = 0;
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery(String.format("select plu AS plu FROM " + tableName.toUpperCase() + " AS count;", new Object[0]));
        while (rs.next()) {
            String max1 = rs.getString("plu");
            if (Integer.parseInt(max1) <= max) continue;
            max = Integer.parseInt(max1);
        }
        rs.close();
        stat.close();
        return max;
    }

    public static void updateNaziv(Connection conn, String sifra, String naziv) throws Exception {
    }

    public static void main(String[] args) {
        try {
            DatabaseFunctions.createDatabase("c:\\temp", "testBaza", "testBaza");
            Connection conn = DatabaseFunctions.openDatabase("c:\\temp", "testBaza", "testBaza");
            DatabaseFunctions.getNumberOfRows(conn, "testBaza");
            DatabaseFunctions.getMaxPlu(conn, "testBaza");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

