/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.putGetEngine;

import java.io.IOException;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import rs.pezar.core.PzApplication;
import rs.pezar.kasa.putGetEngine.DataGetter;
import rs.pezar.kasa.putGetEngine.DataPutter;

public class PutGetEngine {
    private static final String SUBFOLDER = "CT";
    private static final Integer WAIT_FOR_RESPONSE = 10000;
    private static final Integer RETRY_TIME = WAIT_FOR_RESPONSE / 10;
    private String workingFolder;
    private String inFolder;
    private String outFolder;
    private DataPutter dataPutter;
    private Integer sequence;
    private Timer timer;
    private TimerTask t;
    private boolean timeOver = false;
    private Integer timeCounter = 0;
    private Integer waitForResponse = WAIT_FOR_RESPONSE;
    private Integer retryTime = RETRY_TIME;

    public PutGetEngine(HashMap<String, String> params) {
        this.workingFolder = PzApplication.getApplication().getDataFolder().getPath();
        this.outFolder = params.get("PARAM1");
        this.inFolder = params.get("PARAM2");
        this.dataPutter = new DataPutter();
        this.sequence = 1;
    }

    public void put(String data, String type) throws IOException {
        this.dataPutter.put(this.workingFolder, SUBFOLDER, this.inFolder, this.sequence, data, type);
    }

    public HashMap<String, String> get() {
        DataGetter.dataGet(this.outFolder, this.sequence);
        return null;
    }

    private TimerTask getTimerTask() {
        TimerTask t = new TimerTask(){

            @Override
            public void run() {
                PutGetEngine putGetEngine = PutGetEngine.this;
                putGetEngine.timeCounter = putGetEngine.timeCounter + PutGetEngine.this.retryTime;
                if (PutGetEngine.this.timeCounter >= PutGetEngine.this.waitForResponse) {
                    PutGetEngine.this.timeOver = true;
                }
            }
        };
        return t;
    }

    public synchronized HashMap<String, String> putGet(String data, String type) throws Exception {
        this.timeOver = false;
        this.timeCounter = 0;
        System.out.println(this.waitForResponse);
        System.out.println(this.retryTime);
        try {
            this.put(data, type);
        }
        catch (IOException iOException) {
            throw new Exception("H|Nije moguce snimiti fajl u ulazni direktorijum programa posrednika, da li ste dobro podesili?");
        }
        Thread.sleep(2000L);
        this.timer = new Timer();
        this.t = this.getTimerTask();
        this.timer.schedule(this.t, 0L, (long)this.retryTime.intValue());
        while (true) {
            HashMap<String, String> result = DataGetter.dataGet(this.outFolder, this.sequence);
            this.sequence = this.sequence + 1;
            if (result.size() > 0 || this.timeOver) {
                this.timer.cancel();
                this.resetTimeSettings();
                return result;
            }
            Thread.sleep(this.retryTime.intValue());
        }
    }

    public void extendWaitTime(Integer toMilliseconds) {
        this.waitForResponse = toMilliseconds;
        this.retryTime = this.waitForResponse / 10;
    }

    private void resetTimeSettings() {
        this.waitForResponse = WAIT_FOR_RESPONSE;
        this.retryTime = RETRY_TIME;
    }
}

