/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.dataimport;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.SwingWorker;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Aktaksa;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.ArtikalkalkulacijaPK;
import rs.pezar.db.entity.EksternaSifra;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.nabavka.dataimport.DataImporter;
import rs.pezar.nabavka.dataimport.DataImporterOptionsPanel;
import rs.pezar.nabavka.dataimport.gui.PzDialogDataImport;
import rs.pezar.nabavka.dataimport.gui.PzPanelFormats;
import rs.pezar.nabavka.dataimport.gui.PzPanelGeneralOptions;
import rs.pezar.nabavka.dataimport.importers.CSVDataImporter;
import rs.pezar.nabavka.dataimport.importers.NavigatorDataImporter;
import rs.pezar.nabavka.dataimport.importers.XlsDataImporter;
import rs.pezar.nabavka.gui.PzDialogKalkulacija;
import rs.pezar.nabavka.gui.kalkulacija.Dodavanje;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class DataImporterManager {
    private static DataImporterManager _instance;
    private List<DataImporter> importers = new Vector<DataImporter>();
    Map<Object, Object> options;
    private DataImporter di;
    private Kalkulacija kalkulacija;
    private File f;
    private PzDialogKalkulacija parent;
    private List<DataImporterOptionsPanel> allPanels;
    public static final String USER_OPTION_FILE = "FILE";
    public static final String USER_OPTION_FIXED_RATE = "FIXED_RATE";
    public static final String USER_OPTION_IMPORTER = "IMPORTER";
    public static final String USER_OPTION_MARGIN = "MARGIN";
    public static final String USER_OPTION_MARGIN_RATE = "MARGIN_RATE";
    public static final String USER_OPTION_RELATION = "RELATION";

    public DataImporterManager() {
        this.addImporter(new XlsDataImporter());
        this.addImporter(new CSVDataImporter());
        this.addImporter(new NavigatorDataImporter());
    }

    public static DataImporterManager getInstance() {
        if (_instance == null) {
            _instance = new DataImporterManager();
            DataImporterManager.addPanels(_instance);
        }
        return _instance;
    }

    public static void destroyInstance() {
        _instance = null;
    }

    private static void addPanels(DataImporterManager m) {
        if (m.allPanels == null) {
            m.allPanels = new Vector<DataImporterOptionsPanel>();
        }
        m.allPanels.add(new PzPanelFormats());
        m.allPanels.add(new PzPanelGeneralOptions());
    }

    public void runImport(Kalkulacija k, PzDialogKalkulacija p) throws Exception {
        this.parent = p;
        this.kalkulacija = k;
        this.parent.getSession().putParameter("OPTIONS_PANELS", this.allPanels);
        this.parent.showDialog(PzDialogDataImport.class);
        this.options = (Map)this.parent.getSession().getParameter("USER_OPTIONS");
        this.parent.getSession().putParameter("USER_OPTIONS", null);
        if (this.options == null) {
            return;
        }
        this.f = (File)this.options.get(USER_OPTION_FILE);
        this.di = (DataImporter)this.options.get(USER_OPTION_IMPORTER);
        if (this.di == null) {
            return;
        }
        if (this.f == null) {
            return;
        }
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                if (!DataImporterManager.this.di.isValidFileFormat(DataImporterManager.this.f, DataImporterManager.this.options)) {
                    throw new PzInfoException("Format fajla nije ispravan. Uvoz podataka prekinut!");
                }
                EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                List<Artikalkalkulacija> stavke = DataImporterManager.this.di.getArtikalKalkulacijas(DataImporterManager.this.f, DataImporterManager.this.options);
                if (stavke == null || stavke.size() == 0) {
                    throw new PzInfoException("Nema stavki za uvoz!");
                }
                for (Artikalkalkulacija ak : stavke) {
                    Artikal a;
                    if (ak.getId() == null) {
                        ak.setId(new ArtikalkalkulacijaPK());
                    }
                    ak.setKalkulacija(DataImporterManager.this.kalkulacija);
                    ak.getId().setIdDok(DataImporterManager.this.kalkulacija.getIdDok());
                    ak.getId().setrBroj(stavke.indexOf(ak));
                    if (ak.getId().getSfrProizvod() != null && !"".equals(ak.getId().getSfrProizvod())) {
                        try {
                            a = (Artikal)em.createQuery("SELECT a FROM Artikal a WHERE a.sfrProizvod=:sfrProizvod").setParameter("sfrProizvod", (Object)ak.getId().getSfrProizvod()).getSingleResult();
                            ak.setNaziv(a.getNaziv());
                            ak.setArtikal(a);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        List esl = em.createQuery("SELECT es FROM EksternaSifra es WHERE es.komitent=:komitent and es.sifra=:sifra").setParameter("komitent", (Object)DataImporterManager.this.kalkulacija.getKomitent()).setParameter("sifra", (Object)ak.getDobSifra()).getResultList();
                        if (esl.size() > 0) {
                            EksternaSifra es = (EksternaSifra)esl.get(0);
                            ak.getId().setSfrProizvod(es.getId().getSfrProizvod());
                            ak.setNaziv(es.getArtikal().getNaziv());
                            ak.setArtikal(es.getArtikal());
                        }
                    }
                    if (ak.getArtikal() == null) {
                        try {
                            a = (Artikal)em.createQuery("SELECT a FROM Artikal a WHERE a.dobSifra=:dobSifra").setParameter("dobSifra", (Object)ak.getKatBroj()).getSingleResult();
                            ak.setNaziv(a.getNaziv());
                            ak.setArtikal(a);
                        }
                        catch (Exception exception) {}
                    }
                    if (!DataImporterManager.this.options.get(DataImporterManager.USER_OPTION_MARGIN).equals("GENERAL") && !DataImporterManager.this.options.get(DataImporterManager.USER_OPTION_MARGIN).equals("CURRENT_PRICE")) continue;
                    ak.setProcMarze(((Double)DataImporterManager.this.options.get(DataImporterManager.USER_OPTION_MARGIN_RATE)).doubleValue());
                    double n = ak.getFakturnaCena() * (1.0 - ak.getProcRabata() / 100.0);
                    double iznos = DataImporterManager.this.kalkulacija.getIznos().doubleValue();
                    double pdv = DataImporterManager.this.parent.getPDV();
                    double udeoTrosak = iznos != 0.0 ? n / (iznos - DataImporterManager.this.kalkulacija.getTrosakBezPdv().doubleValue() - pdv) * DataImporterManager.this.kalkulacija.getTrosakBezPdv().doubleValue() : 0.0;
                    double udeoTrosak1 = iznos != 0.0 ? n / (iznos - DataImporterManager.this.kalkulacija.getTrosakBezPdv().doubleValue() - pdv) * DataImporterManager.this.kalkulacija.getTrosakBezPdv().doubleValue() : 0.0;
                    double res = ((1.0 - ak.getProcRabata() / 100.0) * ak.getFakturnaCena() + udeoTrosak + udeoTrosak1) * (1.0 + ak.getProcMarze() / 100.0);
                    ak.setZavTroskovi(udeoTrosak + udeoTrosak1);
                    ak.setNabCena(ak.getFakturnaCena() * (1.0 - ak.getProcRabata() / 100.0) + ak.getZavTroskovi());
                    ak.setProdCena(BDConverter.getProdCena((double)res));
                    if (!DataImporterManager.this.options.get(DataImporterManager.USER_OPTION_MARGIN).equals("CURRENT_PRICE") || ak.getId().getSfrProizvod() == null || ak.getId().getSfrProizvod().equals("")) continue;
                    Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(ak.getId().getSfrProizvod(), DataImporterManager.this.kalkulacija.getRadnajedinica()));
                    if (s != null) {
                        ak.setProdCena(BDConverter.getProdCena((double)s.getProdCena()));
                    } else {
                        ak.setProdCena(null);
                    }
                    if (ak.getProdCena() != null) {
                        ak.setProcMarze(BDConverter.getProcMarze((double)(ak.getNabCena() / ak.getProdCena().doubleValue() * 100.0)).doubleValue() * 100.0);
                    }
                    ak.setAktaksas(new ArrayList());
                    ak.getAktaksas().add(new Aktaksa(ak, ((Artikal)em.find(Artikal.class, (Object)ak.getId().getSfrProizvod())).getTarifnaGrupa("PDV")));
                }
                em.close();
                return stavke;
            }

            @Override
            protected void done() {
                try {
                    List stavke = (List)this.get();
                    for (Artikalkalkulacija ak : stavke) {
                        if (ak.getId().getSfrProizvod() == null || ak.getId().getSfrProizvod().equals("") || ak.getProdCena() == null || DataImporterManager.this.options.get(DataImporterManager.USER_OPTION_MARGIN).equals("INDIVIDUAL")) {
                            DataImporterManager.this.parent.getSession().putParameter("kalkulacija", (Object)DataImporterManager.this.kalkulacija);
                            DataImporterManager.this.parent.getSession().putParameter("update", (Object)false);
                            DataImporterManager.this.parent.getSession().putParameter("table", (Object)DataImporterManager.this.parent.getTable());
                            DataImporterManager.this.parent.getSession().putParameter("imported", (Object)ak);
                            DataImporterManager.this.parent.showDialog(Dodavanje.class);
                            DataImporterManager.this.parent.getSession().putParameter("imported", null);
                            continue;
                        }
                        this.validate(ak);
                        DataImporterManager.this.parent.getTable().insert((PzEntity)ak, true);
                    }
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)((Object)DataImporterManager.this.parent), (Throwable)e);
                }
                DataImporterManager.destroyInstance();
            }

            private void validate(Artikalkalkulacija ak) throws Exception {
                if (ak.getId().getSfrProizvod() == null) {
                    throw new PzInfoException("Gre\u0161ka! Polje sa \u0161ifrom artikla je prazno. ");
                }
                if (ak.getFakturnaCena() == 0.0) {
                    throw new PzInfoException("Gre\u0161ka! Polje sa fakturnom cenom je prazno. \u0160ifra: " + ak.getId().getSfrProizvod());
                }
                if (ak.getKolicina() == 0.0) {
                    throw new PzInfoException("Gre\u0161ka! Polje sa kolicinom je prazno. \u0160ifra: " + ak.getId().getSfrProizvod());
                }
                if (ak.getNabCena() == 0.0) {
                    throw new PzInfoException("Gre\u0161ka! Polje sa nabavnom cenom je prazno. \u0160ifra: " + ak.getId().getSfrProizvod());
                }
                if (ak.getJm() == null) {
                    throw new PzInfoException("Gre\u0161ka! Polje sa jedinicom mere cenom je prazno. \u0160ifra: " + ak.getId().getSfrProizvod());
                }
                if (ak.getProdCena() == null || ak.getProdCena().doubleValue() == 0.0) {
                    throw new PzInfoException("Gre\u0161ka! Polje sa prodajnom cenom je prazno. \u0160ifra: " + ak.getId().getSfrProizvod());
                }
            }
        };
        worker.execute();
    }

    public void addImporter(DataImporter importer) {
        this.importers.add(importer);
    }

    public List<DataImporter> getImporters() {
        return this.importers;
    }

    public List<DataImporterOptionsPanel> getPanels() {
        return this.allPanels;
    }

    public Kalkulacija getKalkulacija() {
        return this.kalkulacija;
    }
}

