/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.dataimport.importers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.ArtikalkalkulacijaPK;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.nabavka.dataimport.DataImporter;
import rs.pezar.nabavka.dataimport.DataImporterOptionsPanel;
import rs.pezar.nabavka.dataimport.importers.data.navigator.NavigatorFaktura;
import rs.pezar.nabavka.dataimport.importers.data.navigator.NavigatorFakturaRoot;
import rs.pezar.nabavka.dataimport.importers.data.navigator.NavigatorFakturaStavka;
import rs.pezar.nabavka.dataimport.importers.panels.NavigatorPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class NavigatorDataImporter
extends DataImporter {
    @Override
    public DataImporterOptionsPanel getOptionsPanel() {
        return new NavigatorPanel();
    }

    @Override
    public String getFileExtension() {
        return "xml";
    }

    @Override
    public String getImporterName() {
        return "Navigator XML";
    }

    @Override
    public void validateDokument(Kalkulacija k) throws Exception {
    }

    @Override
    public boolean isValidFileFormat(File f, Map<Object, Object> userOptions) {
        return true;
    }

    @Override
    public Kalkulacija getKalkulacija(File f, Map<Object, Object> userOptions) {
        return null;
    }

    @Override
    public List<Artikalkalkulacija> getArtikalKalkulacijas(File f, Map<Object, Object> userOptions) {
        String veza = (String)userOptions.get("VEZA");
        ArrayList<Artikalkalkulacija> aklist = new ArrayList<Artikalkalkulacija>();
        try {
            NavigatorFaktura faktura;
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{NavigatorFakturaRoot.class});
            Unmarshaller u = jaxbContext.createUnmarshaller();
            NavigatorFakturaRoot root = (NavigatorFakturaRoot)u.unmarshal(f);
            if (root.getDokumenti() != null && root.getDokumenti().size() > 0 && (faktura = root.getDokumenti().get(0)).getStavke() != null && faktura.getStavke().size() > 0) {
                List<NavigatorFakturaStavka> stavke = faktura.getStavke();
                for (NavigatorFakturaStavka stavka : stavke) {
                    Artikalkalkulacija ak = new Artikalkalkulacija();
                    if (veza.equals("Interna sifra")) {
                        ak.setId(new ArtikalkalkulacijaPK());
                        ak.getId().setSfrProizvod(stavka.getSifra() != null ? stavka.getSifra().replaceFirst("^0+(?!$)", "") : "");
                        ak.setKatBroj(stavka.getItm());
                    } else if (veza.equals("Dobavljaceva sifra")) {
                        ak.setDobSifra(stavka.getSifra());
                    } else if (veza.equals("Kataloski broj")) {
                        ak.setKatBroj(stavka.getItm());
                    }
                    ak.setKolicina(stavka.getKolicina());
                    ak.setFakturnaCena(stavka.getBrutoCena());
                    ak.setProcRabata(stavka.getRabat());
                    ak.setNaziv(stavka.getNaziv());
                    ak.setJm(stavka.getJedinicaMere());
                    aklist.add(ak);
                }
            }
        }
        catch (JAXBException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
        return aklist;
    }
}

