/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.reports.PzReportManager;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogBrisanjeStornoKalkulacija
extends PzDialog {
    private JToolBar toolbar;
    private PzPanel mainPanel;
    private PzTable tabelaStornoKalkulacije;
    private JScrollPane scrollPane;
    private PzToolBarIcon btnBrisanje;
    private Radnajedinica rj;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private PzToolBarIcon icnSlikaDokumenta;

    public PzDialogBrisanjeStornoKalkulacija(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{94, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.toolbar.setFloatable(false);
            this.icnSlikaDokumenta = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSlikaDokumenta);
            this.icnSlikaDokumenta.setText("Slika|dokumenta|(F2)");
            this.icnSlikaDokumenta.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/presentation_chart.png")));
            this.icnSlikaDokumenta.setActionCommand("slika");
            this.icnSlikaDokumenta.addActionListener((ActionListener)((Object)this));
            this.icnSlikaDokumenta.setShortcut("F2");
            this.btnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnBrisanje);
            this.btnBrisanje.setText("Brisanje|dokumenta|(Delete)");
            this.btnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/document_delete.png")));
            this.btnBrisanje.setActionCommand("brisi");
            this.btnBrisanje.addActionListener((ActionListener)((Object)this));
            this.btnBrisanje.setShortcut("DELETE");
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.tabelaStornoKalkulacije = new PzTable();
            this.scrollPane.setViewportView((Component)this.tabelaStornoKalkulacije);
            this.tabelaStornoKalkulacije.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Kalkulacija dok = (Kalkulacija)entity;
                    return new Object[]{dok.getPodTip(), dok.getrBroj(), dok.getKomitent().getNaziv(), dok.getKomitent().getSfrKomitent(), dok.getOznDokumenta(), dok.getDatum(), dok.getDatum(), dok.getIznos(), dok.getPdvIznos(), dok.getTroskoviCarina().add(dok.getTroskoviEksterni()).add(dok.getTroskoviInterni())};
                }

                public String[] getColumnNames() {
                    return new String[]{"Opis", "Storno kalkulacija", "Dobavlja\u010d", "\u0160ifra dobavlja\u010da", "Dokument", "Datum dokumenta", "Datum rada", "Iznos", "PDV", "Tro\u0161kovi"};
                }
            });
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj dokumenata");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(800, 700);
            this.setMinimumSize(new Dimension(800, 700));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void actionPerformed(ActionEvent e) {
        block13: {
            button = (PzButton)e.getSource();
            actionCommand = button.getActionCommand();
            em = PzEntityManager.getEm();
            try {
                if (!actionCommand.equals("brisi")) ** GOTO lbl32
                if (this.tabelaStornoKalkulacije.getSelectedRow() == -1) break block13;
                kalStorno = (Kalkulacija)this.tabelaStornoKalkulacije.getSelectedEntity();
                if (kalStorno.getDokument().getProknjizen() == 1) {
                    JOptionPane.showMessageDialog((Component)this, "Odabrani dokument je proknji\u017een! Nije mogu\u0107e izvr\u0161iti brisanje!", "Informacija", 1);
                    return;
                }
                rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Da li ste sigurni?", (String)"Brisanje", null, (boolean)false);
                if (rez != 0) {
                    return;
                }
                try {
                    em.getTransaction().begin();
                    kal = kalStorno.getOriginal();
                    kal.setStornoIznos(kal.getStornoIznos().subtract(kalStorno.getIznos()));
                    for (Artikalkalkulacija ak : kalStorno.getArtikalkalkulacijas()) {
                        s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(ak.getId().getSfrProizvod(), kalStorno.getRadnajedinica()));
                        if (s == null) {
                            throw new PzInfoException("Gre\u0161ka prilikom brisanja storno kalkulacije - ne postoji stanje za artikal: " + ak.getId().getSfrProizvod());
                        }
                        s.setKolicina(s.getKolicina() + ak.getKolicina());
                    }
                    em.merge((Object)kal);
                    this.tabelaStornoKalkulacije.removeSelectedEntity(false, true);
                    em.getTransaction().commit();
                    this.tabelaStornoKalkulacije.refreshData();
                    this.refresh();
                    break block13;
lbl32:
                    // 1 sources

                    if (actionCommand.equals("slika") && this.tabelaStornoKalkulacije.getRowCount() != 0) {
                        PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)((Kalkulacija)this.tabelaStornoKalkulacije.getSelectedEntity()));
                    }
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)this, (Throwable)e1);
                }
            }
            finally {
                em.close();
            }
        }
    }

    public boolean shouldBeShown() {
        block3: {
            block4: {
                try {
                    this.mainPanel.setPaintGradient(true);
                    this.rj = PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf("V".charAt(0)), Character.valueOf("E".charAt(0))});
                    if (this.rj == null) break block3;
                    if (!this.rj.getNacinVodjenja().equals("PRNC")) break block4;
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Brisanje storno kalkulacije ne radi u sistemu vo\u0111enja po prose\u010dnim nabavnim cenama");
                    return false;
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                    return false;
                }
            }
            this.setTitle("Brisanje storno kalkulacija");
            this.initializeTable();
            return true;
        }
        return false;
    }

    public void initializeTable() {
        Vector<Kalkulacija> data = this.getStornoKalkulacije();
        this.tabelaStornoKalkulacije.setData(data, Kalkulacija.class);
        this.refresh();
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogBrisanjeStornoKalkulacija.this.brDok.setText(String.valueOf(PzDialogBrisanjeStornoKalkulacija.this.tabelaStornoKalkulacije.getRowCount()));
            }
        });
    }

    public Vector<Kalkulacija> getStornoKalkulacije() {
        Vector data = null;
        try {
            EntityManager em = PzEntityManager.getEm();
            Query q = null;
            q = em.createQuery("SELECT k FROM Kalkulacija k where k.radnajedinica=:rj and k.storno=1 and k.arhiviran = 1");
            q.setParameter("rj", (Object)this.rj);
            data = (Vector)q.getResultList();
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
        return data;
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogBrisanjeStornoKalkulacija(Boolean.FALSE);
    }

    public PzDialogBrisanjeStornoKalkulacija(Boolean initGUI) {
    }
}

