/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui.kalkulacija;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.EksternaSifra;
import rs.pezar.db.entity.EksternaSifraPK;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.nabavka.gui.PzDialogKalkulacija;
import rs.pezar.nabavka.gui.kalkulacija.PzDialogPomocEvro;
import rs.pezar.nabavka.gui.kalkulacija.PzDialogPomocPriObradiNabCene;
import rs.pezar.sifarnici.gui.PzArtikliBrowser;
import rs.pezar.sifarnici.gui.artikli.DodavanjeExtended;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.event.PzStanjeartikalChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class Dodavanje
extends PzDialogInsert {
    private static final long serialVersionUID = 1L;
    private PzPanel mainPanel;
    private PzPanel pnlFields;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private PzDoubleField prodCena;
    private PzDoubleField faktCena;
    private PzDoubleField nabVred;
    private JLabel lblTros;
    private PzDoubleField ukTros;
    private JLabel lblplus;
    private PzTextField dobSifra;
    private JLabel lblDobSifra;
    private PzTextField nazivArt;
    private PzButton btnOK;
    private PzDoubleField procRabata;
    private PzDoubleField procMarze;
    private PzDoubleField kolicina;
    private PzDoubleField prnc;
    private JCheckBox cbEko;
    private PzDoubleField netoFaktCena;
    private JLabel lblNetoFakturna;
    private PzDoubleField prodajnaCena;
    private PzDoubleField poslNabavna;
    private PzTextField tarGrupa;
    private PzDoubleField zatKolicina;
    private JLabel jLabel11;
    private JLabel jLabel10;
    private JLabel jLabel9;
    private PzPanel pnlArtikalStanje;
    private PzFieldImpl sfrArtDok;
    private JLabel jLabel8;
    private JLabel jLabel7;
    private JLabel jLabel6;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzPanelHeader header;
    private Artikal artikal;
    private Kalkulacija kalkulacija;
    private PzDialogKalkulacija dlgKalkulacija;
    private double udeoTrosak;
    private Artikalkalkulacija artdok;
    private PzButton btnDodavanje;
    private PzDoubleField nabCen;
    private JLabel lblNabCena;
    private PzDoubleField ukNabVred;
    private JLabel lblEuals;
    private JSeparator sep;
    private JLabel jLabel13;
    private PzFieldIndikator indNabCena;
    private PzFieldIndikator indKolicina;
    private PzFieldIndikator indSifra;
    private JLabel jLabel12;
    private double udeoTrosak1;
    private PzTable tableProvera;
    private Short domaciKomitent;
    private PzFieldIndikator indDobSifra;
    private Artikalkalkulacija imported;
    private BigDecimal ekoTaksa;

    public Dodavanje(PzDialog dialog) {
        super(dialog);
        this.kalkulacija = (Kalkulacija)this.getSession().getParameter("kalkulacija");
        this.tableProvera = (PzTable)this.getSession().getParameter("table");
        this.dlgKalkulacija = (PzDialogKalkulacija)dialog;
        if (!this.isUpdate()) {
            this.procRabata.setVal((Object)this.dlgKalkulacija.getRabat());
        }
        this.sfrArtDok.setParamToPass((Object)this.kalkulacija.getRadnajedinica());
        this.sfrArtDok.setEntityChecker((PzEntityChecker)new PzStanjeartikalChecker((PzField)this.sfrArtDok, this.kalkulacija.getRadnajedinica()));
        this.domaciKomitent = this.dlgKalkulacija.getDomaciKomitent();
        if (this.domaciKomitent != null && this.domaciKomitent == 0) {
            this.faktCena.setEnabled(false);
        }
        this.ekoTaksa = new BigDecimal(PzParameter.getParameterValue((String)"EKO_TAKSA", (String)"0"));
        if (this.ekoTaksa.compareTo(BigDecimal.ZERO) == 0) {
            this.cbEko.setVisible(false);
        }
    }

    protected void initGUI() {
        try {
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0};
            mainPanelLayout.rowHeights = new int[]{65, 180};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{426, 244};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            this.pnlArtikalStanje = new PzPanel();
            this.pnlArtikalStanje.setOpaque(false);
            this.mainPanel.add((Component)this.pnlArtikalStanje, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout pnlArtikalStanjeLayout = new GridBagLayout();
            this.pnlArtikalStanje.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Artikal", 4, 0));
            this.pnlArtikalStanje.setBackground(new Color(214, 214, 214));
            pnlArtikalStanjeLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlArtikalStanjeLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlArtikalStanjeLayout.columnWidths = new int[]{114, 125, 7, 20};
            pnlArtikalStanjeLayout.rowHeights = new int[]{7, 20, 7, 7, 7, 7, 7, 7, 17};
            this.pnlArtikalStanje.setLayout((LayoutManager)pnlArtikalStanjeLayout);
            this.jLabel1 = new JLabel();
            this.pnlArtikalStanje.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
            this.jLabel1.setText("Interna \u0161ifra");
            this.jLabel2 = new JLabel();
            this.pnlArtikalStanje.add((Component)this.jLabel2, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel2.setText("Zate\u010dena koli\u010dina");
            this.jLabel3 = new JLabel();
            this.pnlArtikalStanje.add((Component)this.jLabel3, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel3.setText("Tarifna grupa");
            this.jLabel6 = new JLabel();
            this.pnlArtikalStanje.add((Component)this.jLabel6, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel6.setText("Poslednja nabavna");
            this.jLabel7 = new JLabel();
            this.pnlArtikalStanje.add((Component)this.jLabel7, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel7.setText("Prodajna cena");
            this.jLabel8 = new JLabel();
            this.pnlArtikalStanje.add((Component)this.jLabel8, (Object)new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel8.setText("PRNC");
            this.sfrArtDok = new PzTextField();
            this.pnlArtikalStanje.add((Component)this.sfrArtDok, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.sfrArtDok.setFKField(Stanjeartikal.class, PzArtikliBrowser.class, true, null);
            this.zatKolicina = new PzDoubleField();
            this.pnlArtikalStanje.add((Component)this.zatKolicina, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.zatKolicina.setEditable(false);
            this.zatKolicina.setFocusable(false);
            this.tarGrupa = new PzTextField();
            this.pnlArtikalStanje.add((Component)this.tarGrupa, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tarGrupa.setEditable(false);
            this.tarGrupa.setFocusable(false);
            this.poslNabavna = new PzDoubleField();
            this.pnlArtikalStanje.add((Component)this.poslNabavna, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.poslNabavna.setEditable(false);
            this.poslNabavna.setFocusable(false);
            this.prodajnaCena = new PzDoubleField();
            this.pnlArtikalStanje.add((Component)this.prodajnaCena, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.prodajnaCena.setEditable(false);
            this.prodajnaCena.setFocusable(false);
            this.prnc = new PzDoubleField();
            this.pnlArtikalStanje.add((Component)this.prnc, (Object)new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.prnc.setEditable(false);
            this.prnc.setFocusable(false);
            this.nazivArt = new PzTextField();
            this.pnlArtikalStanje.add((Component)this.nazivArt, (Object)new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.nazivArt.setEditable(false);
            this.nazivArt.setFocusable(false);
            this.indSifra = new PzFieldIndikator();
            this.pnlArtikalStanje.add((Component)this.indSifra, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.jLabel13 = new JLabel();
            this.pnlArtikalStanje.add((Component)this.jLabel13, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel13.setText("Naziv artikla");
            this.lblDobSifra = new JLabel("Dobavlja\u010deva \u0161ifra");
            this.pnlArtikalStanje.add((Component)this.lblDobSifra, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
            this.dobSifra = new PzTextField();
            this.dobSifra.setInputVerifier(new InputVerifier(){
                List<EksternaSifra> esl;

                @Override
                public boolean verify(JComponent arg0) {
                    if (Dodavanje.this.dobSifra.getVal().equals("")) {
                        return true;
                    }
                    EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                    this.esl = em.createQuery("SELECT es FROM EksternaSifra es WHERE es.komitent=:komitent and es.sifra=:sifra").setParameter("komitent", (Object)Dodavanje.this.kalkulacija.getKomitent()).setParameter("sifra", (Object)Dodavanje.this.dobSifra.getVal()).getResultList();
                    if (this.esl.size() == 0) {
                        em.close();
                        return true;
                    }
                    Dodavanje.this.dobSifra.setVal((Object)this.esl.get(0).getSifra());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Dodavanje.this.setEntity((PzEntity)esl.get(0).getArtikal(), (Component)Dodavanje.this.dobSifra);
                        }
                    });
                    em.close();
                    return true;
                }
            });
            this.pnlArtikalStanje.add((Component)this.dobSifra, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 2, 0), 0, 0));
            this.btnDodavanje = new PzButton();
            this.btnDodavanje.setShortcut("insert");
            this.btnDodavanje.addActionListener((ActionListener)((Object)this));
            this.btnDodavanje.setFocusable(false);
            this.btnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/add2.png")));
            this.btnDodavanje.setText("Novi artikal|(INS)");
            this.pnlArtikalStanje.add((Component)this.btnDodavanje, (Object)new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.header = new PzPanelHeader();
            this.header.setOpaque(false);
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.mainPanel.add((Component)this.header, (Object)new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.header.setPreferredSize(new Dimension(341, 70));
            this.pnlFields = new PzPanel();
            this.pnlFields.setTransferFocusOnEnter(true);
            this.pnlFields.setOpaque(false);
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlFields, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 3, 0, 0), 0, 0));
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            int[] nArray = new int[3];
            nArray[1] = 108;
            nArray[2] = 7;
            pnlFieldsLayout.columnWidths = nArray;
            pnlFieldsLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.0, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{7, 7, 7, 7, 20, 26, 7, 7, 7, 20, 7, 7, 7, 7};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.jLabel4 = new JLabel();
            this.pnlFields.add((Component)this.jLabel4, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
            this.jLabel4.setText("Koli\u010dina");
            this.jLabel5 = new JLabel();
            this.pnlFields.add((Component)this.jLabel5, (Object)new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel5.setText("% mar\u017ee");
            this.jLabel9 = new JLabel();
            this.pnlFields.add((Component)this.jLabel9, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel9.setText("Fakturna cena");
            this.jLabel10 = new JLabel();
            this.pnlFields.add((Component)this.jLabel10, (Object)new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel10.setText("Prodajna cena");
            this.jLabel11 = new JLabel();
            this.pnlFields.add((Component)this.jLabel11, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel11.setText("% rabata");
            this.kolicina = new PzDoubleField();
            this.kolicina.setDecimalFormat(PzFormatFactory.getKolicinaFormat());
            this.pnlFields.add((Component)this.kolicina, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.kolicina.setVerifyInput(true);
            this.kolicina.setCustomInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    block7: {
                        if (Dodavanje.this.domaciKomitent != null && Dodavanje.this.domaciKomitent == 0) {
                            Dodavanje.this.getSession().putParameter("dlgKalkulacija", (Object)Dodavanje.this.dlgKalkulacija);
                            Dodavanje.this.showDialog(PzDialogPomocEvro.class);
                            Double nabavnaCena = (Double)Dodavanje.this.getSession().getParameter("nabavnaCena");
                            if (nabavnaCena == null || nabavnaCena == 0.0) {
                                return false;
                            }
                            Dodavanje.this.faktCena.setVal(Dodavanje.this.getSession().getParameter("nabavnaCena"));
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Dodavanje.this.procRabata.requestFocusInWindow();
                                }
                            });
                        } else {
                            block8: {
                                Firma firma = PzFirma.getFirma();
                                if (Dodavanje.this.kalkulacija.getKomitent().getObveznikPDV() != 1 || firma.getPdvObveznik() != 0) break block7;
                                Dodavanje.this.showDialog(PzDialogPomocPriObradiNabCene.class);
                                Double nabavnaCena = (Double)Dodavanje.this.getSession().getParameter("nabavnaCena");
                                if (nabavnaCena != null && nabavnaCena != 0.0) break block8;
                                return false;
                            }
                            try {
                                Dodavanje.this.faktCena.setVal(Dodavanje.this.getSession().getParameter("nabavnaCena"));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (Dodavanje.this.kolicina.getVal() == 0.0) {
                        Dodavanje.this.kolicina.setState(PzFieldIndikator.STATE_INVALID);
                        return false;
                    }
                    Dodavanje.this.indKolicina.setState(PzFieldIndikator.STATE_VALID);
                    return true;
                }
            });
            this.procMarze = new PzDoubleField();
            this.procMarze.setDecimalFormat(PzFormatFactory.getProcMarzeFormat());
            this.pnlFields.add((Component)this.procMarze, (Object)new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.procMarze.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    Dodavanje.this.keyReleased1(arg0);
                    return true;
                }
            });
            this.faktCena = new PzDoubleField();
            this.faktCena.setDecimalFormat(PzFormatFactory.getFakturnaCenaFormat());
            this.pnlFields.add((Component)this.faktCena, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.faktCena.setVerifyInput(true);
            this.faktCena.setCustomInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (Dodavanje.this.faktCena.getVal() == 0.0) {
                        Dodavanje.this.indNabCena.setState(PzFieldIndikator.STATE_INVALID);
                        return false;
                    }
                    Dodavanje.this.indNabCena.setState(PzFieldIndikator.STATE_VALID);
                    Dodavanje.this.keyReleased1(arg0);
                    return true;
                }
            });
            this.prodCena = new PzDoubleField();
            this.prodCena.setDecimalFormat(PzFormatFactory.getProdCenaFormat());
            this.pnlFields.add((Component)this.prodCena, (Object)new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.prodCena.setVerifyInput(true);
            this.prodCena.setCustomInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    Dodavanje.this.keyReleased1(arg0);
                    return true;
                }
            });
            this.procRabata = new PzDoubleField();
            this.procRabata.setDecimalFormat(PzFormatFactory.getProcRabataFormat());
            this.pnlFields.add((Component)this.procRabata, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.procRabata.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    Dodavanje.this.keyReleased1(arg0);
                    return true;
                }
            });
            this.procRabata.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    Dodavanje.this.netoFaktCena.setVal((Object)new Double(Dodavanje.this.faktCena.getVal() - Dodavanje.this.faktCena.getVal() * Dodavanje.this.procRabata.getVal() / 100.0));
                }
            });
            this.nabVred = new PzDoubleField();
            this.nabVred.setOpaque(false);
            this.pnlFields.add((Component)this.nabVred, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.nabVred.setFocusable(false);
            this.nabVred.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.jLabel12 = new JLabel();
            this.pnlFields.add((Component)this.jLabel12, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel12.setText("Nabavna vrednost =");
            this.btnOK = new PzButton();
            this.pnlFields.add((Component)this.btnOK, (Object)new GridBagConstraints(1, 12, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOK.setText("OK");
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/check.png")));
            this.btnOK.setActionCommand("insert");
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.indKolicina = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indKolicina, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indNabCena = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indNabCena, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.lblplus = new JLabel("+");
            this.pnlFields.add((Component)this.lblplus, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.ukTros = new PzDoubleField();
            this.ukTros.setFocusable(false);
            this.ukTros.setOpaque(false);
            this.pnlFields.add((Component)this.ukTros, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.ukTros.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.ukTros.setName("ukTros");
            this.lblTros = new JLabel("udeo u tro\u0161kovima");
            this.pnlFields.add((Component)this.lblTros, (Object)new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.sep = new JSeparator();
            this.pnlFields.add((Component)this.sep, (Object)new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.lblEuals = new JLabel("=");
            this.pnlFields.add((Component)this.lblEuals, (Object)new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.ukNabVred = new PzDoubleField();
            this.ukNabVred.setFocusable(false);
            this.ukNabVred.setOpaque(false);
            this.ukNabVred.setFont(new Font("SansSerif", 1, 14));
            this.pnlFields.add((Component)this.ukNabVred, (Object)new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.ukNabVred.setName("ukNabVred");
            this.ukNabVred.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.lblNabCena = new JLabel("Nabavna cena =");
            this.pnlFields.add((Component)this.lblNabCena, (Object)new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.nabCen = new PzDoubleField();
            this.nabCen.setFocusable(false);
            this.nabCen.setOpaque(false);
            this.nabCen.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.pnlFields.add((Component)this.nabCen, (Object)new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.nabCen.setName("nabCen");
            this.lblNetoFakturna = new JLabel("Neto fakturna cena");
            this.pnlFields.add((Component)this.lblNetoFakturna, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.netoFaktCena = new PzDoubleField();
            this.netoFaktCena.setDecimalFormat(PzFormatFactory.getFakturnaCenaFormat());
            this.netoFaktCena.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    Dodavanje.this.keyReleased1((JComponent)Dodavanje.this.procRabata);
                    return true;
                }
            });
            this.netoFaktCena.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (Dodavanje.this.faktCena.getVal() == 0.0) {
                        Dodavanje.this.procRabata.setVal((Object)0);
                    } else {
                        Dodavanje.this.procRabata.setVal((Object)new Double((1.0 - Dodavanje.this.netoFaktCena.getVal() / Dodavanje.this.faktCena.getVal()) * 100.0));
                    }
                }
            });
            this.pnlFields.add((Component)this.netoFaktCena, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.cbEko = new JCheckBox("EKO taksa");
            this.pnlFields.add((Component)this.cbEko, (Object)new GridBagConstraints(2, 11, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.sfrArtDok.setStateIndikator(this.indSifra);
            this.faktCena.setStateIndikator(this.indNabCena);
            this.kolicina.setStateIndikator(this.indKolicina);
            this.setResizable(false);
            this.setRestorable(false);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnDodavanje) {
            this.getSession().putParameter("NOVI_ARTIKAL", (Object)this.napraviArtikal(this.imported));
            this.showDialog(DodavanjeExtended.class);
            art = (Artikal)this.getSession().getParameter("INSERTED_ARTIKAL");
            if (art != null) {
                this.getSession().putParameter("INSERTED_ARTIKAL", null);
                this.setEntity((PzEntity)art, (Component)this);
                this.sfrArtDok.setState(PzFieldIndikator.STATE_VALID);
            }
            return;
        }
        if (!this.pnlArtikalStanje.validateForm(true) || !this.pnlFields.validateForm(true)) {
            return;
        }
        em = PzEntityManagerFactory.getInstance().createEm();
        try {
            em.getTransaction().begin();
            es = (EksternaSifra)em.find(EksternaSifra.class, (Object)new EksternaSifraPK(this.artikal.getSfrProizvod(), this.kalkulacija.getKomitent().getSfrKomitent()));
            if (es == null) {
                espk = new EksternaSifraPK(this.artikal.getSfrProizvod(), this.kalkulacija.getKomitent().getSfrKomitent());
                es = new EksternaSifra();
                es.setId(espk);
            }
            es.setSifra(this.dobSifra.getVal());
            em.merge((Object)es);
            actionCommand = ((PzButton)e.getSource()).getActionCommand();
            if (!actionCommand.equals("insert")) ** GOTO lbl63
            i = this.checkArtikal();
            if (i == 0) {
                this.kolicina.setVal((Object)0);
                this.procMarze.setVal((Object)0);
                this.faktCena.setVal((Object)0);
                this.prodCena.setVal((Object)0);
                this.procRabata.setVal((Object)0);
                this.nabVred.setVal((Object)0);
                this.nabCen.setVal((Object)0);
                this.ukNabVred.setVal((Object)0);
                this.ukTros.setVal((Object)0);
                this.setFirstComponentInFocus((Component)this.sfrArtDok);
lbl37:
                // 2 sources

                return;
            }
            try {
                block21: {
                    if (i == 1) {
                        this.dispose();
                        ** continue;
                    }
                    this.artdok = new Artikalkalkulacija();
                    this.artdok.init(this.artikal, (PzDokument)this.kalkulacija);
                    this.artdok.setKolicina(this.kolicina.getVal().doubleValue());
                    this.artdok.setFakturnaCena(this.faktCena.getVal().doubleValue());
                    this.artdok.setNaziv(this.nazivArt.getText());
                    this.artdok.setProcRabata(this.procRabata.getVal().doubleValue());
                    this.artdok.setProcMarze(this.procMarze.getVal().doubleValue());
                    this.artdok.setProdCena(this.prodCena.getBigDecimal());
                    this.artdok.setZavTroskovi(this.udeoTrosak + this.udeoTrosak1);
                    this.artdok.setNabCena(this.artdok.getFakturnaCena() * (1.0 - this.artdok.getProcRabata() / 100.0) + this.artdok.getZavTroskovi());
                    this.artdok.setDobSifra(this.dobSifra.getVal());
                    if (this.cbEko.isSelected()) {
                        if (this.artdok.getArtikal().getTezina() == 0.0) {
                            throw new PzInfoException("Artikal nema podesenu tezinu. Eko taksa ne moze biti obracunata");
                        }
                        this.artdok.setEko(this.ekoTaksa);
                    }
                    this.tableProvera.insert((PzEntity)this.artdok, em);
                    em.getTransaction().commit();
                    this.tableProvera.commitInsert();
                    break block21;
lbl63:
                    // 1 sources

                    if (actionCommand.equals("update")) {
                        this.artdok.setKolicina(this.kolicina.getVal().doubleValue());
                        this.artdok.setFakturnaCena(this.faktCena.getVal().doubleValue());
                        this.artdok.setNaziv(this.nazivArt.getText());
                        this.artdok.setProcRabata(this.procRabata.getVal().doubleValue());
                        this.artdok.setProcMarze(this.procMarze.getVal().doubleValue());
                        this.artdok.setProdCena(this.prodCena.getBigDecimal());
                        this.artdok.setZavTroskovi(this.udeoTrosak + this.udeoTrosak1);
                        this.artdok.setNabCena(this.artdok.getFakturnaCena() * (1.0 - this.artdok.getProcRabata() / 100.0) + this.artdok.getZavTroskovi());
                        this.artdok.setDobSifra(this.dobSifra.getVal());
                        if (this.cbEko.isSelected()) {
                            if (this.artdok.getArtikal().getTezina() == 0.0) {
                                throw new PzInfoException("Artikal nema podesenu tezinu. Eko taksa ne moze biti obracunata");
                            }
                            this.artdok.setEko(this.ekoTaksa);
                        } else {
                            this.artdok.setEko(BigDecimal.ZERO);
                        }
                        this.tableProvera.updateSelectedEntity((PzEntity)this.artdok, em);
                        em.getTransaction().commit();
                        this.tableProvera.commitUpdate();
                    }
                }
                this.dispose();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Throwable)e1);
            }
        }
        finally {
            em.close();
        }
    }

    protected void onInsert() {
        this.btnOK.setActionCommand("insert");
        if (this.getSession().getParameter("imported") != null) {
            Artikalkalkulacija ak;
            this.imported = ak = (Artikalkalkulacija)this.getSession().getParameter("imported");
            if (ak != null && ak.getArtikal() != null) {
                this.getSession().putParameter("imported", null);
                if (this.kalkulacija == null) {
                    this.kalkulacija = (Kalkulacija)this.getSession().getParameter("kalkulacija");
                }
                this.setEntity((PzEntity)ak.getArtikal(), null);
                this.sfrArtDok.setEnabled(false);
            }
            this.dobSifra.setVal((Object)ak.getDobSifra());
            this.kolicina.setVal((Object)ak.getKolicina());
            this.faktCena.setVal((Object)ak.getFakturnaCena());
            this.procRabata.setVal((Object)ak.getProcRabata());
            this.procMarze.setVal((Object)ak.getProcMarze());
            this.prodCena.setVal((Object)ak.getProdCena());
            this.pnlFields.updateAllFieldsState();
            this.pnlArtikalStanje.updateAllFieldsState();
            if (ak != null && ak.getArtikal() == null) {
                if (this.kalkulacija == null) {
                    this.kalkulacija = (Kalkulacija)this.getSession().getParameter("kalkulacija");
                }
                this.btnDodavanje.doClick();
            }
        }
    }

    protected void onUpdate() {
        this.btnOK.setActionCommand("update");
        this.kalkulacija = (Kalkulacija)this.getSession().getParameter("kalkulacija");
        this.tableProvera = (PzTable)this.getSession().getParameter("table");
        this.artdok = (Artikalkalkulacija)this.tableProvera.getSelectedEntity();
        this.setEntity((PzEntity)this.artdok.getArtikal(), (Component)this.sfrArtDok);
        this.sfrArtDok.setEnabled(false);
        this.kolicina.setVal((Object)this.artdok.getKolicina());
        this.faktCena.setVal((Object)this.artdok.getFakturnaCena());
        this.procRabata.setVal((Object)this.artdok.getProcRabata());
        this.procMarze.setVal((Object)this.artdok.getProcMarze());
        this.prodCena.setVal((Object)this.artdok.getProdCena());
        this.pnlFields.updateAllFieldsState();
        this.pnlArtikalStanje.updateAllFieldsState();
        EksternaSifra es = (EksternaSifra)PzEntityManager.findEntity(EksternaSifra.class, (Object)new EksternaSifraPK(this.artdok.getId().getSfrProizvod(), this.kalkulacija.getKomitent().getSfrKomitent()));
        if (es != null) {
            this.dobSifra.setVal((Object)es.getSifra());
        }
        if (this.artdok.getEko().compareTo(BigDecimal.ZERO) != 0) {
            this.cbEko.setSelected(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setEntity(PzEntity entity, Component component) {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            if (entity == null) {
                return;
            }
            try {
                EksternaSifra es;
                if (entity instanceof Stanjeartikal) {
                    this.artikal = (Artikal)em.find(Artikal.class, (Object)((Stanjeartikal)entity).getId().getSfrProizvod());
                } else if (entity instanceof Artikal) {
                    this.artikal = (Artikal)entity;
                }
                if (this.artikal.getTarifnaGrupa("PDV") == null) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Artikal nema definisanu tarifnu grupu za PDV!");
                    return;
                }
                this.sfrArtDok.setVal((Object)this.artikal.getSfrProizvod());
                this.nazivArt.setText(this.artikal.getNaziv());
                this.tarGrupa.setText(String.valueOf(this.artikal.getTarifnaGrupa("PDV").getOznTarGr()) + "  (" + this.artikal.getTarifnaGrupa("PDV").getStopa() + "%)");
                Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(this.artikal.getSfrProizvod(), this.kalkulacija.getRadnajedinica()));
                this.zatKolicina.setVal((Object)(s != null ? s.getKolicina() : 0.0));
                this.poslNabavna.setVal((Object)(s != null ? s.getZadNabCena() : 0.0));
                this.prodajnaCena.setVal((Object)(s != null ? s.getProdCena() : 0.0));
                this.prodCena.setVal((Object)(s != null ? s.getProdCena() : 0.0));
                this.procMarze.setVal((Object)0);
                this.prnc.setVal((Object)(s != null ? s.getProsNabCena() : Double.valueOf(0.0)));
                if (component == this.sfrArtDok && (es = (EksternaSifra)em.find(EksternaSifra.class, (Object)new EksternaSifraPK(this.artikal.getSfrProizvod(), this.kalkulacija.getKomitent().getSfrKomitent()))) != null && this.dobSifra.getVal().equals("")) {
                    this.dobSifra.setVal((Object)es.getSifra());
                }
                this.kolicina.requestFocusInWindow();
                return;
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
            return;
        }
        finally {
            em.close();
        }
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Dodavanje artikla");
        this.setHeaderIcon("rs/pezar/nabavka/resource/img/product_new.png");
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Ispravka na artiklu");
        this.setHeaderIcon("rs/pezar/nabavka/resource/img/product_edit.png");
    }

    private void keyReleased1(JComponent c) {
        double stopaPDV;
        double trosak = this.dlgKalkulacija.getTrosak();
        BigDecimal trosakBezPdv = this.kalkulacija.getTrosakBezPdv();
        double pdv = this.dlgKalkulacija.getPDV();
        double n = this.faktCena.getVal() * (1.0 - this.procRabata.getVal() / 100.0);
        double iznos = this.dlgKalkulacija.getIznos();
        this.udeoTrosak = iznos != 0.0 ? n / (iznos - trosakBezPdv.doubleValue() - pdv) * trosakBezPdv.doubleValue() : 0.0;
        this.udeoTrosak1 = iznos != 0.0 ? n / (iznos - trosakBezPdv.doubleValue() - pdv) * (trosak - trosakBezPdv.doubleValue()) : 0.0;
        double d = stopaPDV = this.artikal != null ? this.artikal.getTarifnaGrupa("PDV").getStopa() / 100.0 : this.artdok.getArtikal().getTarifnaGrupa("PDV").getStopa() / 100.0;
        if (c == this.procRabata || c == this.netoFaktCena) {
            if (this.prodCena.getVal() > 0.0) {
                Double res = 0.0;
                if (this.kalkulacija.getRadnajedinica().getgTip().equals("V")) {
                    res = 100.0 * (this.prodCena.getVal() / ((1.0 - this.procRabata.getVal() / 100.0) * this.faktCena.getVal() + this.udeoTrosak + this.udeoTrosak1) - 1.0);
                } else if (this.kalkulacija.getRadnajedinica().getgTip().equals("E")) {
                    res = 100.0 * (this.prodCena.getVal() / (((1.0 - this.procRabata.getVal() / 100.0) * this.faktCena.getVal() + this.udeoTrosak + this.udeoTrosak1) * (stopaPDV + 1.0)) - 1.0);
                }
                this.procMarze.setVal((Object)res);
            }
            this.nabVred.setVal((Object)(this.kolicina.getVal() * this.netoFaktCena.getVal()));
            this.ukTros.setVal((Object)(this.udeoTrosak + this.udeoTrosak1));
            this.ukNabVred.setVal((Object)(this.nabVred.getVal() + this.udeoTrosak + this.udeoTrosak1));
            this.nabCen.setVal((Object)(this.ukNabVred.getVal() / this.kolicina.getVal()));
        } else if (c == this.procMarze) {
            double res = 0.0;
            if (this.kalkulacija.getRadnajedinica().getgTip().equals("V")) {
                res = ((1.0 - this.procRabata.getVal() / 100.0) * this.faktCena.getVal() + this.udeoTrosak + this.udeoTrosak1) * (1.0 + this.procMarze.getVal() / 100.0);
            } else if (this.kalkulacija.getRadnajedinica().getgTip().equals("E")) {
                res = ((1.0 - this.procRabata.getVal() / 100.0) * this.faktCena.getVal() + this.udeoTrosak + this.udeoTrosak1) * (stopaPDV + 1.0) * (1.0 + this.procMarze.getVal() / 100.0);
            }
            this.prodCena.setVal((Object)res);
        } else if (c == this.kolicina || c == this.faktCena) {
            this.nabVred.setVal((Object)(this.kolicina.getVal() * this.faktCena.getVal() * (1.0 - this.procRabata.getVal() / 100.0)));
        } else if (c == this.prodCena) {
            if (this.kalkulacija.getRadnajedinica().getgTip().equals("V")) {
                this.procMarze.setVal((Object)(100.0 * (this.prodCena.getVal() / ((1.0 - this.procRabata.getVal() / 100.0) * this.faktCena.getVal() + this.udeoTrosak + this.udeoTrosak1) - 1.0)));
            } else if (this.kalkulacija.getRadnajedinica().getgTip().equals("E")) {
                this.procMarze.setVal((Object)(100.0 * (this.prodCena.getVal() / (((1.0 - this.procRabata.getVal() / 100.0) * this.faktCena.getVal() + this.udeoTrosak + this.udeoTrosak1) * (stopaPDV + 1.0)) - 1.0)));
            }
        }
    }

    private int checkArtikal() {
        int control = 3;
        int check = 3;
        if (this.kalkulacija.getArtikalkalkulacijas() != null) {
            Artikalkalkulacija b = new Artikalkalkulacija();
            for (Artikalkalkulacija a : this.kalkulacija.getArtikalkalkulacijas()) {
                if (a.getId().getSfrProizvod().toString().equals(this.sfrArtDok.getVal().toString()) && a.getFakturnaCena() == this.faktCena.getVal().doubleValue() && a.getProdCena().doubleValue() == this.prodCena.getVal().doubleValue()) {
                    control = 1;
                    b = a;
                    continue;
                }
                if (a.getId().getSfrProizvod().toString().equals(this.sfrArtDok.getVal().toString()) && a.getProdCena().doubleValue() != this.prodCena.getVal().doubleValue()) {
                    control = 0;
                    continue;
                }
                if (!a.getId().getSfrProizvod().toString().equals(this.sfrArtDok.getVal().toString()) || a.getFakturnaCena() == this.faktCena.getVal().doubleValue() || a.getProdCena().doubleValue() != this.prodCena.getVal().doubleValue() || control == 1) continue;
                control = 2;
                b = a;
            }
            if (control == 0) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Ne mo\u017eete dodati dva ista artikla sa razli\u010ditim prodajnim cenama.");
                check = 0;
            } else if (control == 1) {
                int i = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Artikal ve\u0107 postoji na kalkulaciji. Da li ste sigurni da \u017eelite ponovo da ga dodate?", (String)"Postoje\u0107i artikal", null, (boolean)false);
                if (i != 0) {
                    check = 0;
                } else {
                    b.setKolicina(b.getKolicina() + this.kolicina.getVal());
                    try {
                        PzEntityManager.update((Object)b);
                        this.tableProvera.update(Integer.valueOf(this.tableProvera.convertRowIndexToView(this.kalkulacija.getArtikalkalkulacijas().indexOf(b))), (PzEntity)b, true);
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                    }
                    check = 1;
                }
            } else if (control == 2) {
                int i = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Ovaj artikal ve\u0107 postoji na kalkulaciji sa razli\u010ditom nabavnom cenom. Da li ste sigurni da \u017eelite ponovo da ga dodate?", (String)"Postoje\u0107i artikal sa razli\u010ditom nabavnom cenom", null, (boolean)false);
                check = i != 0 ? 0 : 2;
            }
        }
        return check;
    }

    public Double getFaktCena() {
        return this.faktCena.getVal();
    }

    public static Object getGUIBuilderInstance() {
        return new Dodavanje(Boolean.FALSE);
    }

    public Dodavanje(Boolean initGUI) {
    }

    private Artikal napraviArtikal(Artikalkalkulacija ak) {
        if (ak == null) {
            return new Artikal();
        }
        Artikal art = new Artikal();
        art.setNaziv(ak.getNaziv());
        art.setBliziOpis(ak.getBliziOpis());
        art.setJedMere(ak.getJm());
        art.setDobSifra(ak.getDobSifra());
        art.setDobavljac(this.kalkulacija != null ? this.kalkulacija.getKomitent() : null);
        art.setKatBroj(ak.getDobSifra());
        if (ak.getId() != null && ak.getId().getSfrProizvod() != null) {
            art.setSfrProizvod(ak.getId().getSfrProizvod());
        }
        return art;
    }
}

