/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui.kalkulacija.pdv;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.db.entity.TaksakalkulacijaPK;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.sifarnici.gui.PzDialogStopePoreza;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class Dodavanje
extends PzDialogInsert {
    private static final long serialVersionUID = -3362895422040638148L;
    private PzPanel panel;
    private PzFieldIndikator indPdv;
    private PzFieldIndikator indOsnovica;
    private PzFieldIndikator indTgr;
    private JTextField stopa;
    private PzDoubleField pdv;
    private PzButton btnOK;
    private PzDoubleField osnovica;
    private PzTextField tarifa;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzPanelHeader header;
    private Tarifnagrupa tgr;
    private PzPanel mainPanel;
    private Kalkulacija kalkulacija;
    private PzTable table;

    public Dodavanje(PzDialog dialog) {
        super(dialog);
        this.kalkulacija = (Kalkulacija)this.getSession().getParameter("kalkulacija");
        this.table = (PzTable)this.getSession().getParameter("table");
        this.paintPanel();
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    protected void initGUI() {
        try {
            this.mainPanel = new PzPanel();
            BorderLayout mainPanelLayout = new BorderLayout();
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.header = new PzPanelHeader();
            this.header.setOpaque(false);
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.mainPanel.add((Component)this.header, (Object)"North");
            this.panel = new PzPanel();
            this.panel.setOpaque(false);
            this.mainPanel.add((Component)this.panel, (Object)"Center");
            this.panel.setTransferFocusOnEnter(true);
            GridBagLayout panelLayout = new GridBagLayout();
            panelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            panelLayout.rowHeights = new int[]{25, 25, 25, 45};
            panelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            panelLayout.columnWidths = new int[]{70, 70, 86, 20, 45, 20, 7};
            this.panel.setLayout((LayoutManager)panelLayout);
            this.jLabel1 = new JLabel();
            this.panel.add((Component)this.jLabel1, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 5, 1, 5), 0, 0));
            this.jLabel1.setText("Tarifa");
            this.jLabel2 = new JLabel();
            this.panel.add((Component)this.jLabel2, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 5, 1, 5), 0, 0));
            this.jLabel2.setText("Osnovica");
            this.jLabel3 = new JLabel();
            this.panel.add((Component)this.jLabel3, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 5, 1, 5), 0, 0));
            this.jLabel3.setText("PDV");
            this.tarifa = new PzTextField();
            this.panel.add((Component)this.tarifa, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tarifa.setToUpperCase(true);
            this.tarifa.setVerifyInput(true);
            this.tarifa.setFKField(Tarifnagrupa.class, PzDialogStopePoreza.class, true, null);
            this.tarifa.setMaxLength(5);
            this.osnovica = new PzDoubleField();
            this.panel.add((Component)this.osnovica, (Object)new GridBagConstraints(2, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 20), 0, 0));
            this.osnovica.setVerifyInput(true);
            this.osnovica.setName("osnovica");
            this.osnovica.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    Dodavanje.this.osnovicaKeyReleased(evt);
                }
            });
            this.osnovica.setVerifyInput(true);
            this.pdv = new PzDoubleField();
            this.panel.add((Component)this.pdv, (Object)new GridBagConstraints(2, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 20), 0, 0));
            this.pdv.setName("iznos");
            this.stopa = new JTextField();
            this.panel.add((Component)this.stopa, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 1, 0), 0, 0));
            this.stopa.setEditable(false);
            this.stopa.setFocusable(false);
            this.stopa.setForeground(new Color(0, 128, 0));
            this.indTgr = new PzFieldIndikator();
            this.panel.add((Component)this.indTgr, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 1, 0), 0, 0));
            this.indOsnovica = new PzFieldIndikator();
            this.panel.add((Component)this.indOsnovica, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 1, 0), 0, 0));
            this.indPdv = new PzFieldIndikator();
            this.panel.add((Component)this.indPdv, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 1, 0), 0, 0));
            this.btnOK = new PzButton();
            this.panel.add((Component)this.btnOK, (Object)new GridBagConstraints(2, 3, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 10, 0), 0, 0));
            this.btnOK.setText("Potvrdi");
            this.btnOK.setFont(new Font("Tahoma", 1, 12));
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/check.png")));
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.btnOK.setShortcut("ctrl+w");
            this.tarifa.setStateIndikator(this.indTgr);
            this.osnovica.setStateIndikator(this.indOsnovica);
            this.pdv.setStateIndikator(this.indPdv);
            this.pack();
            this.setResizable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String actionCommand = e.getActionCommand();
            if (actionCommand.equalsIgnoreCase("odustajanje")) {
                this.dispose();
            } else if (actionCommand.equals("insert")) {
                TaksakalkulacijaPK id = new TaksakalkulacijaPK(this.kalkulacija.getIdDok(), this.tgr.getOznTarGr());
                Taksakalkulacija pdvk = new Taksakalkulacija();
                pdvk.setId(id);
                pdvk.setIznos(this.pdv.getBigDecimal());
                pdvk.setOsnovica(this.osnovica.getBigDecimal());
                pdvk.setTarifnagrupa(this.tgr);
                pdvk.setVrsta(this.tgr.getVrstatg().getOznVrstaTG());
                pdvk.setKalkulacija(this.kalkulacija);
                if (((Boolean)this.getSession().getParameter("storno")).booleanValue()) {
                    this.table.insert((PzEntity)pdvk, false);
                } else {
                    int i = 0;
                    while (i < this.table.getRowCount()) {
                        Taksakalkulacija tk = (Taksakalkulacija)this.table.getEntity(i);
                        if (tk.getTarifnagrupa().getOznTarGr().equals(pdvk.getTarifnagrupa().getOznTarGr())) {
                            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Ve\u0107 ste uneli PDV sa ovom tarifnom grupom.");
                            this.tarifa.requestFocus();
                            return;
                        }
                        ++i;
                    }
                    this.table.insert((PzEntity)pdvk, true);
                }
                this.dispose();
            } else if (actionCommand.equals("update")) {
                Taksakalkulacija pdvk = (Taksakalkulacija)this.table.getSelectedEntity();
                pdvk.setIznos(this.pdv.getBigDecimal());
                pdvk.setOsnovica(this.osnovica.getBigDecimal());
                if (((Boolean)this.getSession().getParameter("storno")).booleanValue()) {
                    this.table.updateSelectedEntity((PzEntity)pdvk, false);
                } else {
                    this.table.updateSelectedEntity((PzEntity)pdvk, true);
                }
                this.dispose();
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new Dodavanje(Boolean.FALSE);
    }

    public Dodavanje(Boolean initGUI) {
    }

    protected void onInsert() {
        this.btnOK.setActionCommand("insert");
    }

    protected void onUpdate() {
        this.kalkulacija = (Kalkulacija)this.getSession().getParameter("kalkulacija");
        this.table = (PzTable)this.getSession().getParameter("table");
        Taksakalkulacija taksa = (Taksakalkulacija)this.table.getSelectedEntity();
        this.tarifa.setVal((Object)taksa.getId().getOznTarGr());
        this.osnovica.setVal((Object)taksa.getOsnovica());
        this.pdv.setVal((Object)taksa.getIznos());
        this.tgr = taksa.getTarifnagrupa();
        this.stopa.setText(this.tgr.getStopa() + "%");
        this.btnOK.setActionCommand("update");
        this.tarifa.setEnabled(false);
        this.panel.updateAllFieldsState();
    }

    public void setEntity(PzEntity entity, Component component) {
        this.tgr = (Tarifnagrupa)entity;
        if (this.tgr != null) {
            String pom = this.tarifa.getVal().toUpperCase();
            this.tarifa.setVal((Object)pom);
            this.tarifa.setVal((Object)this.tgr.getOznTarGr());
            this.stopa.setText(this.tgr.getStopa() + "%");
        }
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Unos PDV-a");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/row_new.png")));
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Ispravka PDV-a");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/row_edit.png")));
    }

    private void osnovicaKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.pdv.setVal((Object)(this.osnovica.getVal() * this.tgr.getStopa() / 100.0));
        }
    }
}

