/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui.neocarinjenaRoba;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikalcarinadokument;
import rs.pezar.db.entity.CarinaDokument;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.util.PzGradient;

public class Arhiviranje
extends PzDialog {
    private PzPanel mainPanel;
    private PzDateField dfDatum;
    private PzButton btnPotvrdi;
    private PzTextAreaPanel jtaNapomena;
    private JLabel lblDatum;
    private final CarinaDokument prijem;

    public Arhiviranje(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        this.paintPanel();
        this.prijem = (CarinaDokument)this.getSession().getParameter("prijemnica");
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            this.setTitle("Arhiviranje");
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.rowHeights = new int[]{30, 25, 19, 91, 110, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{20, 96, 130, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.lblDatum = new JLabel();
            this.mainPanel.add((Component)this.lblDatum, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblDatum.setText("Datum izrade");
            this.dfDatum = new PzDateField();
            this.mainPanel.add((Component)this.dfDatum, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jtaNapomena = new PzTextAreaPanel();
            this.mainPanel.add((Component)this.jtaNapomena, (Object)new GridBagConstraints(0, 3, 5, 2, 0.0, 0.0, 10, 1, new Insets(0, 20, 0, 20), 0, 0));
            this.jtaNapomena.setBorder((Border)BorderFactory.createTitledBorder("Napomena"));
            this.jtaNapomena.setOpaque(false);
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(0, 5, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 80, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(130, 33));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setActionCommand("arhiva");
            this.btnPotvrdi.setShortcut("ctrl+w");
            this.pack();
            this.setSize(529, 387);
            this.setResizable(false);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                if (actionCommand.equals("arhiva")) {
                    em.getTransaction().begin();
                    this.prijem.setDatArh(this.dfDatum.getVal());
                    this.prijem.setPoruka(this.jtaNapomena.getVal());
                    for (Artikalcarinadokument art : this.prijem.getArtikalcarinadokuments()) {
                        Stanje stanje = (Stanje)em.find(Stanje.class, (Object)new StanjePK(art.getId().getSfrProizvod(), this.prijem.getRadnajedinica()));
                        if (stanje == null) {
                            stanje = new Stanje();
                            stanje.setId(new StanjePK(art.getId().getSfrProizvod(), this.prijem.getRadnajedinica()));
                            stanje.setArtikal(art.getArtikal());
                            stanje.setZadNabCena(art.getCenaD());
                            stanje.setDatZadUlaza(this.dfDatum.getVal());
                            stanje.setKolicina(art.getKolicina());
                            stanje.setKumUlaza(stanje.getKumUlaza() + art.getKolicina());
                            em.persist((Object)stanje);
                            continue;
                        }
                        stanje.setKolicina(stanje.getKolicina() + art.getKolicina());
                        stanje.setDatZadUlaza(this.dfDatum.getVal());
                        stanje.setZadNabCena(art.getCenaD());
                        stanje.setKumUlaza(stanje.getKumUlaza() + art.getKolicina());
                    }
                    em.merge((Object)this.prijem);
                    PzDokumentManager.getInstance().arhivirajDokument((PzDokument)this.prijem, true, null, em);
                    em.getTransaction().commit();
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.prijem);
                    this.dispose();
                }
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                this.dispose();
                em.close();
            }
        }
        finally {
            em.close();
        }
    }
}

