/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui.unosNaknadneFakture;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Kalkulacijazapisnik;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.nabavka.gui.PzDialogKakoZatvaranaOtpremnica;
import rs.pezar.nabavka.gui.PzDialogKojeOtpremniceNaNaknadnoj;
import rs.pezar.nabavka.gui.unosNaknadneFakture.Dodavanje;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzSingleListDataSource;
import rs.pezar.reports.engine.dokument.DokumentDS;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzDefaultDataSourceAdapter;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.util.PzFileUtility;

public class PzDialogUzmiDokument
extends PzDialog {
    private JToolBar toolbar;
    private PzToolBarIcon btnSlikaProfakture;
    private PzPanel plGlavni;
    private PzTable tblTabela;
    private JScrollPane scTabela;
    private PzPanel plTabela;
    private JPanel jPanel1;
    private String tableID = "";
    private String sfrKomitent;
    private Radnajedinica rj;
    private String query;
    private Object klasa;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogUzmiDokument inst = new PzDialogUzmiDokument(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogUzmiDokument(JFrame frame) {
        super(frame);
    }

    public PzDialogUzmiDokument(PzDialog dialog) {
        super(dialog);
        if (dialog instanceof Dodavanje) {
            this.sfrKomitent = (String)this.getSession().getParameter("komitent");
            this.query = "SELECT k FROM Kalkulacija k WHERE k.arhiviran = 1 AND (k.podTip='" + TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA + "' OR k.podTip='" + TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA + "') " + "AND k.storno=0 AND k.komitent.sfrKomitent=:sfrKomit AND (k.iznos-k.stornoIznos-k.ukupnoFakturisano) <> 0";
            this.klasa = Kalkulacija.class;
        } else if (dialog instanceof PzDialogKakoZatvaranaOtpremnica || dialog instanceof PzDialogKojeOtpremniceNaNaknadnoj) {
            this.sfrKomitent = (String)this.getSession().getParameter("sfrKomitent");
            if (dialog instanceof PzDialogKakoZatvaranaOtpremnica) {
                this.query = "SELECT k FROM Kalkulacija k WHERE k.arhiviran = 1 AND (k.podTip='" + TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA + "' OR k.podTip='" + TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA + "') AND k.storno=0 AND k.komitent.sfrKomitent=:sfrKomit";
                this.klasa = Kalkulacija.class;
            } else {
                this.query = "SELECT z FROM Kalkulacija z WHERE z.arhiviran = 1 AND z.storno=0 AND z.komitent.sfrKomitent=:sfrKomit AND z.tip='" + TipDokumentConfig.get().ZAPISNIK_OTPREMNICE + "'";
                this.klasa = Kalkulacija.class;
            }
        }
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Pregled dokumenata");
            this.plGlavni = new PzPanel();
            GridBagLayout plGlavniLayout = new GridBagLayout();
            plGlavniLayout.rowWeights = new double[]{0.0, 0.1};
            plGlavniLayout.rowHeights = new int[]{84, 7};
            plGlavniLayout.columnWeights = new double[]{0.1};
            plGlavniLayout.columnWidths = new int[]{7};
            this.plGlavni.setLayout((LayoutManager)plGlavniLayout);
            this.getContentPane().add((Component)this.plGlavni, "Center");
            this.toolbar = new JToolBar();
            this.plGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.btnSlikaProfakture = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnSlikaProfakture);
            this.btnSlikaProfakture.setText("Slika|dokumenta|(F2)");
            this.btnSlikaProfakture.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/presentation.png")));
            this.btnSlikaProfakture.setActionCommand("slika");
            this.btnSlikaProfakture.addActionListener((ActionListener)((Object)this));
            this.btnSlikaProfakture.setShortcut("F2");
            this.jPanel1 = new JPanel();
            this.plGlavni.add((Component)this.jPanel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            BorderLayout jPanel1Layout1 = new BorderLayout();
            this.jPanel1.setLayout(jPanel1Layout1);
            this.plTabela = new PzPanel();
            BorderLayout jPanel1Layout = new BorderLayout();
            this.jPanel1.add((Component)this.plTabela, "Center");
            this.plTabela.setLayout((LayoutManager)jPanel1Layout);
            this.scTabela = new JScrollPane();
            this.plTabela.add((Component)this.scTabela, (Object)"Center");
            this.scTabela.setBackground(new Color(211, 242, 210));
            this.tblTabela = new PzTable();
            this.setTableFilter(this.tblTabela);
            EntityManager em = PzEntityManager.getEm();
            Query q = null;
            q = em.createQuery(this.query);
            q.setParameter("sfrKomit", (Object)this.sfrKomitent);
            Vector data = (Vector)q.getResultList();
            this.tblTabela.setData(data, (Class)this.klasa);
            em.close();
            this.scTabela.setViewportView((Component)this.tblTabela);
            this.tblTabela.getTableHeader().setFocusable(false);
            this.tblTabela.requestFocusInWindow();
            if (this.tblTabela.getDataSize() > 0) {
                this.tblTabela.setRowSelectionInterval(0, 0);
            }
            this.tblTabela.packAll();
            this.pack();
            this.setSize(900, 450);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(null, (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("slika")) {
            if (((Kalkulacija)this.tblTabela.getSelectedEntity()).getTip().equals(TipDokumentConfig.get().ZAPISNIK_OTPREMNICE)) {
                this.showReportZapisnik();
            } else {
                this.showReport();
            }
        }
    }

    public void showReport() {
        try {
            if (this.tblTabela.getSelectedEntity() != null) {
                Kalkulacija kalk = (Kalkulacija)this.tblTabela.getSelectedEntity();
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)kalk);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void showReportZapisnik() {
        try {
            Vector<Firma> data = new Vector<Firma>();
            data.add(PzFirma.getFirma());
            Vector porezi = new Vector();
            porezi.addAll(((Kalkulacija)this.tblTabela.getSelectedEntity()).getTaksakalkulacijas());
            PzSingleListDataSource ulPorez = new PzSingleListDataSource(porezi);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("datum", new Date(new java.util.Date().getTime()));
            String title = null;
            String fname = null;
            title = "ZAPISNIK BR. " + ((Kalkulacija)this.tblTabela.getSelectedEntity()).getrBroj();
            params.put("title", title);
            params.put("ulPorez", ulPorez);
            params.put("porezTblSubreport", (JasperReport)JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.porez.tbl.bigdecimal.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
            params.put("porezSubreport", (JasperReport)JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.porez.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
            params.put("headerStandardSubreport", (JasperReport)JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/header.standard.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
            params.put("headerData", new DokumentDS((PzDokument)((Kalkulacija)this.tblTabela.getSelectedEntity())));
            params.put("reklama", "");
            fname = "rs/pezar/reports/compiled/zapisnik.jasper";
            Vector<Object> s = new Vector<Object>();
            s.add(this.tblTabela.getSelectedEntity());
            s.add(((Kalkulacija)this.tblTabela.getSelectedEntity()).getKomitent());
            s.add(data.get(0));
            Vector d = new Vector();
            d.addAll(((Kalkulacija)this.tblTabela.getSelectedEntity()).getKalkulacijazapisniks1());
            PzDataSourceExtended dse = new PzDataSourceExtended(s, d);
            dse.setAdapter((PzDataSourceAdapter)new PzDefaultDataSourceAdapter(){

                public Object getStaticValue(String fieldName, List<Object> staticContent) throws JRException {
                    if (fieldName.equalsIgnoreCase("zapisnik.brojFakture")) {
                        return ((Kalkulacija)staticContent.get(0)).getOznDokumenta();
                    }
                    if (fieldName.equalsIgnoreCase("zapisnik.iznosFakture")) {
                        return ((Kalkulacija)staticContent.get(0)).getIznos().doubleValue();
                    }
                    if (fieldName.equalsIgnoreCase("zapisnik.datumFakture")) {
                        return ((Kalkulacija)staticContent.get(0)).getDatFakture();
                    }
                    if (fieldName.equalsIgnoreCase("zapisnik.pdv")) {
                        return ((Kalkulacija)staticContent.get(0)).getPdvIznos().doubleValue();
                    }
                    if (fieldName.equalsIgnoreCase("komitent.sfrKomitent")) {
                        return ((Komitent)staticContent.get(1)).getSfrKomitent();
                    }
                    if (fieldName.equalsIgnoreCase("komitent.naziv")) {
                        return ((Komitent)staticContent.get(1)).getNaziv();
                    }
                    if (fieldName.equalsIgnoreCase("komitent.grad")) {
                        return ((Komitent)staticContent.get(1)).getGrad();
                    }
                    if (fieldName.equalsIgnoreCase("komitent.zemljaKomitent")) {
                        return ((Komitent)staticContent.get(1)).getZemljaKomitenta();
                    }
                    return super.getStaticValue(fieldName, staticContent);
                }

                public Object getDynamicValue(String fieldName, Object obj) throws JRException {
                    if (fieldName.equalsIgnoreCase("Kalkulacija.oznDokumenta")) {
                        return ((Kalkulacijazapisnik)obj).getZapisnik().getOznDokumenta();
                    }
                    if (fieldName.equalsIgnoreCase("Kalkulacija.iznos")) {
                        return ((Kalkulacijazapisnik)obj).getZapisnik().getIznos().doubleValue();
                    }
                    if (fieldName.equalsIgnoreCase("Kalkulacija.ukupnoFakturisano")) {
                        return ((Kalkulacijazapisnik)obj).getZapisnik().getUkupnoFakturisano().doubleValue();
                    }
                    if (fieldName.equalsIgnoreCase("Kalkulacija.stornoIznos")) {
                        return ((Kalkulacijazapisnik)obj).getZapisnik().getStornoIznos().doubleValue();
                    }
                    return super.getDynamicValue(fieldName, obj);
                }
            });
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)dse, (String)fname, params, (String)title);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setTableFilter(PzTable table) {
        table.setFilter(new PzEntityFilter(){

            public Object[] getValues(PzEntity entity) {
                Kalkulacija k = (Kalkulacija)entity;
                return new Object[]{k.getKomitent().getSfrKomitent(), k.getKomitent().getNaziv(), k.getOznDokumenta(), k.getDatum(), k.getIznos(), k.getStornoIznos(), k.getUkupnoFakturisano()};
            }

            public String[] getColumnNames() {
                return new String[]{"\u0160ifra dob.", "Naziv dob.", "Br. dokumenta", "Datum dok.", "Iznos", "Stornirano", "Fakturisano"};
            }
        });
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogUzmiDokument(Boolean.FALSE);
    }

    public PzDialogUzmiDokument(Boolean initGUI) {
    }
}

