/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.transformation;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.transformation.DefaultDokumentTransformer;
import rs.pezar.core.transformation.DokumentTransformer;
import rs.pezar.core.transformation.TransformationException;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.Artikallista;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Model;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Robnagrupa;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.nabavka.gui.PzDialogDokumenti;
import rs.pezar.nabavka.gui.PzDialogKalkArhiva;
import rs.pezar.nabavka.transformation.KalkulacijaTransformerParametri;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.sifarnici.gui.artikli.DodavanjeExtended;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.PzGenericTableDialog;
import rs.pezar.util.PzDateUtility;
import rs.pezar.util.PzMathUtility;

public class KalkulacijaTransformer
extends DokumentTransformer {
    public static final String PARAMETER_RJ = "RJ";
    public static final String TRANSFORMER = "KALKULACIJA_TRANSFORMER";
    public static final String PARAMETER_CENA_NABAVNA = "NABAVNA";
    public static final String PARAMETER_CENA_PRODAJNA = "RODAJNA";
    public static final String PARAMETER_KOLICINA = "KOLICINA";
    public static final String PARAMETER_OZNAKA = "OZNAKA";
    public static final int PARAMETER_IZBOR_ZATECENA_NABAVNA = 0;
    public static final int PARAMETER_IZBOR_ZATECENA_PRODAJNA = 0;
    public static final int PARAMETER_IZBOR_CENA_SA_LISTE = 1;
    public static final int PARAMETER_IZBOR_POMOCNA_CENA_SA_LISTE = 2;
    public static final int PARAMETER_IZBOR_ZATECENA_PROS_NAB_CENA = 3;
    public static final int PARAMETER_IZBOR_KOLICINA_SA_LISTE = 0;
    public static final int PARAMETER_IZBOR_POMOCNA_KOLICINA_SA_LISTE = 1;
    private static final String IZBOR_NEPOSTOJECI_PRESKOCI = "PRESKOCI";
    private static final String IZBOR_NEPOSTOJECI_IZABERI = "UNESI";

    public HashMap<String, Object> getDokumentParameters(PzDialog parent, Lista l) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Radnajedinica rj = PzDialogRJ.getRJ((PzDialog)parent);
        if (rj == null) {
            return null;
        }
        parameters.put(PARAMETER_RJ, rj);
        parent.getSession().putParameter(TRANSFORMER, parameters);
        parent.showDialog(KalkulacijaTransformerParametri.class);
        parent.getSession().putParameter(TRANSFORMER, null);
        if (parameters.get(PARAMETER_CENA_NABAVNA) == null) {
            return null;
        }
        return parameters;
    }

    public PzDokument getDokumentToTransform(PzDialog parent) {
        PzChoice[] choices = new PzChoice[]{new PzChoice("Kalkulacija iz arhive", (Object)"ARHIVA"), new PzChoice("Kalkulacija u pripremi", (Object)"U_PRIPREMI")};
        String choice = (String)PzDialogChoice.showPzDialogChoice((PzDialog)parent, (PzChoice[])choices, (String)"Izabor kalkulacije");
        if (choice == null) {
            return null;
        }
        if (choice.equals("ARHIVA")) {
            return PzDialogKalkArhiva.getKalkulacijaIzArhive(parent);
        }
        return PzDialogDokumenti.getKalkulacijaUPripermi(parent);
    }

    public PzDokument toDokument(Lista l, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        Number val;
        List<Object[]> stanja;
        if (l.getKomitent() == null) {
            throw new TransformationException("Gre\u0161ka! Da biste mogli listu da transformisete u kalkulaciju, lista prethodno mora da ima setovanog komitenta");
        }
        Radnajedinica rj = (Radnajedinica)parameters.get(PARAMETER_RJ);
        DefaultDokumentTransformer ddt = new DefaultDokumentTransformer(Kalkulacija.class, Artikalkalkulacija.class);
        if ((Integer)parameters.get(PARAMETER_CENA_NABAVNA) == 1) {
            ddt.addCustomFieldsToCopy(new String[]{"cena", "nabCena"});
            ddt.addCustomFieldsToCopy(new String[]{"cena", "fakturnaCena"});
        } else if ((Integer)parameters.get(PARAMETER_CENA_NABAVNA) == 2) {
            ddt.addCustomFieldsToCopy(new String[]{"pomCena", "nabCena"});
            ddt.addCustomFieldsToCopy(new String[]{"pomCena", "fakturnaCena"});
        }
        if ((Integer)parameters.get(PARAMETER_CENA_PRODAJNA) == 1) {
            ddt.addCustomFieldsToCopy(new String[]{"cena", "prodCena"});
        } else if ((Integer)parameters.get(PARAMETER_CENA_PRODAJNA) == 2) {
            ddt.addCustomFieldsToCopy(new String[]{"pomCena", "prodCena"});
        }
        if ((Integer)parameters.get(PARAMETER_KOLICINA) == 0) {
            ddt.addCustomFieldsToCopy(new String[]{"kolicina", "kolicina"});
        } else {
            ddt.addCustomFieldsToCopy(new String[]{"pomKolicina", "kolicina"});
        }
        Kalkulacija k = (Kalkulacija)ddt.toDokument(l, parameters, em);
        k.setTip(TipDokumentConfig.get().KALKULACIJA);
        k.setPodTip(TipDokumentConfig.get().PODTIP_KALKULACIJA_FAKTURA);
        k.setDatDPO(PzDateUtility.getCurrentDate());
        k.setDatFakture(PzDateUtility.getCurrentDate());
        k.setDatValute(PzDateUtility.getCurrentDate());
        k.setPdv("SA_PRAVOM");
        k.setPoruka("");
        k.setRadnajedinica(rj);
        k.setOznDokumenta((String)parameters.get(PARAMETER_OZNAKA));
        if ((Integer)parameters.get(PARAMETER_CENA_NABAVNA) == 0) {
            stanja = this.getStanja(rj, l, em, "zadNabCena");
            for (Artikalkalkulacija ak : k.getArtikalkalkulacijas()) {
                val = (Double)this.findValue(stanja, ak.getId().getSfrProizvod());
                ak.setNabCena(val.doubleValue());
                ak.setFakturnaCena(val.doubleValue());
            }
        } else if ((Integer)parameters.get(PARAMETER_CENA_NABAVNA) == 3) {
            stanja = this.getStanja(rj, l, em, "prosNabCena");
            for (Artikalkalkulacija ak : k.getArtikalkalkulacijas()) {
                val = ((BigDecimal)this.findValue(stanja, ak.getId().getSfrProizvod())).doubleValue();
                ak.setNabCena(val.doubleValue());
                ak.setFakturnaCena(val.doubleValue());
            }
        }
        if ((Integer)parameters.get(PARAMETER_CENA_PRODAJNA) == 0) {
            stanja = this.getStanja(rj, l, em, "prodCena");
            for (Artikalkalkulacija ak : k.getArtikalkalkulacijas()) {
                val = PzMathUtility.roundToBigDecimal((double)((Double)this.findValue(stanja, ak.getId().getSfrProizvod())));
                ak.setProdCena((BigDecimal)val);
            }
        }
        return k;
    }

    private List<Object[]> getStanja(Radnajedinica rj, Lista l, EntityManager em, String field) {
        Query q = em.createQuery("SELECT s.id.sfrProizvod, s." + field + " FROM Stanje s WHERE s.radnajedinica=:rj AND s.id.sfrProizvod IN (SELECT al.sfrProizvod FROM Artikallista al WHERE al.id.idLista=:idLista)");
        q.setParameter("rj", (Object)rj);
        q.setParameter("idLista", (Object)l.getIdLista());
        return q.getResultList();
    }

    private Object findValue(List<Object[]> stanja, String sfrProizvod) throws TransformationException {
        Object res = null;
        for (Object[] stanje : stanja) {
            if (!stanje[0].equals(sfrProizvod)) continue;
            res = stanje[1];
            break;
        }
        if (res == null) {
            throw new TransformationException("Artikal sa sifrom [" + sfrProizvod + "] do sada nije imao ulaz, a samim tim ni zatecenu nabavnu/prodajnu cenu u izabranoj radnoj jedinici. \n Transformacija je zbog toga obustavljena.");
        }
        return res;
    }

    public Lista toLista(PzDokument dokument, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        Kalkulacija k = (Kalkulacija)dokument;
        Lista l = new DefaultDokumentTransformer(Kalkulacija.class, Artikalkalkulacija.class).toLista(dokument, parameters, em);
        if (k.getArtikalDocuments() != null && l != null && l.getArtikallistas() != null) {
            int i = 0;
            while (i < k.getArtikalkalkulacijas().size()) {
                Artikalkalkulacija ak = (Artikalkalkulacija)k.getArtikalkalkulacijas().get(i);
                Artikallista al = (Artikallista)l.getArtikallistas().get(i);
                if (ak != null && al != null && ak.getId().getSfrProizvod().equals(al.getSfrProizvod())) {
                    al.setPomCena(BDConverter.getFakturnaCena((double)ak.getFakturnaCena()));
                }
                ++i;
            }
        }
        return l;
    }

    public String getName() {
        return "Transformator kalkulacije";
    }

    public String getDescription() {
        return null;
    }

    public boolean acceptsNonExistent() {
        return true;
    }

    public void handleNonExistent(PzDialog parent, List<Artikallista> nonexistent, EntityManager em) throws TransformationException {
        PzChoice[] choices = new PzChoice[]{new PzChoice("Presko\u010di sve takve", (Object)IZBOR_NEPOSTOJECI_PRESKOCI), new PzChoice("\u017delim da ih unesem kao nove artikle", (Object)IZBOR_NEPOSTOJECI_IZABERI)};
        String choice = (String)PzDialogChoice.showPzDialogChoice((PzDialog)parent, (PzChoice[])choices, (String)"Postoje artikli \u010dije \u0161ifre ne postoje u bazi. \u0160ta \u017eelite da radite sa njima?");
        if (choice == null) {
            throw this.createTransformationException();
        }
        if (choice.equals(IZBOR_NEPOSTOJECI_IZABERI)) {
            PzEntityFilter filter = new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Artikallista al = (Artikallista)entity;
                    return new Object[]{al.getSfrProizvod(), al.getNaziv(), al.getDobSifra()};
                }

                public String[] getColumnNames() {
                    return new String[]{"\u0160ifra", "Naziv", "Katal. broj"};
                }
            };
            List choosen = PzGenericTableDialog.showDialog((PzDialog)parent, Artikallista.class, nonexistent, (String)"Artikli koji se unose u \u0161ifarnik", (String)"Izaberite koje artikle \u017eelite da unesete u \u0161ifarnik kao nove", (int)0, (PzEntityFilter)filter);
            if (choosen == null || choosen.size() == 0) {
                throw this.createTransformationException();
            }
            for (Artikallista al : choosen) {
                Artikal a = new Artikal();
                a.setNaziv(al.getNaziv());
                a.setBliziOpis(al.getBliziOpis());
                a.setSfrProizvod(al.getSfrProizvod());
                a.setDobSifra(al.getDobSifra());
                a.setFi(al.getFi());
                a.setDuzina(al.getDuzina());
                a.setDobavljac((Komitent)em.find(Komitent.class, (Object)al.getSfrDobavljac()));
                a.setProizvodjac((Komitent)em.find(Komitent.class, (Object)al.getSfrProizvodjac()));
                a.setJedMere(al.getJm());
                a.setModel((Model)em.find(Model.class, (Object)al.getOznModel()));
                a.setSirina(al.getSirina());
                a.setRobnagrupa((Robnagrupa)em.find(Robnagrupa.class, (Object)al.getOznRobGr()));
                a.setStandPak(al.getStandPak());
                a.setStokMax(al.getStokMax());
                a.setStokMin(al.getStokMin());
                a.setVisina(al.getVisina());
                Artikal inserted = DodavanjeExtended.insertArtikal((PzDialog)parent, (Artikal)a);
                if (inserted != null) continue;
                throw this.createTransformationException();
            }
        }
    }

    private TransformationException createTransformationException() {
        return new TransformationException("Proces je neocekivano prekinut. Morate pokrenuti transformaciju iz pocetka.");
    }
}

