/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prostoKnjigovodstvo.engine.izvod.uplataLoader;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Uplata;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prostoKnjigovodstvo.engine.izvod.TransakcijaIzvodaBanke;
import rs.pezar.prostoKnjigovodstvo.engine.izvod.uplataLoader.UplataLoader;
import rs.pezar.prostoKnjigovodstvo.gui.izvod.uplate.PnlUplataPoRacunu;
import rs.pezar.prostoKnjigovodstvo.gui.izvod.uplate.UplataComponent;

public class ProvizijaBankeLoader
implements UplataLoader {
    @Override
    public List<Uplata> getUplate(Komitent k, TransakcijaIzvodaBanke t, BigDecimal iznos, EntityManager em) {
        ArrayList<Uplata> uplate = new ArrayList<Uplata>();
        Uplata uplata = new Uplata();
        uplata.setDatum(t.getDatumPlacanja());
        uplata.setKomitent(k);
        uplata.setIznos(iznos);
        uplata.setTip(TipDokumentConfig.get().UPLATA_PROVIZIJA_BANKE);
        uplate.add(uplata);
        return uplate;
    }

    @Override
    public void rebuildUplate(List<Uplata> uplate, String strana, BigDecimal iznos) {
    }

    @Override
    public UplataComponent getGUIComponent(Uplata u) {
        return new PnlUplataPoRacunu(u);
    }

    @Override
    public boolean primenjujeSe(Komitent k, TransakcijaIzvodaBanke t, EntityManager em) {
        return t.getStrana().equals("ZADUZENJE") && k.getTip() == 1;
    }
}

