/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prostoKnjigovodstvo.gui.knjizenje;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Izvodbanke;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.db.entity.Tekuciracun;
import rs.pezar.db.entity.Uplata;
import rs.pezar.db.entity.Vananalitike;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prostoKnjigovodstvo.engine.sifreKnjizenja.ManagerLoader;
import rs.pezar.prostoKnjigovodstvo.engine.sifreKnjizenja.manager.UplataManager;
import rs.pezar.prostoKnjigovodstvo.gui.izvod.PzDialogIzvodImport;
import rs.pezar.prostoKnjigovodstvo.gui.knjizenje.Dodavanje;
import rs.pezar.prostoKnjigovodstvo.gui.knjizenje.IzborStampe;
import rs.pezar.prostoKnjigovodstvo.gui.knjizenje.IzmenaOpisa;
import rs.pezar.prostoKnjigovodstvo.gui.knjizenje.akcije.PzDialogAkcija;
import rs.pezar.prostoKnjigovodstvo.gui.util.TableModelAkcije;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBar;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogIzradaNaloga
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private final PzPanel contentPanel = new PzPanel();
    private PzPanelHeader pnlHeader;
    private Izvodbanke izvod;
    private JSplitPane splitPane;
    private PzPanel pnlAkcije;
    private PzPanel pnlStavke;
    private JScrollPane scpAkcije;
    private JScrollPane scpStavke;
    private PzTable tblAkcije;
    private PzTable tblStavke;
    private JLabel lblSaldoO;
    private JLabel lblIzlazO;
    private JLabel lblUlazO;
    private PzPanel pnlObracunato;
    private PzDoubleField dfSaldo;
    private PzDoubleField dfIzlaz;
    private PzDoubleField dfUlaz;
    private PzPanel pnlPrijavljeno;
    private TableModelAkcije tableModelAkcije;
    private PzToolBar toolbar;
    private PzButton icnDodavanje;
    private PzButton icnIzmena;
    private PzButton icnBrisanje;
    private PzPanel pnlVrednosti;
    private JLabel lblUlaz;
    private PzDoubleField dblDuguje;
    private JLabel lblPotrazuje;
    private PzDoubleField dblPotrazuje;
    private JLabel lblSaldo;
    private PzDoubleField dblSaldo;
    private PzStatusBar statusBar;
    private JLabel jlStatusBar = new JLabel();
    private JLabel brDok = new JLabel("");
    private Tekuciracun racun;

    public static void main(String[] args) {
        try {
            PzDialogIzradaNaloga dialog = new PzDialogIzradaNaloga();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PzDialogIzradaNaloga() {
        this.initGUI();
        this.fillTableAkcija();
    }

    public PzDialogIzradaNaloga(PzDialog parent) {
        super(parent);
        this.izvod = (Izvodbanke)this.getSession().getParameter("izvod");
        this.racun = (Tekuciracun)this.getSession().getParameter("racun");
        this.initGUI();
        this.paintPanel();
        this.fillTableAkcija();
        this.tblStavke.setData(this.izvod.getOriginals(), Uplata.class);
        this.dfUlaz.setVal((Object)this.izvod.getUlaz());
        this.dfIzlaz.setVal((Object)this.izvod.getIzlaz());
        this.dfSaldo.setVal((Object)(this.izvod.getUlaz() - this.izvod.getIzlaz()));
        this.brDok.setText(String.valueOf(this.tblStavke.getRowCount()));
        this.tblStavke.calculateFields();
        try {
            PzApplication.getApplication().getSession().getSessionStorage().restore((Component)this.splitPane, String.valueOf(((Object)((Object)this)).getClass().getName()) + ".SPLITPANE.xml");
        }
        catch (IOException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                PzDialogIzradaNaloga.this.izvod.setSaldo(PzDialogIzradaNaloga.this.dfSaldo.getVal() - PzDialogIzradaNaloga.this.dblSaldo.getVal());
                try {
                    PzEntityManager.update((Object)PzDialogIzradaNaloga.this.izvod);
                }
                catch (Exception e1) {
                    PzMysqlExceptionHandler.handle((Throwable)e1);
                }
                super.windowClosing(e);
            }
        });
    }

    private void paintPanel() {
        this.contentPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.contentPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.contentPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            this.setTitle("Knji\u017eenje izvoda");
            this.setBounds(0, 0, 940, 563);
            this.getContentPane().setLayout(new BorderLayout());
            this.contentPanel.setLayout((LayoutManager)new BorderLayout());
            this.contentPanel.setBorder((Border)new EmptyBorder(8, 8, 8, 8));
            this.getContentPane().add((Component)this.contentPanel, "Center");
            this.pnlHeader = new PzPanelHeader();
            this.pnlHeader.setOpaque(false);
            this.pnlHeader.setTitle("Knji\u017eenje izvoda broj " + this.izvod.getOznDokumenta() + " (" + this.racun.getBanka() + ")");
            this.pnlHeader.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/rs/pezar/prostoKnjigovodstvo/resource/img/nzk.png")));
            this.contentPanel.add((Component)this.pnlHeader, (Object)"North");
            this.splitPane = new JSplitPane();
            this.splitPane.setOneTouchExpandable(true);
            this.splitPane.setContinuousLayout(true);
            this.contentPanel.add((Component)this.splitPane, (Object)"Center");
            this.pnlAkcije = new PzPanel();
            this.splitPane.setLeftComponent((Component)this.pnlAkcije);
            GridBagLayout gbl_pnlAkcije = new GridBagLayout();
            gbl_pnlAkcije.columnWidths = new int[2];
            gbl_pnlAkcije.rowHeights = new int[2];
            gbl_pnlAkcije.columnWeights = new double[]{1.0, Double.MIN_VALUE};
            gbl_pnlAkcije.rowWeights = new double[]{1.0, Double.MIN_VALUE};
            this.pnlAkcije.setLayout((LayoutManager)gbl_pnlAkcije);
            this.scpAkcije = new JScrollPane();
            GridBagConstraints gbc_scpAkcije = new GridBagConstraints();
            gbc_scpAkcije.fill = 1;
            gbc_scpAkcije.gridx = 0;
            gbc_scpAkcije.gridy = 0;
            this.pnlAkcije.add((Component)this.scpAkcije, (Object)gbc_scpAkcije);
            this.pnlStavke = new PzPanel();
            this.splitPane.setRightComponent((Component)this.pnlStavke);
            this.pnlStavke.setLayout((LayoutManager)new BorderLayout(0, 0));
            this.scpStavke = new JScrollPane();
            this.pnlStavke.add((Component)this.scpStavke);
            this.tblStavke = new PzTable();
            this.tblStavke.setId("TABLE_STAVKE");
            this.scpStavke.setViewportView((Component)this.tblStavke);
            this.tblStavke.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Uplata dok = (Uplata)entity;
                    BigDecimal ulaz = new BigDecimal(0.0);
                    BigDecimal izlaz = new BigDecimal(0.0);
                    String opis = "";
                    String komitent = "";
                    String poDokumentu = "";
                    if (dok.getTip().equals(TipDokumentConfig.get().UPLATA_KUPCA) || dok.getTip().equals(TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS) || dok.getTip().equals(TipDokumentConfig.get().UPLATA_PAZARA)) {
                        ulaz = dok.getIznos();
                    } else if (dok.getTip().equals(TipDokumentConfig.get().UPLATA_KUPCA_POVRACAJ) || dok.getTip().equals(TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS_POVRACAJ)) {
                        ulaz = dok.getIznos().negate();
                    }
                    if (dok.getTip().equals(TipDokumentConfig.get().UPLATA_DOBAVLJACU) || dok.getTip().equals(TipDokumentConfig.get().UPLATA_DAT_AVANS) || dok.getTip().equals(TipDokumentConfig.get().UPLATA_PDV)) {
                        izlaz = dok.getIznos();
                    } else if (dok.getTip().equals(TipDokumentConfig.get().UPLATA_DOBAVLJACU_POVRACAJ) || dok.getTip().equals(TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ)) {
                        izlaz = dok.getIznos().negate();
                    }
                    if (dok.getTip().equals(TipDokumentConfig.get().UPLATA_PDV)) {
                        opis = "Uplata PDV-a ";
                    } else if (dok.getTip().equals(TipDokumentConfig.get().UPLATA_PAZARA)) {
                        if (!dok.getPodTip().equals(TipDokumentConfig.get().PODTIP_UPLATA_PAZARA_VIRMAN)) {
                            opis = "Uplata pazara";
                        } else {
                            opis = "Uplata pazara: " + (dok.getOznDokumenta() == null ? " " : dok.getOznDokumenta()) + " od " + (dok.getKomitent() == null ? " " : dok.getKomitent().getSfrKomitent());
                            komitent = dok.getKomitent() == null ? " " : dok.getKomitent().getSfrKomitent();
                            poDokumentu = new Integer(dok.getPoDokumentu()) == null ? "" : Integer.toString(dok.getPoDokumentu());
                        }
                    } else if (dok.getTip().equals(TipDokumentConfig.get().VAN_ANALITIKE)) {
                        Vananalitike dok1 = (Vananalitike)dok;
                        ulaz = new BigDecimal(dok1.getUplata());
                        izlaz = new BigDecimal(dok1.getIsplata());
                        opis = dok1.getOznDokumenta();
                    } else {
                        opis = "Uplata: " + (dok.getOznDokumenta() == null ? " " : dok.getOznDokumenta()) + " od " + (dok.getKomitent() == null ? " " : dok.getKomitent().getSfrKomitent());
                        komitent = dok.getKomitent() == null ? " " : dok.getKomitent().getSfrKomitent();
                        poDokumentu = new Integer(dok.getPoDokumentu()) == null ? "" : Integer.toString(dok.getPoDokumentu());
                    }
                    return new Object[]{opis, dok.getDatum(), ulaz, izlaz, komitent, poDokumentu, dok.getIdDok()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Opis", "Datum", "Ulaz", "Izlaz", "\u0160ifra dobavlja\u010da", "Broj fakture", "iddok"};
                }
            });
            this.toolbar = new PzToolBar();
            this.pnlStavke.add((Component)this.toolbar, (Object)"North");
            this.icnDodavanje = new PzButton();
            this.icnDodavanje.setFocusable(false);
            this.icnDodavanje.setShortcut("insert");
            this.icnDodavanje.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogIzradaNaloga.this.actionPerformedicnDodavanje(arg0);
                }
            });
            this.icnDodavanje.setIcon((Icon)new ImageIcon(PzDialogIzradaNaloga.class.getResource("/rs/pezar/prostoKnjigovodstvo/resource/img/component_add.png")));
            this.icnDodavanje.setText("Dodavanje|(INS)");
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnIzmena = new PzButton();
            this.icnIzmena.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = -2355577127933856217L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogIzradaNaloga.this.actionPerformedicnIzmena(arg0);
                }
            });
            this.icnIzmena.setFocusable(false);
            this.icnIzmena.setShortcut("f3");
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(PzDialogIzradaNaloga.class.getResource("/rs/pezar/prostoKnjigovodstvo/resource/img/component_edit.png")));
            this.toolbar.add((Component)this.icnIzmena);
            this.icnBrisanje = new PzButton();
            this.icnBrisanje.setFocusable(false);
            this.icnBrisanje.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = -2355577127933856217L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogIzradaNaloga.this.actionPerformedicnBrisanje(arg0);
                }
            });
            this.icnBrisanje.setShortcut("delete");
            this.icnBrisanje.setText("Brisanje|(DEL)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(PzDialogIzradaNaloga.class.getResource("/rs/pezar/prostoKnjigovodstvo/resource/img/component_delete.png")));
            this.toolbar.add((Component)this.icnBrisanje);
            this.pnlVrednosti = new PzPanel();
            GridBagLayout pnlVrednostiLayout = new GridBagLayout();
            this.pnlVrednosti.setLayout((LayoutManager)pnlVrednostiLayout);
            this.pnlVrednosti.setAlignmentX(1.0f);
            this.contentPanel.add((Component)this.pnlVrednosti, (Object)"South");
            pnlVrednostiLayout.rowWeights = new double[]{0.0, 0.0};
            pnlVrednostiLayout.rowHeights = new int[]{20, 22};
            pnlVrednostiLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlVrednostiLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlVrednosti.setOpaque(false);
            this.pnlPrijavljeno = new PzPanel();
            this.pnlPrijavljeno.setOpaque(false);
            GridBagLayout pnlPrijavljenoLayout1 = new GridBagLayout();
            GridBagLayout pnlPrijavljenoLayout = new GridBagLayout();
            this.pnlVrednosti.add((Component)this.pnlPrijavljeno, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlPrijavljeno.setBorder((Border)BorderFactory.createTitledBorder("Prijavljeno"));
            pnlPrijavljenoLayout1.rowWeights = new double[]{0.0};
            pnlPrijavljenoLayout1.rowHeights = new int[]{7};
            pnlPrijavljenoLayout1.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlPrijavljenoLayout1.columnWidths = new int[]{65, 145, 65, 145, 65, 145, 7};
            this.pnlPrijavljeno.setLayout((LayoutManager)pnlPrijavljenoLayout1);
            pnlPrijavljenoLayout.rowWeights = new double[]{0.0};
            pnlPrijavljenoLayout.rowHeights = new int[]{7};
            pnlPrijavljenoLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlPrijavljenoLayout.columnWidths = new int[]{75, 130, 69, 130, 89, 131, 7};
            this.lblUlaz = new JLabel("Ulaz:");
            this.pnlPrijavljeno.add((Component)this.lblUlaz, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.lblUlaz.setFont(new Font("SansSerif", 1, 14));
            this.lblUlaz.setName("lblDuguje");
            this.dfUlaz = new PzDoubleField();
            this.pnlPrijavljeno.add((Component)this.dfUlaz, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dfUlaz.setFocusable(false);
            this.dfUlaz.setEditable(false);
            this.dfUlaz.setFont(new Font("SansSerif", 1, 16));
            this.dfUlaz.setForeground(Color.BLUE);
            this.dfUlaz.setColumns(10);
            this.lblPotrazuje = new JLabel("Izlaz:");
            this.pnlPrijavljeno.add((Component)this.lblPotrazuje, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 20, 3, 0), 0, 0));
            this.lblPotrazuje.setFont(new Font("SansSerif", 1, 14));
            this.lblPotrazuje.setName("lblPotrazuje");
            this.dfIzlaz = new PzDoubleField();
            this.pnlPrijavljeno.add((Component)this.dfIzlaz, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dfIzlaz.setFocusable(false);
            this.dfIzlaz.setEditable(false);
            this.dfIzlaz.setFont(new Font("SansSerif", 1, 16));
            this.dfIzlaz.setForeground(Color.MAGENTA);
            this.dfIzlaz.setColumns(10);
            this.lblSaldo = new JLabel("Saldo:");
            this.pnlPrijavljeno.add((Component)this.lblSaldo, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 3, 0), 0, 0));
            this.lblSaldo.setFont(new Font("SansSerif", 1, 14));
            this.dfSaldo = new PzDoubleField();
            this.pnlPrijavljeno.add((Component)this.dfSaldo, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfSaldo.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    if (arg0.getPropertyName().equals("value")) {
                        if (arg0.getNewValue().equals(new Double(0.0))) {
                            PzDialogIzradaNaloga.this.dblSaldo.setForeground(Color.GREEN);
                        } else {
                            PzDialogIzradaNaloga.this.dblSaldo.setForeground(Color.RED);
                        }
                    }
                }
            });
            this.dfSaldo.setFocusable(false);
            this.dfSaldo.setEditable(false);
            this.dfSaldo.setFont(new Font("SansSerif", 1, 16));
            this.dfSaldo.setForeground(Color.GREEN);
            this.dfSaldo.setColumns(10);
            this.pnlObracunato = new PzPanel();
            GridBagLayout pnlObracunatoLayout = new GridBagLayout();
            this.pnlVrednosti.add((Component)this.pnlObracunato, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlObracunatoLayout.rowWeights = new double[]{0.0};
            pnlObracunatoLayout.rowHeights = new int[]{11};
            pnlObracunatoLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlObracunatoLayout.columnWidths = new int[]{65, 145, 65, 145, 65, 145, 7};
            this.pnlObracunato.setLayout((LayoutManager)pnlObracunatoLayout);
            this.pnlObracunato.setBorder((Border)BorderFactory.createTitledBorder("Obra\u010dunato"));
            this.pnlObracunato.setOpaque(false);
            this.lblUlazO = new JLabel();
            this.pnlObracunato.add((Component)this.lblUlazO, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.lblUlazO.setFont(new Font("SansSerif", 1, 14));
            this.lblUlazO.setName("lblUlazO");
            this.lblIzlazO = new JLabel();
            this.pnlObracunato.add((Component)this.lblIzlazO, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 20, 3, 0), 0, 0));
            this.lblIzlazO.setFont(new Font("SansSerif", 1, 14));
            this.lblIzlazO.setName("lblIzlazO");
            this.lblSaldoO = new JLabel();
            this.pnlObracunato.add((Component)this.lblSaldoO, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 0, 0), 0, 0));
            this.lblSaldoO.setFont(new Font("SansSerif", 1, 14));
            this.lblSaldoO.setName("lblSaldoO");
            this.dblDuguje = this.tblStavke.createExpresionField("$2$");
            this.pnlObracunato.add((Component)this.dblDuguje, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dblDuguje.setFocusable(false);
            this.dblDuguje.setEditable(false);
            this.dblDuguje.setFont(new Font("SansSerif", 1, 16));
            this.dblDuguje.setForeground(Color.BLUE);
            this.dblDuguje.setColumns(10);
            this.dblPotrazuje = this.tblStavke.createExpresionField("$3$");
            this.pnlObracunato.add((Component)this.dblPotrazuje, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dblPotrazuje.setFocusable(false);
            this.dblPotrazuje.setEditable(false);
            this.dblPotrazuje.setFont(new Font("SansSerif", 1, 16));
            this.dblPotrazuje.setForeground(Color.MAGENTA);
            this.dblPotrazuje.setColumns(10);
            this.dblSaldo = this.tblStavke.createExpresionField("$2$-$3$");
            this.pnlObracunato.add((Component)this.dblSaldo, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dblSaldo.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    if (arg0.getPropertyName().equals("value")) {
                        if (arg0.getNewValue().equals(new Double(0.0))) {
                            PzDialogIzradaNaloga.this.dblSaldo.setForeground(Color.GREEN);
                        } else {
                            PzDialogIzradaNaloga.this.dblSaldo.setForeground(Color.RED);
                        }
                    }
                }
            });
            this.dblSaldo.setFocusable(false);
            this.dblSaldo.setEditable(false);
            this.dblSaldo.setFont(new Font("SansSerif", 1, 16));
            this.dblSaldo.setForeground(Color.GREEN);
            this.dblSaldo.setColumns(10);
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj stavki");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.tblStavke.calculateFields();
            this.setSize(940, 563);
            this.setMinimumSize(new Dimension(821, 643));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void fillTableAkcija() {
        try {
            this.tableModelAkcije = new TableModelAkcije(new XMLConfiguration(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prostoKnjigovodstvo/resource/akcije.xml")).getDocument());
            this.tblAkcije = new PzTable();
            this.tblAkcije.setModel((TableModel)this.tableModelAkcije);
            this.tblAkcije.setEnterAction(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PzDialogIzradaNaloga.this.tblAkcije.getSelectedRow() == -1) {
                        return;
                    }
                    try {
                        PzDialogIzradaNaloga.this.getSession().putParameter("update", (Object)Boolean.FALSE);
                        PzDialogIzradaNaloga.this.getSession().putParameter("sfr", (Object)PzDialogIzradaNaloga.this.tableModelAkcije.getSfr(PzDialogIzradaNaloga.this.tblAkcije.getSelectedRow()));
                        Class<PzDialogAkcija> c = PzDialogIzradaNaloga.this.tableModelAkcije.getActionClass(PzDialogIzradaNaloga.this.tblAkcije.getSelectedRow());
                        PzDialogIzradaNaloga.this.launchDialog(c, Boolean.FALSE, PzDialogIzradaNaloga.this.tableModelAkcije.getSfr(PzDialogIzradaNaloga.this.tblAkcije.getSelectedRow()));
                    }
                    catch (Exception e1) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogIzradaNaloga.this), (Throwable)e1);
                    }
                }
            });
            this.tblAkcije.setId("TABLE_AKCIJE");
            this.scpAkcije.setViewportView((Component)this.tblAkcije);
            if (this.tblAkcije.getRowCount() > 0) {
                this.tblAkcije.setRowSelectionInterval(0, 0);
            }
        }
        catch (ConfigurationException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void launchDialog(Class<PzDialogAkcija> c, Boolean update, int sfrKnjizenja) {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            PzDokument dokument = null;
            PzDialogAkcija dlg = c.getConstructor(PzDialog.class).newInstance(new Object[]{this});
            if (!dlg.shouldBeShown()) {
                return;
            }
            dlg.setTblStavke(this.tblStavke);
            dlg.setUpdate(update);
            if (update.booleanValue()) {
                dlg.setDokument(dokument);
            }
            dlg.setEm(em);
            dlg.setSfrKnjizenja(sfrKnjizenja);
            dlg.initData(em);
            dlg.setLocationRelativeTo((Component)((Object)this));
            dlg.setModal(true);
            dlg.restoreSize();
            dlg.setVisible(true);
            if (!dlg.isCommited()) {
                return;
            }
            PzDokument dok = dlg.getNewDokument();
            List<PzDokument> dokumenti = dlg.getNewDokuments();
            if (dok == null) {
                if (dokumenti == null) return;
                if (dokumenti.size() == 0) {
                    return;
                }
            }
            em.getTransaction().begin();
            if (dok != null) {
                dok.setArhiviran((short)1);
                dok.setProknjizen((short)1);
                dok.setOriginal((PzDokument)this.izvod);
                this.izvod.getOriginals().add((Opstidokument)dok);
                PzDokumentManager.getInstance().arhivirajDokument(dok, true, null, em);
            } else if (dokumenti != null) {
                for (PzDokument dok1 : dokumenti) {
                    dok1.setArhiviran((short)1);
                    dok1.setProknjizen((short)1);
                    dok1.setOriginal((PzDokument)this.izvod);
                    this.izvod.getOriginals().add((Opstidokument)dok1);
                    PzDokumentManager.getInstance().arhivirajDokument(dok1, true, null, em);
                }
            }
            if (dlg.getUplataManager() != null) {
                dlg.getUplataManager().doInTransaction(em);
            }
            em.getTransaction().commit();
            this.tblStavke.refreshData();
            this.tblStavke.calculateFields();
            return;
        }
        catch (Exception e1) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            this.tblStavke.rollBack();
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            return;
        }
        finally {
            if (em.isOpen()) {
                em.close();
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public PzTable getTableStavke() {
        return this.tblStavke;
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogIzradaNaloga.this.brDok.setText(String.valueOf(PzDialogIzradaNaloga.this.tblStavke.getRowCount()) + " ");
                PzDialogIzradaNaloga.this.tblStavke.refreshData();
                PzDialogIzradaNaloga.this.tblStavke.calculateFields();
            }
        });
    }

    protected void actionPerformedicnDodavanje(ActionEvent arg0) {
        this.showDialog(Dodavanje.class);
        if (this.getSession().getParameter("sfr") == null) {
            return;
        }
        Class<PzDialogAkcija> c = null;
        try {
            Integer sfrKnjizenja = (Integer)this.getSession().getParameter("sfr");
            c = this.tableModelAkcije.getClassBySfr(sfrKnjizenja);
            this.getSession().putParameter("sfr", null);
            if (c == null) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Nepostoje\u0107a \u0160ifra knji\u017eenja");
                return;
            }
            this.getSession().putParameter("update", (Object)Boolean.FALSE);
            this.launchDialog(c, Boolean.FALSE, sfrKnjizenja);
            this.refresh();
        }
        catch (ClassNotFoundException e) {
            this.getSession().putParameter("sfr", null);
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void actionPerformedicnBrisanje(ActionEvent arg0) {
        if (((Uplata)this.tblStavke.getSelectedEntity()).getDokument() == null) {
            this.tblStavke.removeSelectedEntity(true, true);
        } else {
            EntityManager emTemp = PzEntityManagerFactory.getInstance().createEm();
            try {
                if (JOptionPane.showConfirmDialog((Component)((Object)this), "Brisanjem ove stavke obrisa\u0107ete i sve ostale koje su nastale knji\u017eenjem istog dokumenta. Da li ste sigurni?", "Brisanje?", 0) != 0) {
                    return;
                }
                try {
                    Dokument dok = ((Uplata)this.tblStavke.getSelectedEntity()).getDokument();
                    emTemp.getTransaction().begin();
                    String sfr = ((Uplata)this.tblStavke.getSelectedEntity()).getSfrKnjizenja().toString();
                    UplataManager m = ManagerLoader.getManagerBySfr(sfr);
                    if (m != null) {
                        m.reverse(emTemp, (Uplata)this.tblStavke.getSelectedEntity());
                    }
                    emTemp.remove(emTemp.find(Uplata.class, (Object)dok.getIdDok()));
                    dok = this.createDokumentGreska(dok);
                    emTemp.getTransaction().commit();
                    this.tblStavke.removeGUI(this.tblStavke.getSelectedRow());
                    this.refresh();
                }
                catch (Exception e) {
                    if (emTemp.getTransaction().isActive()) {
                        emTemp.getTransaction().rollback();
                    }
                    this.tblStavke.rollBack();
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                }
            }
            finally {
                if (emTemp.isOpen()) {
                    emTemp.close();
                }
            }
        }
    }

    private Dokument createDokumentGreska(Dokument dok) {
        Dokument gdok = null;
        try {
            gdok = (Dokument)BeanUtils.cloneBean((Object)dok);
            gdok.setOpis("Greska u knjizenju. Tip: " + gdok.getTip());
            gdok.setTip(TipDokumentConfig.get().DOKUMENT_GRESKA);
            gdok.setArtikaldokuments(null);
            gdok.setOpstidokument(null);
            gdok.setDtaksas(null);
            gdok.setIznos(new BigDecimal(0));
            gdok.setRadnajedinica(null);
            gdok.setKalkulacija(null);
            gdok.setFaktura(null);
            gdok.setFakturausluga(null);
            gdok.setInterniracun(null);
            gdok.setInterniracun1(null);
            gdok.setNivelacija(null);
            gdok.setKonsignacija(null);
            gdok.setStavkanzks(null);
            gdok.setDokument(null);
            gdok.setOriginal(null);
            gdok.setUslugadokuments(null);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        return gdok;
    }

    protected void actionPerformedicnIzmena(ActionEvent arg0) {
        try {
            if (this.tblStavke.getSelectedRow() == -1) {
                return;
            }
            this.getSession().putParameter("update", (Object)Boolean.TRUE);
            this.getSession().putParameter("stavka", (Object)PzEntityManager.find(Uplata.class, (Object)((Uplata)this.tblStavke.getSelectedEntity()).getIdDok()));
            if (((Uplata)this.tblStavke.getSelectedEntity()).getDokument() != null && ((Uplata)this.tblStavke.getSelectedEntity()).getSfrKnjizenja() != null) {
                JOptionPane.showConfirmDialog((Component)((Object)this), "Ova opcija trenutno nije podr\u017eana. Morate prvo obrisati stavku pa je ponovo dodati.", "Obave\ufffdtenje", -1, 1);
                return;
            }
            this.launchDialog(this.tableModelAkcije.getClassBySfr(1), Boolean.TRUE, 1);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void icnIzmenaOpisaactionPerformed(ActionEvent arg0) {
        if (this.tblStavke.getSelectedRow() == -1) {
            return;
        }
        this.showDialog(IzmenaOpisa.class);
        String opis = (String)this.getSession().getParameter("opis");
        if (opis != null) {
            this.getSession().putParameter("opis", null);
            Stavkanzk s = (Stavkanzk)this.tblStavke.getSelectedEntity();
            s.setOpis(opis);
            this.tblStavke.updateSelectedEntity((PzEntity)s, true);
        }
    }

    protected void icnStampaactionPerformed(ActionEvent arg0) {
        if (this.tblStavke.getRowCount() == 0) {
            return;
        }
        this.getSession().putParameter("arhiva", (Object)Boolean.FALSE);
        this.showDialog(IzborStampe.class);
    }

    private void icnImportActionPerformed(ActionEvent arg0) {
        this.showDialog(PzDialogIzvodImport.class);
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        try {
            PzApplication.getApplication().getSession().getSessionStorage().save((Component)this.splitPane, String.valueOf(((Object)((Object)this)).getClass().getName()) + ".SPLITPANE.xml");
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }
}

