/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prostoKnjigovodstvo.gui.knjizenje.akcije;

import com.swtdesigner.FocusTraversalOnArray;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Uplata;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prostoKnjigovodstvo.gui.knjizenje.akcije.PzComponentFactory;
import rs.pezar.prostoKnjigovodstvo.gui.knjizenje.akcije.PzDialogAkcija;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.custom.PzTablePorez;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class DatAvans
extends PzDialogAkcija {
    private static final long serialVersionUID = 7209610856161412476L;
    private final PzPanel contentPanel = new PzPanel();
    private PzPanelHeader pnlHeader;
    private PzPanel pnlForm;
    private JLabel lblDatumKnjienja;
    private JLabel lblDatumUplate;
    private JLabel lblifraDobavljaa;
    private JLabel lblBrojAvansnogRauna;
    private JLabel lblIznosUplate;
    private JLabel lblPdv;
    private JLabel lblOsnovicaPdv;
    private PzDateField datDatumKnjizenja;
    private PzDateField datDatumUplate;
    private PzNumericOnlyTextField numSifraDobavljaca;
    private PzTextField txtOznAvansnogRacuna;
    private PzDoubleField dblIznosUplate;
    private PzDoubleField dblPDV;
    private PzDoubleField dblOsnovicaPDV;
    private PzRadioGroup<PzChoice> rgrPdv;
    private JScrollPane scp;
    private PzTablePorez tblPorez;
    private PzTextField txtNazivDobavljaca;
    private Uplata uplata;
    private Komitent komitent;
    private JLabel lblObveznik;

    public static void main(String[] args) {
        try {
            DatAvans dialog = new DatAvans();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DatAvans() {
        this.initGUI();
        this.paintPanel();
    }

    public DatAvans(PzDialog parent) {
        super(parent);
        this.initGUI();
        this.paintPanel();
        this.datDatumKnjizenja.setVal((Object)this.getDatKnjizenjaTemp());
        this.datDatumUplate.setVal((Object)this.getDatUplateTemp());
    }

    private void paintPanel() {
        this.contentPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.contentPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.contentPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setLayout((LayoutManager)new BorderLayout());
        this.contentPanel.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        buttonPane.setLayout(new FlowLayout(1));
        this.contentPanel.add((Component)buttonPane, (Object)"South");
        JButton okButton = new JButton("OK");
        okButton.setIcon(new ImageIcon(DatAvans.class.getResource("/rs/pezar/prostoKnjigovodstvo/resource/img/check.png")));
        okButton.addActionListener((ActionListener)((Object)this));
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.pnlHeader = new PzPanelHeader();
        this.pnlHeader.setOpaque(false);
        this.pnlHeader.setTitle("Knji\u017eenje uplate avansa dobavlja\u010du");
        this.contentPanel.add((Component)this.pnlHeader, (Object)"North");
        this.pnlForm = new PzPanel();
        this.pnlForm.setOpaque(false);
        this.contentPanel.add((Component)this.pnlForm, (Object)"Center");
        GridBagLayout gbl_pnlForm = new GridBagLayout();
        int[] nArray = new int[6];
        nArray[0] = 112;
        nArray[1] = 120;
        nArray[2] = 98;
        nArray[3] = 111;
        nArray[4] = 108;
        gbl_pnlForm.columnWidths = nArray;
        int[] nArray2 = new int[8];
        nArray2[4] = 31;
        nArray2[5] = 110;
        nArray2[6] = 19;
        gbl_pnlForm.rowHeights = nArray2;
        gbl_pnlForm.columnWeights = new double[]{0.0, 0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_pnlForm.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.pnlForm.setLayout((LayoutManager)gbl_pnlForm);
        this.lblDatumKnjienja = new JLabel("Datum knji\u017eenja:");
        GridBagConstraints gbc_lblDatumKnjienja = new GridBagConstraints();
        gbc_lblDatumKnjienja.anchor = 13;
        gbc_lblDatumKnjienja.insets = new Insets(0, 0, 5, 5);
        gbc_lblDatumKnjienja.gridx = 0;
        gbc_lblDatumKnjienja.gridy = 0;
        this.pnlForm.add((Component)this.lblDatumKnjienja, (Object)gbc_lblDatumKnjienja);
        this.datDatumKnjizenja = new PzDateField();
        GridBagConstraints gbc_datDatumKnjizenja = new GridBagConstraints();
        gbc_datDatumKnjizenja.insets = new Insets(0, 0, 5, 5);
        gbc_datDatumKnjizenja.fill = 2;
        gbc_datDatumKnjizenja.gridx = 1;
        gbc_datDatumKnjizenja.gridy = 0;
        this.pnlForm.add((Component)this.datDatumKnjizenja, (Object)gbc_datDatumKnjizenja);
        this.lblBrojAvansnogRauna = new JLabel("Oznaka av. ra\u010duna:");
        GridBagConstraints gbc_lblBrojAvansnogRauna = new GridBagConstraints();
        gbc_lblBrojAvansnogRauna.anchor = 13;
        gbc_lblBrojAvansnogRauna.insets = new Insets(0, 0, 5, 5);
        gbc_lblBrojAvansnogRauna.gridx = 2;
        gbc_lblBrojAvansnogRauna.gridy = 0;
        this.pnlForm.add((Component)this.lblBrojAvansnogRauna, (Object)gbc_lblBrojAvansnogRauna);
        this.txtOznAvansnogRacuna = new PzTextField();
        this.txtOznAvansnogRacuna.setVerifyInput(true);
        GridBagConstraints gbc_txtOznAvansnogRacuna = new GridBagConstraints();
        gbc_txtOznAvansnogRacuna.gridwidth = 2;
        gbc_txtOznAvansnogRacuna.insets = new Insets(0, 0, 5, 0);
        gbc_txtOznAvansnogRacuna.fill = 2;
        gbc_txtOznAvansnogRacuna.gridx = 3;
        gbc_txtOznAvansnogRacuna.gridy = 0;
        this.pnlForm.add((Component)this.txtOznAvansnogRacuna, (Object)gbc_txtOznAvansnogRacuna);
        this.lblDatumUplate = new JLabel("Datum uplate:");
        GridBagConstraints gbc_lblDatumUplate = new GridBagConstraints();
        gbc_lblDatumUplate.anchor = 13;
        gbc_lblDatumUplate.insets = new Insets(0, 0, 5, 5);
        gbc_lblDatumUplate.gridx = 0;
        gbc_lblDatumUplate.gridy = 1;
        this.pnlForm.add((Component)this.lblDatumUplate, (Object)gbc_lblDatumUplate);
        this.datDatumUplate = new PzDateField();
        GridBagConstraints gbc_datDatumUplate = new GridBagConstraints();
        gbc_datDatumUplate.insets = new Insets(0, 0, 5, 5);
        gbc_datDatumUplate.fill = 2;
        gbc_datDatumUplate.gridx = 1;
        gbc_datDatumUplate.gridy = 1;
        this.pnlForm.add((Component)this.datDatumUplate, (Object)gbc_datDatumUplate);
        this.lblIznosUplate = new JLabel("Iznos uplate:");
        GridBagConstraints gbc_lblIznosUplate = new GridBagConstraints();
        gbc_lblIznosUplate.anchor = 13;
        gbc_lblIznosUplate.insets = new Insets(0, 0, 5, 5);
        gbc_lblIznosUplate.gridx = 2;
        gbc_lblIznosUplate.gridy = 1;
        this.pnlForm.add((Component)this.lblIznosUplate, (Object)gbc_lblIznosUplate);
        this.dblIznosUplate = new PzDoubleField();
        this.dblIznosUplate.setVerifyInput(true);
        GridBagConstraints gbc_dblIznosUplate = new GridBagConstraints();
        gbc_dblIznosUplate.insets = new Insets(0, 0, 5, 5);
        gbc_dblIznosUplate.fill = 2;
        gbc_dblIznosUplate.gridx = 3;
        gbc_dblIznosUplate.gridy = 1;
        this.pnlForm.add((Component)this.dblIznosUplate, (Object)gbc_dblIznosUplate);
        this.lblifraDobavljaa = new JLabel("\u0160ifra dobavlja\u010da");
        GridBagConstraints gbc_lblifraDobavljaa = new GridBagConstraints();
        gbc_lblifraDobavljaa.anchor = 13;
        gbc_lblifraDobavljaa.insets = new Insets(0, 0, 5, 5);
        gbc_lblifraDobavljaa.gridx = 0;
        gbc_lblifraDobavljaa.gridy = 2;
        this.pnlForm.add((Component)this.lblifraDobavljaa, (Object)gbc_lblifraDobavljaa);
        this.numSifraDobavljaca = PzComponentFactory.createKomitentField();
        GridBagConstraints gbc_numSifraDobavljaca = new GridBagConstraints();
        gbc_numSifraDobavljaca.insets = new Insets(0, 0, 5, 5);
        gbc_numSifraDobavljaca.fill = 2;
        gbc_numSifraDobavljaca.gridx = 1;
        gbc_numSifraDobavljaca.gridy = 2;
        this.pnlForm.add((Component)this.numSifraDobavljaca, (Object)gbc_numSifraDobavljaca);
        this.rgrPdv = PzComponentFactory.createRadioGroup();
        this.rgrPdv.addRadioGroupListener(new PzRadioGroupListener(){

            public void selectionChanged(PzRadioGroupEvent evt) {
                DatAvans.this.selectionChangedrgrPdv(evt);
            }
        });
        this.txtNazivDobavljaca = new PzTextField();
        this.txtNazivDobavljaca.setEditable(false);
        this.txtNazivDobavljaca.setFocusable(false);
        GridBagConstraints gbc_txtNazivDobavljaca = new GridBagConstraints();
        gbc_txtNazivDobavljaca.gridwidth = 3;
        gbc_txtNazivDobavljaca.insets = new Insets(0, 0, 5, 0);
        gbc_txtNazivDobavljaca.fill = 2;
        gbc_txtNazivDobavljaca.gridx = 2;
        gbc_txtNazivDobavljaca.gridy = 2;
        this.pnlForm.add((Component)this.txtNazivDobavljaca, (Object)gbc_txtNazivDobavljaca);
        this.lblObveznik = new JLabel("Komitent nije PDV obveznik");
        this.lblObveznik.setVisible(false);
        this.lblObveznik.setForeground(Color.BLUE);
        GridBagConstraints gbc_lblObveznik = new GridBagConstraints();
        gbc_lblObveznik.gridwidth = 2;
        gbc_lblObveznik.insets = new Insets(0, 0, 5, 5);
        gbc_lblObveznik.gridx = 0;
        gbc_lblObveznik.gridy = 3;
        this.pnlForm.add((Component)this.lblObveznik, (Object)gbc_lblObveznik);
        this.scp = new JScrollPane();
        GridBagConstraints gbc_scp = new GridBagConstraints();
        gbc_scp.insets = new Insets(0, 0, 5, 0);
        gbc_scp.gridwidth = 3;
        gbc_scp.fill = 1;
        gbc_scp.gridx = 2;
        gbc_scp.gridy = 5;
        this.pnlForm.add((Component)this.scp, (Object)gbc_scp);
        this.tblPorez = PzComponentFactory.createPzTablePorez();
        this.scp.setViewportView((Component)this.tblPorez);
        this.lblPdv = new JLabel("PDV:");
        GridBagConstraints gbc_lblPdv = new GridBagConstraints();
        gbc_lblPdv.anchor = 13;
        gbc_lblPdv.insets = new Insets(0, 0, 5, 5);
        gbc_lblPdv.gridx = 2;
        gbc_lblPdv.gridy = 3;
        this.pnlForm.add((Component)this.lblPdv, (Object)gbc_lblPdv);
        this.dblPDV = this.tblPorez.createExpresionField("$3$");
        this.dblPDV.setBackground(new Color(173, 216, 230));
        this.dblPDV.setFocusable(false);
        this.dblPDV.setEditable(false);
        GridBagConstraints gbc_dblPDV = new GridBagConstraints();
        gbc_dblPDV.insets = new Insets(0, 0, 5, 5);
        gbc_dblPDV.fill = 2;
        gbc_dblPDV.gridx = 3;
        gbc_dblPDV.gridy = 3;
        this.pnlForm.add((Component)this.dblPDV, (Object)gbc_dblPDV);
        this.lblOsnovicaPdv = new JLabel("Osnovica + PDV:");
        GridBagConstraints gbc_lblOsnovicaPdv = new GridBagConstraints();
        gbc_lblOsnovicaPdv.insets = new Insets(0, 0, 5, 5);
        gbc_lblOsnovicaPdv.anchor = 13;
        gbc_lblOsnovicaPdv.gridx = 2;
        gbc_lblOsnovicaPdv.gridy = 4;
        this.pnlForm.add((Component)this.lblOsnovicaPdv, (Object)gbc_lblOsnovicaPdv);
        this.dblOsnovicaPDV = this.tblPorez.createExpresionField("$2$+$3$");
        this.dblOsnovicaPDV.setBackground(new Color(173, 216, 230));
        this.dblOsnovicaPDV.setFocusable(false);
        this.dblOsnovicaPDV.setEditable(false);
        GridBagConstraints gbc_dblOsnovicaPDV = new GridBagConstraints();
        gbc_dblOsnovicaPDV.insets = new Insets(0, 0, 5, 5);
        gbc_dblOsnovicaPDV.fill = 2;
        gbc_dblOsnovicaPDV.gridx = 3;
        gbc_dblOsnovicaPDV.gridy = 4;
        this.pnlForm.add((Component)this.dblOsnovicaPDV, (Object)gbc_dblOsnovicaPDV);
        this.rgrPdv.setBorder((Border)new TitledBorder(null, "PDV", 4, 2, null, null));
        GridBagConstraints gbc_rgrPdv = new GridBagConstraints();
        gbc_rgrPdv.gridwidth = 2;
        gbc_rgrPdv.insets = new Insets(0, 0, 5, 5);
        gbc_rgrPdv.fill = 1;
        gbc_rgrPdv.gridx = 0;
        gbc_rgrPdv.gridy = 5;
        this.pnlForm.add(this.rgrPdv, (Object)gbc_rgrPdv);
        this.pnlForm.setFocusTraversalPolicyProvider(true);
        this.pnlForm.setFocusTraversalPolicy((FocusTraversalPolicy)new FocusTraversalOnArray(new Component[]{this.datDatumKnjizenja, this.datDatumUplate, this.numSifraDobavljaca, this.txtOznAvansnogRacuna, this.dblIznosUplate, this.rgrPdv.getSelectedButton(), this.tblPorez}));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.pnlForm.validateForm(true)) {
            return;
        }
        this.commit();
    }

    protected void selectionChangedrgrPdv(PzRadioGroupEvent evt) {
        if (evt.getStateChange() == 1) {
            if (!((PzChoice)evt.getValue()).getValue().equals("SA_PRAVOM")) {
                this.tblPorez.setVisible(false);
            } else {
                this.tblPorez.setVisible(true);
            }
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            this.numSifraDobavljaca.setVal((Object)((Komitent)entity).getSfrKomitent());
            this.txtNazivDobavljaca.setVal((Object)((Komitent)entity).getNaziv());
            if (this.komitent.getObveznikPDV() == 0) {
                this.tblPorez.setVisible(false);
                this.rgrPdv.setVisible(false);
                this.lblObveznik.setVisible(true);
            } else {
                this.tblPorez.setVisible(true);
                this.rgrPdv.setVisible(true);
                this.lblObveznik.setVisible(false);
            }
        }
    }

    @Override
    public Date getDatKnjizenja() {
        return this.datDatumKnjizenja.getVal();
    }

    @Override
    public PzDokument getNewDokument() throws Exception {
        this.uplata = new Uplata();
        this.uplata.setDatum(this.datDatumUplate.getVal());
        this.uplata.setIznos(this.dblIznosUplate.getBigDecimal());
        this.uplata.setOznDokumenta(this.txtOznAvansnogRacuna.getVal());
        this.uplata.setKomitent(this.komitent);
        this.uplata.setSfrKnjizenja(Integer.valueOf(this.getSfrKnjizenja()));
        if (this.uplata.getKomitent().getObveznikPDV() == 0) {
            this.uplata.setPorez("NIJE_OBVEZNIK");
        } else {
            this.uplata.setPorez((String)((PzChoice)this.rgrPdv.getSelectedValue()).getValue());
        }
        this.uplata.setTaksadokuments(this.tblPorez.getPorezi());
        this.uplata.setTip(TipDokumentConfig.get().UPLATA_DAT_AVANS);
        return this.uplata;
    }

    @Override
    public void commit() {
        this.setDatKnjizenjaTemp(this.datDatumKnjizenja.getVal());
        this.setDatUplateTemp(this.datDatumUplate.getVal());
        if (!this.dblIznosUplate.getVal().equals(this.dblOsnovicaPDV.getVal()) && this.komitent.getObveznikPDV() == 1 && ((PzChoice)this.rgrPdv.getSelectedValue()).getValue().equals("SA_PRAVOM")) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Iznos uplate se ne sla\u017ee sa zbirom osnovice i PDV-a. Ne mo\u017eete nastaviti dalje.");
        } else {
            super.commit();
        }
    }
}

