/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server;

import java.io.IOException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;

public class ServerLog
extends AbstractSessionLog {
    public void log(SessionLogEntry entry) {
        if (!this.shouldLog(entry.getLevel())) {
            return;
        }
        String message = this.getSupplementDetailString(entry);
        if (entry.hasException()) {
            if (entry.getLevel() == 7) {
                message = message + Helper.printStackTraceToString(entry.getException());
            } else if (entry.getLevel() <= 6) {
                message = this.shouldLogExceptionStackTrace() ? message + Helper.printStackTraceToString(entry.getException()) : message + entry.getException();
            }
        } else {
            message = message + this.formatMessage(entry);
        }
        this.basicLog(entry.getLevel(), message);
    }

    protected void basicLog(int level, String message) {
        try {
            this.printPrefixString(level);
            this.getWriter().write(message);
            this.getWriter().write(Helper.cr());
            this.getWriter().flush();
        }
        catch (IOException exception) {
            throw ValidationException.logIOError(exception);
        }
    }
}

