/*
 * Decompiled with CFR 0.152.
 */
package org.cheffo.jeplite.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.cheffo.jeplite.ASTConstant;
import org.cheffo.jeplite.ASTFunNode;
import org.cheffo.jeplite.ASTVarNode;
import org.cheffo.jeplite.ParseException;
import org.cheffo.jeplite.ParserVisitor;
import org.cheffo.jeplite.SimpleNode;
import org.cheffo.jeplite.function.PostfixMathCommand;
import org.cheffo.jeplite.util.DoubleStack;

public class ExpressionOptimizer
implements ParserVisitor {
    SimpleNode node;
    final HashMap constTab = new HashMap();

    public ExpressionOptimizer(SimpleNode node) {
        this.node = node;
    }

    public void addConst(String constName) {
        this.constTab.put(constName, constName);
    }

    public void removeConst(String constName) {
        this.constTab.remove(constName);
    }

    public void clearConstants() {
        this.constTab.clear();
    }

    public SimpleNode optimize() {
        return (SimpleNode)this.node.jjtAccept(this, null);
    }

    @Override
    public Object visit(ASTFunNode node, Object data) {
        SimpleNode res = node;
        try {
            boolean allConstNode = true;
            int numChildren = node.jjtGetNumChildren();
            SimpleNode[] nodes = new SimpleNode[numChildren];
            int i = 0;
            while (i < numChildren) {
                nodes[i] = (SimpleNode)node.jjtGetChild(i).jjtAccept(this, data);
                allConstNode &= nodes[i] instanceof ASTConstant;
                ++i;
            }
            if (res.getName().equals("+") || res.getName().equals("*")) {
                res = (ASTFunNode)this.visitAdditive(node, data);
            }
            if (allConstNode) {
                ASTConstant constRes = new ASTConstant(-1);
                constRes.jjtSetParent(node.jjtGetParent());
                constRes.setValue(node.getValue());
                res = constRes;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return res;
    }

    private Object visitAdditive(ASTFunNode node, Object data) {
        ArrayList<SimpleNode> nodes = new ArrayList<SimpleNode>();
        int numChildren = node.jjtGetNumChildren();
        String nodeName = node.getName();
        boolean toOptimize = false;
        int i = 0;
        while (i < numChildren) {
            SimpleNode curChild = node.jjtGetChild(i);
            String curChildName = curChild.getName();
            if (curChildName != null && curChildName.equals(nodeName)) {
                toOptimize = true;
                int grandChildrenNum = curChild.jjtGetNumChildren();
                int j = 0;
                while (j < grandChildrenNum) {
                    nodes.add(curChild.jjtGetChild(j));
                    ++j;
                }
            } else {
                nodes.add(curChild);
            }
            ++i;
        }
        ASTFunNode res = node;
        if (toOptimize) {
            res = new ASTFunNode(2);
            res.setName(node.getName());
            res.jjtSetParent(node.jjtGetParent());
            int pos = nodes.size() - 1;
            Iterator i2 = nodes.iterator();
            while (i2.hasNext()) {
                node.jjtAddChild((SimpleNode)i2.next(), pos--);
            }
            if (nodeName.equals("+")) {
                res.setFunction("+", new Madd(nodes.size()));
            } else {
                res.setFunction("*", new Mmul(nodes.size()));
            }
        }
        return res;
    }

    @Override
    public Object visit(ASTVarNode node, Object data) {
        boolean isConst = this.constTab.get(node.getName()) != null;
        SimpleNode res = node;
        if (isConst) {
            try {
                ASTConstant res1 = new ASTConstant(4);
                res1.setValue(((SimpleNode)res).getValue());
                res1.jjtSetParent(res.jjtGetParent());
                res = res1;
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
        }
        return res;
    }

    @Override
    public Object visit(ASTConstant node, Object data) {
        return node;
    }

    @Override
    public Object visit(SimpleNode node, Object data) {
        return node;
    }

    static class Madd
    extends PostfixMathCommand {
        Madd(int numberOfParameters) {
            this.numberOfParameters = numberOfParameters;
        }

        @Override
        public double operation(double[] params) {
            return 0.0;
        }

        public void run(DoubleStack stack) {
            double res = 0.0;
            int i = 0;
            while (i < this.numberOfParameters) {
                res += stack.pop();
                ++i;
            }
            stack.push(res);
        }
    }

    static class Mmul
    extends PostfixMathCommand {
        Mmul(int numberOfParameters) {
            this.numberOfParameters = numberOfParameters;
        }

        @Override
        public double operation(double[] params) {
            return 0.0;
        }

        public void run(DoubleStack stack) {
            double res = 1.0;
            int i = 0;
            while (i < this.numberOfParameters) {
                res *= stack.pop();
                ++i;
            }
            stack.push(res);
        }
    }
}

