/*
 * Decompiled with CFR 0.152.
 */
package org.cheffo.jeplite.test;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Date;
import java.util.HashMap;
import org.cheffo.jeplite.JEP;
import org.cheffo.jeplite.SimpleNode;
import org.cheffo.jeplite.optimizer.ExpressionOptimizer;
import org.cheffo.jeplite.util.DoubleStack;

public class Tests {
    static JEP jep = new JEP();
    static HashMap params = new HashMap();

    static void parseParams(String[] args) {
        int i = 0;
        while (i < args.length) {
            params.put(args[i].toLowerCase().trim(), args[i + 1]);
            i += 2;
        }
    }

    static void doIt(String toParse, BufferedWriter fw, SimpleNode optNode) throws Exception {
        long[] testArray = new long[10];
        new DoubleStack();
        int j = 0;
        while (j < 10) {
            Thread.yield();
            long start = System.currentTimeMillis();
            int i = 0;
            while (i < 100000) {
                optNode.getValue();
                ++i;
            }
            testArray[j] = System.currentTimeMillis() - start;
            ++j;
        }
        fw.write("100000 evaluations: ");
        j = 0;
        while (j < 10) {
            fw.write(String.valueOf(testArray[j]) + ", ");
            ++j;
        }
        fw.write("\n");
    }

    public static void main(String[] args) throws Exception {
        Date startTime = new Date();
        Tests.parseParams(args);
        File inFile = new File((String)params.get("-file"));
        File logFile = new File((String)params.get("-logfile"));
        BufferedReader fr = new BufferedReader(new FileReader(inFile));
        BufferedWriter fw = new BufferedWriter(new FileWriter(logFile));
        jep.addStandardConstants();
        jep.addStandardFunctions();
        String curLine = null;
        while ((curLine = fr.readLine()) != null) {
            if (curLine.startsWith("#")) continue;
            String toParse = fr.readLine();
            double result = Double.parseDouble(fr.readLine().trim());
            fw.write("Processing:" + toParse + ",\n");
            fw.write("Expected: " + result + "\n");
            fw.flush();
            double d = 0.0;
            DoubleStack stack = new DoubleStack();
            int i = 0;
            while (i < 1000) {
                jep.parseExpression(toParse);
                d = jep.getValue(stack);
                ++i;
            }
            SimpleNode optNode = jep.getTopNode();
            fw.write("Not Optimized: ");
            Tests.doIt(toParse, fw, optNode);
            ExpressionOptimizer optimizer = new ExpressionOptimizer(jep.getTopNode());
            optNode = optimizer.optimize();
            fw.write("Optimized    : ");
            Tests.doIt(toParse, fw, optNode);
            long[] testArray = new long[10];
            int j = 0;
            while (j < 10) {
                Thread.yield();
                long start = System.currentTimeMillis();
                int i2 = 0;
                while (i2 < 1000) {
                    jep.parseExpression(toParse);
                    ++i2;
                }
                testArray[j] = System.currentTimeMillis() - start;
                ++j;
            }
            fw.write("1000 parses: ");
            j = 0;
            while (j < 10) {
                fw.write(String.valueOf(testArray[j]) + ", ");
                ++j;
            }
            fw.write("\n");
            fw.write(String.valueOf(d) + "\n_____________________________________________________\n");
            fw.flush();
        }
        Date endTime = new Date();
        fw.write("Start time: " + startTime + "\n");
        fw.write("End time: " + endTime + "\n");
        fw.write("Total time: " + (endTime.getTime() - startTime.getTime()) + " ms");
        fw.close();
    }
}

