/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.liste.gui.izrada;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.Application;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Lista;
import rs.pezar.liste.DBManager;
import rs.pezar.liste.ListaUtil;
import rs.pezar.liste.RManager;
import rs.pezar.liste.gui.PzDialogIzradaListe;
import rs.pezar.liste.gui.narudzbenice.IzradaNarudzbenice;
import rs.pezar.liste.tipovi.TipListe;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzTextAreaPanel;

public class Arhiviranje
extends PzDialog {
    private static final String SORT_SIFRA = "sifra";
    private static final String SORT_NAZIV = "naziv";
    private static final long serialVersionUID = -7729453730018886360L;
    private final PzPanel contentPanel = new PzPanel();
    private PzPanelHeader pzPanelHeader;
    private PzPanel pnlChoice;
    private JLabel lbltampajuSePolja;
    private JComboBox cbIzvestaj;
    private Lista lista;
    private JLabel lblTipZaglavlja;
    private PzDateField dfDatum;
    private PzTextAreaPanel tfOpis;
    private PzComboBox cbSort;
    private JLabel lblSort;
    private JLabel lblOpis;
    private JLabel lblDatum;
    private JComboBox cbZaglavlje;
    private Boolean arhiva;
    private PzPanel buttonPane;
    private String title;
    private String headerTitle;
    private Boolean izradaNarudzbenice;
    private Boolean poruka;

    public static void main(String[] args) {
        try {
            Arhiviranje dialog = new Arhiviranje();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Arhiviranje() {
        this.initGUI();
    }

    public Arhiviranje(PzDialog parent) {
        super(parent);
        this.lista = (Lista)this.getSession().getParameter("lista");
        this.arhiva = (Boolean)this.getSession().getParameter("arhiva");
        this.izradaNarudzbenice = (Boolean)this.getSession().getParameter("izrada");
        this.poruka = (Boolean)this.getSession().getParameter("poruka");
        if (this.poruka == null) {
            this.poruka = Boolean.TRUE;
        }
        if (this.izradaNarudzbenice == null) {
            this.izradaNarudzbenice = Boolean.FALSE;
        }
        if (this.arhiva == null) {
            this.arhiva = Boolean.FALSE;
        }
        if (this.arhiva.booleanValue()) {
            if (this.lista.getTip().equals(ListaUtil.getTipListe("STANDARDNA"))) {
                this.title = "Lista iz arhive";
                this.headerTitle = "\u0160tampanje liste iz arhive";
            } else if (this.lista.getTip().equals(ListaUtil.getTipListe("NARUDZBENICA"))) {
                this.title = "Narud\u017ebenica iz arhive";
                this.headerTitle = "\u0160tampanje narud\u017ebenice iz arhive";
            } else if (this.lista.getTip().equals(ListaUtil.getTipListe("PONUDA"))) {
                this.title = "Ponuda iz arhive";
                this.headerTitle = "\u0160tampanje ponude iz arhive";
            }
        } else if (this.lista.getTip().equals(ListaUtil.getTipListe("STANDARDNA"))) {
            this.title = "Arhiviranje liste";
            this.headerTitle = "Izbor na\u010dina \u0161tampanja liste";
        } else if (this.lista.getTip().equals(ListaUtil.getTipListe("NARUDZBENICA"))) {
            this.title = "Arhiviranje narud\u017ebenice";
            this.headerTitle = "Izbor na\u010dina \u0161tampanja narud\u017ebenice";
        } else if (this.lista.getTip().equals(ListaUtil.getTipListe("PONUDA"))) {
            this.title = "Arhiviranje ponude";
            this.headerTitle = "Izbor na\u010dina \u0161tampanja ponude";
        }
        this.initGUI();
        this.fillForm(this.lista);
    }

    private void fillForm(Lista lista) {
        try {
            TipListe.IzvestajDescriptor.IzvestajHeader[] headers;
            TipListe tip = RManager.getInstance().getTipListe(lista.getTip());
            TipListe.IzvestajDescriptor[] izvestajDescriptorArray = tip.getIzvestaji();
            int n = izvestajDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                TipListe.IzvestajDescriptor izvestaj = izvestajDescriptorArray[n2];
                this.cbIzvestaj.addItem(izvestaj);
                ++n2;
            }
            TipListe.IzvestajDescriptor.IzvestajHeader[] izvestajHeaderArray = headers = tip.getIzvestaji()[0].getHeaders();
            int n3 = headers.length;
            n = 0;
            while (n < n3) {
                TipListe.IzvestajDescriptor.IzvestajHeader header = izvestajHeaderArray[n];
                this.cbZaglavlje.addItem(header);
                ++n;
            }
            this.tfOpis.setVal((Object)(this.poruka != false ? lista.getKomentar() : ""));
            String parameter = PzParameter.getParameterValue((String)"SORT_NARUDZBENICE", (String)SORT_SIFRA);
            int i = 0;
            while (i < this.cbSort.getItemCount()) {
                PzChoice choice = (PzChoice)this.cbSort.getItemAt(i);
                if (choice.getValue().equals(parameter)) {
                    this.cbSort.setSelectedItem((Object)choice);
                }
                ++i;
            }
            int rbr = PzParameter.getInteger((String)"LISTA_REPORT_SELECTED", (Integer)0);
            this.cbIzvestaj.setSelectedIndex(rbr);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void initGUI() {
        this.setTitle(this.title);
        this.setSize(709, 387);
        this.contentPanel.setPaintGradient(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        BorderLayout contentPanelLayout = new BorderLayout();
        this.contentPanel.setLayout((LayoutManager)contentPanelLayout);
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.buttonPane = new PzPanel();
        this.buttonPane.setLayout((LayoutManager)new FlowLayout(1));
        this.contentPanel.add((Component)this.buttonPane, (Object)"South");
        JButton okButton = new JButton(this.arhiva != false ? "\u0160tampaj" : "Arhiviraj");
        okButton.setIcon(new ImageIcon(Arhiviranje.class.getResource("/rs/pezar/liste/resource/img/check.png")));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Arhiviranje.this.okButtonactionPerformed(arg0);
            }
        });
        okButton.setActionCommand("OK");
        this.buttonPane.add((Component)okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.pzPanelHeader = new PzPanelHeader();
        this.pzPanelHeader.setIcon(new ImageIcon(Arhiviranje.class.getResource("/rs/pezar/liste/resource/img/printer_preferences.png")));
        this.pzPanelHeader.setText(this.headerTitle);
        this.pzPanelHeader.setTitle(this.title);
        this.contentPanel.add((Component)this.pzPanelHeader, (Object)"North");
        this.pzPanelHeader.setOpaque(false);
        this.pnlChoice = new PzPanel();
        GridBagLayout gbl_pnlChoice = new GridBagLayout();
        this.pnlChoice.setBorder((Border)new EmptyBorder(10, 10, 10, 10));
        this.contentPanel.add((Component)this.pnlChoice, (Object)"Center");
        int[] nArray = new int[4];
        nArray[0] = 102;
        nArray[1] = 274;
        nArray[2] = 384;
        gbl_pnlChoice.columnWidths = nArray;
        gbl_pnlChoice.rowHeights = new int[]{8, 29, 29, 29, 25, 25, 20};
        gbl_pnlChoice.columnWeights = new double[]{0.0, 0.0, 0.1, Double.MIN_VALUE};
        gbl_pnlChoice.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
        this.pnlChoice.setLayout((LayoutManager)gbl_pnlChoice);
        this.contentPanel.add((Component)this.buttonPane, (Object)"South");
        this.pnlChoice.setOpaque(false);
        this.lbltampajuSePolja = new JLabel("\u0160tampaju se polja:");
        GridBagConstraints gbc_lbltampajuSePolja = new GridBagConstraints();
        gbc_lbltampajuSePolja.fill = 3;
        gbc_lbltampajuSePolja.anchor = 17;
        gbc_lbltampajuSePolja.insets = new Insets(0, 0, 5, 5);
        gbc_lbltampajuSePolja.gridx = 0;
        gbc_lbltampajuSePolja.gridy = 1;
        this.pnlChoice.add((Component)this.lbltampajuSePolja, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.cbIzvestaj = new JComboBox();
        this.cbIzvestaj.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                Arhiviranje.this.cbIzvestajitemStateChanged(arg0);
            }
        });
        GridBagConstraints gbc_cbIzvestaj = new GridBagConstraints();
        gbc_cbIzvestaj.gridwidth = 2;
        gbc_cbIzvestaj.insets = new Insets(0, 0, 5, 0);
        gbc_cbIzvestaj.fill = 1;
        gbc_cbIzvestaj.gridx = 1;
        gbc_cbIzvestaj.gridy = 1;
        this.pnlChoice.add((Component)this.cbIzvestaj, (Object)gbc_cbIzvestaj);
        this.lblTipZaglavlja = new JLabel("Tip zaglavlja:");
        GridBagConstraints gbc_lblTipZaglavlja = new GridBagConstraints();
        gbc_lblTipZaglavlja.fill = 3;
        gbc_lblTipZaglavlja.anchor = 13;
        gbc_lblTipZaglavlja.insets = new Insets(0, 0, 5, 5);
        gbc_lblTipZaglavlja.gridx = 0;
        gbc_lblTipZaglavlja.gridy = 2;
        this.pnlChoice.add((Component)this.lblTipZaglavlja, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.cbZaglavlje = new JComboBox();
        GridBagConstraints gbc_cbZaglavlje = new GridBagConstraints();
        gbc_cbZaglavlje.insets = new Insets(0, 0, 5, 5);
        gbc_cbZaglavlje.fill = 1;
        gbc_cbZaglavlje.gridx = 1;
        gbc_cbZaglavlje.gridy = 2;
        this.pnlChoice.add((Component)this.cbZaglavlje, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.lblDatum = new JLabel();
        this.pnlChoice.add((Component)this.lblDatum, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.lblDatum.setText("Datum");
        this.dfDatum = new PzDateField();
        this.pnlChoice.add((Component)this.dfDatum, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 150), 0, 0));
        this.lblOpis = new JLabel();
        this.pnlChoice.add((Component)this.lblOpis, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.lblOpis.setText("Opis");
        this.tfOpis = new PzTextAreaPanel();
        this.pnlChoice.add((Component)this.tfOpis, (Object)new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.lblSort = new JLabel();
        this.pnlChoice.add((Component)this.lblSort, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.lblSort.setName("lblSort");
        this.cbSort = new PzComboBox();
        this.pnlChoice.add((Component)this.cbSort, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.cbSort.addItem((Object)new PzChoice("Sortiranje po \u0161ifri", (Object)SORT_SIFRA));
        this.cbSort.addItem((Object)new PzChoice("Sortiranje po nazivu", (Object)SORT_NAZIV));
        Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
    }

    protected void okButtonactionPerformed(ActionEvent arg0) {
        PzWorkerDialog.showStatus((String)"Generisanje izve\u0161taja je u toku. Ova operacija mo\u017ee da potraje u zavisnosti od du\u017eine listi. Molim, sa\u010dekajte.", (PzDialog)this);
        if (this.arhiva == null || !this.arhiva.booleanValue()) {
            try {
                PzParameter.setParameter((String)"SORT_NARUDZBENICE", (String)this.cbSort.getSelectedChoice().getValue().toString());
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
            DBManager.arhivirajListe(this.lista, this.tfOpis.getVal().toString(), this.dfDatum.getVal(), this);
        } else {
            this.showReports();
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    protected void cbIzvestajitemStateChanged(ItemEvent arg0) {
        if (arg0.getStateChange() == 1) {
            TipListe.IzvestajDescriptor desc = (TipListe.IzvestajDescriptor)this.cbIzvestaj.getSelectedItem();
            TipListe.IzvestajDescriptor.IzvestajHeader[] izvestajHeaderArray = desc.getHeaders();
            int n = izvestajHeaderArray.length;
            int n2 = 0;
            while (n2 < n) {
                TipListe.IzvestajDescriptor.IzvestajHeader header = izvestajHeaderArray[n2];
                this.cbZaglavlje.removeAllItems();
                this.cbZaglavlje.addItem(header);
                ++n2;
            }
        }
    }

    public void showReports() {
        try {
            Vector<Lista> liste = new Vector<Lista>();
            liste.add(this.lista);
            RManager.showReports(liste, ((TipListe.IzvestajDescriptor)this.cbIzvestaj.getSelectedItem()).getIzvestaj(), ((TipListe.IzvestajDescriptor.IzvestajHeader)this.cbZaglavlje.getSelectedItem()).getReport().toString(), this);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void finished() {
        if (this.arhiva == null || !this.arhiva.booleanValue()) {
            if (this.izradaNarudzbenice.booleanValue()) {
                ((IzradaNarudzbenice)this.getParentDialog()).finish();
            } else {
                ((PzDialogIzradaListe)this.getParentDialog()).finish();
            }
        }
        this.dispose();
    }
}

