/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.putGetEngine;

import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import rs.pezar.kasa.putGetEngine.FileTool;

public class DataGetter {
    public static String INFO_ERROR = ".ERR";
    public static String INFO_NOPAPER = "NOPAPER.ERR";
    public static String INFO_COMM_ERROR = "COMM.ERR";
    public static String INFO_OK = ".OK";
    private static final Vector<String> fileExtensions = new Vector();

    static {
        fileExtensions.add(".OK");
        fileExtensions.add(".ERR");
        fileExtensions.add(".XML");
        fileExtensions.add(".ok");
        fileExtensions.add(".err");
        fileExtensions.add(".xml");
    }

    public static HashMap<String, String> dataGet(String outFolder, Integer sequence) {
        HashMap<String, String> returnInfo = new HashMap<String, String>();
        Vector<String> files = FileTool.getFileNamesInDirectory(outFolder, fileExtensions);
        int i = 0;
        while (i < files.size()) {
            String fileName = files.get(i);
            if (fileName.equalsIgnoreCase(INFO_NOPAPER)) {
                returnInfo.put(INFO_NOPAPER, "<" + sequence.toString() + ">Kraj papira, proverite rolne!</" + sequence.toString() + ">");
            } else if (fileName.equalsIgnoreCase("COMM.ERR")) {
                returnInfo.put(INFO_COMM_ERROR, "<" + sequence.toString() + ">Greska u komunikaciji, proverite kablove ili pozovite servisera.<" + sequence.toString() + ">");
            } else if (fileName.endsWith(INFO_OK.toLowerCase()) || fileName.endsWith(INFO_OK)) {
                try {
                    returnInfo.put(INFO_OK, "<" + sequence.toString() + "><" + fileName + "> :" + FileTool.readFile(String.valueOf(outFolder) + "\\" + fileName) + "</" + sequence.toString() + ">");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (fileName.endsWith(INFO_ERROR.toLowerCase()) || fileName.endsWith(INFO_ERROR)) {
                try {
                    returnInfo.put(INFO_ERROR, "<" + sequence.toString() + ">Greska sa " + fileName + " :" + FileTool.readFile(String.valueOf(outFolder) + "\\" + fileName) + "</" + sequence.toString() + ">");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        if (returnInfo.size() != 0) {
            FileTool.deleteAllFilesFromDirectory(outFolder, fileExtensions);
        }
        return returnInfo;
    }

    public static Vector<String> getFileextensions() {
        return fileExtensions;
    }
}

