/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.putGetEngine;

import java.io.IOException;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import rs.pezar.core.PzApplication;
import rs.pezar.kasa.putGetEngine.DataGetter;
import rs.pezar.kasa.putGetEngine.DataPutter;
import rs.pezar.kasa.putGetEngine.FileTool;

public class PutGetEngine {
    private static final String SUBFOLDER = "metalink";
    private static final Integer WAIT_FOR_RESPONSE = 17000;
    private static final Integer RETRY_TIME = WAIT_FOR_RESPONSE / 10;
    private String workingFolder = PzApplication.getApplication().getDataFolder().getPath();
    private String inFolder;
    private String outFolder;
    private DataPutter dataPutter;
    private Integer sequence;
    private Timer timer;
    private TimerTask t;
    private boolean timeOver = false;
    private Integer timeCounter = 0;

    public PutGetEngine(HashMap<String, String> params) {
        this.outFolder = params.get("PARAM1");
        this.inFolder = params.get("PARAM2");
        this.dataPutter = new DataPutter();
        this.sequence = 1;
    }

    public void put(String data, String type) throws IOException {
        this.dataPutter.put(this.workingFolder, SUBFOLDER, this.inFolder, this.sequence, data, type);
    }

    public HashMap<String, String> get() {
        DataGetter.dataGet(this.outFolder, this.sequence);
        return null;
    }

    private TimerTask getTimerTask() {
        TimerTask t = new TimerTask(){

            @Override
            public void run() {
                PutGetEngine putGetEngine = PutGetEngine.this;
                putGetEngine.timeCounter = putGetEngine.timeCounter + RETRY_TIME;
                if (PutGetEngine.this.timeCounter >= WAIT_FOR_RESPONSE) {
                    PutGetEngine.this.timeOver = true;
                }
            }
        };
        return t;
    }

    public synchronized HashMap<String, String> putGet(String data, String type) throws Exception {
        this.timeOver = false;
        this.timeCounter = 0;
        if (!FileTool.deleteAllFilesFromDirectory(this.outFolder, DataGetter.getFileextensions())) {
            throw new Exception("Fajlovi iz izlaznog foldera Metalinka ne mogu biti obrisani.");
        }
        if (!FileTool.deleteAllFilesFromDirectory(this.inFolder, DataGetter.getFileextensions())) {
            throw new Exception("Fajlovi iz ulaznog foldera programa posrednika ne mogu biti obrisani.");
        }
        try {
            this.put(data, type);
        }
        catch (IOException iOException) {
            throw new Exception("H|Nije moguce snimiti fajl u metalink ulazni direktorijum, da li ste dobro podesili?");
        }
        this.timer = new Timer();
        this.t = this.getTimerTask();
        this.timer.schedule(this.t, 0L, (long)RETRY_TIME.intValue());
        while (true) {
            HashMap<String, String> result = DataGetter.dataGet(this.outFolder, this.sequence);
            this.sequence = this.sequence + 1;
            if (result.size() > 0 || this.timeOver) {
                this.timer.cancel();
                FileTool.deleteAllFilesFromDirectory(this.inFolder, DataGetter.getFileextensions());
                FileTool.deleteAllFilesFromDirectory(this.outFolder, DataGetter.getFileextensions());
                return result;
            }
            Thread.sleep(RETRY_TIME.intValue());
        }
    }
}

