/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa;

import java.util.HashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import rs.pezar.kasa.FP550Driver;
import rs.pezar.kasa.gui.frames.CommonsPanel;
import rs.pezar.msg.device.cashregister.data.CashRegisterBill;
import rs.pezar.msg.device.cashregister.data.CashRegisterControl;
import rs.pezar.msg.device.interfaces.DeviceDataInterface;
import rs.pezar.msg.device.interfaces.DeviceDriverInterface;

public class PzDeviceDriver
implements DeviceDriverInterface {
    public static final Byte RESOURCE_ICON_0 = 0;
    public static final Byte RESOURCE_ICON_1 = 1;
    public static final Byte RESOURCE_ICON_2 = 2;
    public static final Byte RESOURCE_ICON_3 = 3;
    public static final Byte RESOURCE_ICON_4 = 4;
    public static final Byte RESOURCE_ICON_5 = 5;
    public static final Byte RESOURCE_ICON_6 = 6;
    public static final Byte RESOURCE_ICON_0S = 10;
    public static final Byte RESOURCE_ICON_1S = 11;
    public static final Byte RESOURCE_ICON_2S = 12;
    public static final Byte RESOURCE_ICON_3S = 13;
    public static final Byte RESOURCE_ICON_4S = 14;
    public static final Byte RESOURCE_ICON_5S = 15;
    public static final Byte RESOURCE_ICON_6S = 16;
    FP550Driver driver;

    public PzDeviceDriver() {
        this.driver = new FP550Driver();
    }

    public PzDeviceDriver(FP550Driver driver) {
        this.driver = driver;
    }

    public String getDeviceId() {
        return this.driver.getDeviceId();
    }

    public String getFabricatingNr() {
        return this.driver.getFabricatingNr();
    }

    public String getDeviceInfo() {
        return this.driver.getDeviceInfo();
    }

    public String getDeviceName() {
        return "FP550 Fiskalni printer";
    }

    public String getDeviceType() {
        return "TYPE_CASHREGISTER";
    }

    public String getDriverVersion() {
        return "2.2 - 1.5SR";
    }

    public byte getLastErrorCode() {
        return 0;
    }

    public String getLastErrorText() {
        return "Nije implementirano";
    }

    public void run() {
    }

    public HashMap<String, String> runDeviceWithData(DeviceDataInterface data) {
        HashMap<String, String> result = null;
        if (data.getData() instanceof CashRegisterBill) {
            result = this.driver.runWithTheBill(data);
        }
        if (data.getData() instanceof CashRegisterControl) {
            result = this.driver.runWithTheControl(data);
        }
        return result;
    }

    public boolean initDriver(HashMap<String, String> params) {
        return this.driver.initDriver(params);
    }

    public void runDriver() throws Exception {
        this.driver.runDriver();
        this.driver.Beep();
        Vector<String> infos = this.driver.getInfos();
        int i = 0;
        while (i < infos.size()) {
            if (infos.get(i).contains("code=0x0001")) {
                throw new Exception("Ovaj printer (Galeb FP550) ne mo\u017ee da funkcioni\u0161e ukoliko nema povezan display! Pove\u017eite display!");
            }
            infos.get(i).contains("code=0x0002");
            ++i;
        }
    }

    public void stopDriver() {
        this.driver.stopDriver();
    }

    public String testDriver() throws Exception {
        return this.driver.testDriver();
    }

    public HashMap<String, String> getParams() {
        return this.driver.getParams();
    }

    public JPanel getConfPanel() {
        if (this.driver != null) {
            return new CommonsPanel((DeviceDriverInterface)this);
        }
        return null;
    }

    public void setWorkingDirectoryPath(String path) {
        this.driver.setDatabasePath(path);
    }

    public Object getResource(Byte resourceId) {
        if (resourceId == RESOURCE_ICON_0) {
            return new ImageIcon(PzDeviceDriver.class.getResource("/rs/pezar/kasa/resource/fp550icons/galebpf550_128.png"));
        }
        if (resourceId == RESOURCE_ICON_1) {
            return new ImageIcon(PzDeviceDriver.class.getResource("/rs/pezar/kasa/resource/fp550icons/galebpf550_96.png"));
        }
        if (resourceId == RESOURCE_ICON_2) {
            return new ImageIcon(PzDeviceDriver.class.getResource("/rs/pezar/kasa/resource/fp550icons/galebpf550_64.png"));
        }
        if (resourceId == RESOURCE_ICON_3) {
            return new ImageIcon(PzDeviceDriver.class.getResource("/rs/pezar/kasa/resource/fp550icons/galebpf550_48.png"));
        }
        if (resourceId == RESOURCE_ICON_4) {
            return new ImageIcon(PzDeviceDriver.class.getResource("/rs/pezar/kasa/resource/fp550icons/galebpf550_32.png"));
        }
        if (resourceId == RESOURCE_ICON_5) {
            return new ImageIcon(PzDeviceDriver.class.getResource("/rs/pezar/kasa/resource/fp550icons/galebpf550_24.png"));
        }
        if (resourceId == RESOURCE_ICON_6) {
            return new ImageIcon(PzDeviceDriver.class.getResource("/rs/pezar/kasa/resource/fp550icons/galebpf550_16.png"));
        }
        if (resourceId == RESOURCE_ICON_0S) {
            return new ImageIcon(PzDeviceDriver.class.getResource("/rs/pezar/kasa/resource/fp550icons/galebpf550_128S.png"));
        }
        if (resourceId == RESOURCE_ICON_1S) {
            return new ImageIcon(PzDeviceDriver.class.getResource("/rs/pezar/kasa/resource/fp550icons/galebpf550_96S.png"));
        }
        if (resourceId == RESOURCE_ICON_2S) {
            return new ImageIcon(PzDeviceDriver.class.getResource("/rs/pezar/kasa/resource/fp550icons/galebpf550_64S.png"));
        }
        if (resourceId == RESOURCE_ICON_3S) {
            return new ImageIcon(PzDeviceDriver.class.getResource("/rs/pezar/kasa/resource/fp550icons/galebpf550_48S.png"));
        }
        if (resourceId == RESOURCE_ICON_4S) {
            return new ImageIcon(PzDeviceDriver.class.getResource("/rs/pezar/kasa/resource/fp550icons/galebpf550_32S.png"));
        }
        if (resourceId == RESOURCE_ICON_5S) {
            return new ImageIcon(PzDeviceDriver.class.getResource("/rs/pezar/kasa/resource/fp550icons/galebpf550_24S.png"));
        }
        if (resourceId == RESOURCE_ICON_6S) {
            return new ImageIcon(PzDeviceDriver.class.getResource("/rs/pezar/kasa/resource/fp550icons/galebpf550_16S.png"));
        }
        return null;
    }
}

