/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.service.msg.chat;

import java.util.Vector;
import rs.pezar.msg.chat.interfaces.TextMessageReceiverInterface;
import rs.pezar.msg.msg.MsgProtocol;
import rs.pezar.service.msg.chat.PopupWindow;
import rs.pezar.service.msg.chat.QueueWindow;
import rs.pezar.service.msg.chat.TopicWindow;

public class DefaultTextMessageReceiver
implements TextMessageReceiverInterface {
    MsgProtocol messageProtocol;
    Vector<TopicWindow> topicWindows;
    Vector<QueueWindow> queueWindows;
    PopupWindow popupWindow;

    public DefaultTextMessageReceiver(MsgProtocol msgProtocol) {
        this.messageProtocol = msgProtocol;
        this.topicWindows = new Vector();
        this.queueWindows = new Vector();
    }

    public void setAvailableUsers(Vector<String> users, String fromDestination) {
    }

    public void setNewMessageReceived(String type, String fromUser, String destinationName, String text) {
        if (type.equals("TEXT")) {
            if (destinationName.startsWith("topic.")) {
                this.topicMessageReceived(fromUser, destinationName, text);
            }
            if (destinationName.startsWith("queue.")) {
                this.queueMessageReceived(fromUser, text);
            }
        } else if (type.equals("TEXT_POPUP")) {
            if (this.popupWindow == null) {
                this.popupWindow = new PopupWindow();
            }
            this.popupWindow.popup(text);
        }
    }

    public void createNewMessageWindow(String fromUser) {
        boolean found = false;
        int i = 0;
        while (i < this.queueWindows.size()) {
            QueueWindow w = this.queueWindows.get(i);
            String t = w.getWriteToUser();
            w.getLocalUser();
            if (t.equals(fromUser)) {
                w.setVisible(true);
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            QueueWindow q = new QueueWindow(this.messageProtocol, fromUser);
            this.addQueueWindow(q);
            q.setVisible(true);
        }
    }

    public void addTopicWindow(TopicWindow topicWindow) {
        this.topicWindows.add(topicWindow);
    }

    public void addQueueWindow(QueueWindow queueWindow) {
        this.queueWindows.add(queueWindow);
    }

    public void removeTopicWindow(TopicWindow topicWindow) {
        this.topicWindows.remove(topicWindow);
    }

    public void removeQueueWindow(QueueWindow queueWindow) {
        this.queueWindows.remove(queueWindow);
    }

    public int numberOfTopics() {
        return this.topicWindows.size();
    }

    public int numberOfQueues() {
        return this.queueWindows.size();
    }

    private void topicMessageReceived(String fromUser, String destinationName, String text) {
        if (!this.topicWindows.isEmpty()) {
            int i = 0;
            while (i < this.topicWindows.size()) {
                TopicWindow w = this.topicWindows.get(i);
                String t = w.getTopicName();
                if (t.equals(destinationName)) {
                    w.onNewMessage(fromUser, text, false);
                }
                ++i;
            }
        }
    }

    private void queueMessageReceived(String fromUser, String text) {
        boolean found = false;
        int i = 0;
        while (i < this.queueWindows.size()) {
            QueueWindow w = this.queueWindows.get(i);
            String t = w.getWriteToUser();
            String l = w.getLocalUser();
            if (t.equals(fromUser) || l.equals(fromUser)) {
                w.onNewMessage(fromUser, text, false);
                w.setVisible(true);
                found = true;
            }
            ++i;
        }
        if (!found) {
            QueueWindow q = new QueueWindow(this.messageProtocol, fromUser);
            this.addQueueWindow(q);
            q.onNewMessage(fromUser, text, true);
        }
    }

    public Vector<TopicWindow> getTopicWindows() {
        return this.topicWindows;
    }

    public Vector<QueueWindow> getQueueWindows() {
        return this.queueWindows;
    }
}

