/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.service.msg.chat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import listeners.RefreshListener;
import rs.pezar.msg.chat.interfaces.TopicWindowInterface;
import rs.pezar.msg.msg.MsgProtocol;
import rs.pezar.msg.msg.interfaces.RefreshListenerInterface;
import rs.pezar.service.msg.chat.DefaultTextMessageReceiver;
import rs.pezar.swing.PzPanel;

public class TopicWindow
extends JFrame
implements TopicWindowInterface,
ActionListener {
    private JList listUsers;
    private JTextField textWrite;
    private JTextArea textChat;
    private MsgProtocol msgProt;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private PzPanel btnpanel;
    private PzPanel pnlUsers;
    private PzPanel chatPanel;
    private JButton btnRefresh;
    private String topicName;
    boolean visible = false;
    private KeyListener l = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10 && !TopicWindow.this.textWrite.getText().equals("")) {
                TopicWindow.this.sendNewMessage(TopicWindow.this.msgProt.getUser(), TopicWindow.this.textWrite.getText());
                TopicWindow.this.textWrite.setText("");
            }
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }
    };
    private RefreshListener listener;
    private DefaultListModel listUsersModel;

    public TopicWindow(MsgProtocol msgProtocol, String chatTopicName) {
        this.msgProt = msgProtocol;
        this.topicName = chatTopicName;
        this.listener = new RefreshListener((TopicWindowInterface)this);
        msgProtocol.getControl().addRefreshUsersListener((RefreshListenerInterface)this.listener);
        this.initGUI();
    }

    public void sendNewMessage(String user, String text) {
        try {
            this.msgProt.sendChatTextMessageToTopic(this.topicName, text);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onNewMessage(String fromUser, String message, boolean popup) {
        this.visible = false;
        this.pnlUsers.setVisible(this.visible);
        this.textChat.append(String.valueOf(fromUser) + " : " + message + "\n");
        this.textChat.scrollRectToVisible(new Rectangle(1, 1, 1, this.textChat.getHeight() - 1));
        if (popup) {
            this.setExtendedState(0);
        }
    }

    public void setOnlineUsers() {
        Vector temp = new Vector();
        try {
            temp = this.msgProt.getControl().getUsersByDestination(this.topicName);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.listUsersModel.clear();
        int i = 0;
        while (i < temp.size()) {
            this.listUsersModel.add(i, temp.get(i));
            ++i;
        }
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void refresh() throws InterruptedException {
        try {
            this.msgProt.sendDiscoverMessage(this.topicName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initGUI() {
        try {
            this.textWrite = new JTextField();
            this.getContentPane().add((Component)this.textWrite, "Center");
            this.textWrite.setFocusable(true);
            this.textWrite.setBounds(0, 440, 598, 59);
            this.textWrite.setBorder(BorderFactory.createTitledBorder("Upi\u0161i poruku:"));
            this.textWrite.requestFocusInWindow();
            this.textWrite.addKeyListener(this.l);
            this.pnlUsers = new PzPanel();
            this.getContentPane().add((Component)this.pnlUsers);
            BorderLayout pnlUsersLayout = new BorderLayout();
            this.pnlUsers.setLayout((LayoutManager)pnlUsersLayout);
            this.pnlUsers.setBounds(483, 169, 224, 259);
            this.pnlUsers.setBorder((Border)BorderFactory.createTitledBorder("Online korisnici"));
            this.pnlUsers.setBackground(new Color(255, 255, 255));
            this.jScrollPane2 = new JScrollPane();
            this.pnlUsers.add((Component)this.jScrollPane2, (Object)"Center");
            this.jScrollPane2.setPreferredSize(new Dimension(198, 203));
            this.jScrollPane2.getVerticalScrollBar().setAutoscrolls(true);
            this.jScrollPane2.getVerticalScrollBar().setValueIsAdjusting(true);
            this.chatPanel = new PzPanel();
            BorderLayout chatPanelLayout = new BorderLayout();
            this.chatPanel.setLayout((LayoutManager)chatPanelLayout);
            this.getContentPane().add((Component)this.chatPanel);
            this.chatPanel.setBounds(0, 0, 708, 433);
            this.listUsersModel = new DefaultListModel();
            this.listUsers = new JList();
            this.jScrollPane2.setViewportView(this.listUsers);
            this.listUsers.setModel(this.listUsersModel);
            this.listUsers.setPreferredSize(new Dimension(188, 213));
            this.listUsers.setSize(51, 50);
            this.listUsers.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && !TopicWindow.this.msgProt.getUser().equals(TopicWindow.this.listUsers.getModel().getElementAt(TopicWindow.this.listUsers.getSelectedIndex()).toString())) {
                        ((DefaultTextMessageReceiver)TopicWindow.this.msgProt.getMessageReceiver()).createNewMessageWindow(TopicWindow.this.listUsers.getModel().getElementAt(TopicWindow.this.listUsers.getSelectedIndex()).toString());
                    }
                }
            });
            this.jScrollPane1 = new JScrollPane();
            this.chatPanel.add((Component)this.jScrollPane1, (Object)"Center");
            this.jScrollPane1.setPreferredSize(new Dimension(397, 255));
            this.jScrollPane1.setDebugGraphicsOptions(4);
            this.jScrollPane1.setVerticalScrollBarPolicy(22);
            this.textChat = new JTextArea();
            this.jScrollPane1.setViewportView(this.textChat);
            this.textChat.setEditable(false);
            this.textChat.setPreferredSize(new Dimension(684, 415));
            this.btnpanel = new PzPanel();
            this.getContentPane().add((Component)this.btnpanel);
            this.btnpanel.setBounds(598, 440, 109, 59);
            this.btnpanel.setLayout(null);
            this.btnpanel.setBackground(new Color(255, 255, 255));
            this.btnRefresh = new JButton();
            this.btnpanel.add((Component)this.btnRefresh);
            this.btnRefresh.setText("Korisnici");
            this.btnRefresh.addActionListener(this);
            this.btnRefresh.setActionCommand("osvezi");
            this.btnRefresh.setBounds(12, 17, 78, 26);
            this.setTitle(this.topicName);
            this.setDefaultCloseOperation(2);
            this.getContentPane().setLayout(null);
            this.setPreferredSize(new Dimension(719, 535));
            this.textWrite.requestFocus();
            this.pnlUsers.setVisible(false);
            this.pack();
            this.setSize(719, 535);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals("osvezi")) {
            try {
                this.refresh();
                this.visible = !this.visible;
                this.pnlUsers.setVisible(this.visible);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else if (arg0.getActionCommand().equals("posalji") && !this.textWrite.getText().equals("")) {
            this.sendNewMessage(this.msgProt.getUser(), this.textWrite.getText());
            this.textWrite.setText("");
        }
    }
}

