/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.service.msg.chat.textComponent.hyperlink;

import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import org.apache.commons.lang.StringUtils;
import rs.pezar.service.msg.chat.textComponent.hyperlink.HyperlinkText;

public class HyperlinkTextWorker {
    Vector<HyperlinkText> hyperLinks;

    public void addHyperlinkedText(StyledDocument doc, String hyperlinkedText, SimpleAttributeSet hyperAttributeSet, AttributeSet textAttributeSet) {
        String hl = this.parseAndReplaceHyperlinks(hyperlinkedText);
        try {
            doc.insertString(doc.getLength(), hl, textAttributeSet);
            doc.setCharacterAttributes(doc.getLength() - hl.length(), hl.length(), textAttributeSet, false);
            if (this.hyperLinks != null && this.hyperLinks.size() > 0) {
                int i = 0;
                while (i < this.hyperLinks.size()) {
                    HyperlinkText hlText = this.hyperLinks.get(i);
                    this.addHyperlinkParams(hyperAttributeSet, hlText);
                    Integer begin = doc.getLength() - hl.length() + hlText.getPosition();
                    doc.setCharacterAttributes(begin, hlText.getText().length(), hyperAttributeSet, true);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String parseAndReplaceHyperlinks(String hyperlinkedText) {
        String hlText = hyperlinkedText;
        String[] splitHyperlinks = StringUtils.substringsBetween((String)hyperlinkedText, (String)"<pzhylink>", (String)"</pzhylink>");
        if (splitHyperlinks != null) {
            int i = 0;
            while (i < splitHyperlinks.length) {
                if (this.hyperLinks == null) {
                    this.hyperLinks = new Vector();
                }
                HyperlinkText hltnew = HyperlinkText.decodeHyperLink(splitHyperlinks[i]);
                Integer begin = hlText.indexOf("<pzhylink>" + splitHyperlinks[i] + "</pzhylink>");
                hltnew.setPosition(begin);
                hltnew.setLength(hltnew.getText().length());
                this.hyperLinks.add(hltnew);
                hlText = hlText.replaceFirst("<pzhylink>" + splitHyperlinks[i] + "</pzhylink>", this.hyperLinks.get(i).getText());
                ++i;
            }
        }
        return hlText;
    }

    private void addHyperlinkParams(SimpleAttributeSet hyperAttributeSet, HyperlinkText hlText) {
        hyperAttributeSet.addAttribute("P1", hlText.getParam1());
        hyperAttributeSet.addAttribute("TEXT", hlText.getText());
        hyperAttributeSet.addAttribute("P2", hlText.getParam2());
        hyperAttributeSet.addAttribute("TYPE", hlText.getType());
        hyperAttributeSet.addAttribute("P3", hlText.getParam3());
    }
}

