/*
 * Decompiled with CFR 0.152.
 */
package org.redmine.ta;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.castor.core.util.Base64Encoder;
import org.redmine.ta.AuthenticationException;
import org.redmine.ta.NotFoundException;
import org.redmine.ta.RedmineException;
import org.redmine.ta.beans.Identifiable;
import org.redmine.ta.beans.Issue;
import org.redmine.ta.beans.IssueRelation;
import org.redmine.ta.beans.Project;
import org.redmine.ta.beans.SavedQuery;
import org.redmine.ta.beans.TimeEntry;
import org.redmine.ta.beans.User;
import org.redmine.ta.internal.HttpUtil;
import org.redmine.ta.internal.RedmineXMLGenerator;
import org.redmine.ta.internal.RedmineXMLParser;

public class RedmineManager {
    private static final boolean PRINT_DEBUG = false;
    private static final String CONTENT_TYPE = "text/xml; charset=utf-8";
    private static final String CHARSET = "UTF-8";
    private static final int DEFAULT_OBJECTS_PER_PAGE = 25;
    private String host;
    private String apiAccessKey;
    private String login;
    private String password;
    private boolean useBasicAuth = false;
    private int objectsPerPage = 25;
    private MODE currentMode = MODE.REDMINE_1_1_OR_CHILIPROJECT_1_2;
    private static final Map<Class, String> urls = new HashMap<Class, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(User.class, "users");
            this.put(Issue.class, "issues");
            this.put(Project.class, "projects");
            this.put(TimeEntry.class, "time_entries");
            this.put(SavedQuery.class, "queries");
        }
    };
    private static final String URL_POSTFIX = ".xml";

    public RedmineManager(String uri) {
        if (uri == null || uri.isEmpty()) {
            throw new IllegalArgumentException("The host parameter is NULL or empty");
        }
        this.host = uri;
    }

    public RedmineManager(String host, String apiAccessKey) {
        this(host);
        this.apiAccessKey = apiAccessKey;
    }

    public RedmineManager(String uri, String login, String password) {
        this(uri);
        this.login = login;
        this.password = password;
        this.useBasicAuth = true;
    }

    public Issue createIssue(String projectKey, Issue issue) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        URI uri = this.createURI("issues.xml");
        HttpPost http = new HttpPost(uri);
        String xmlBody = RedmineXMLGenerator.toXML(projectKey, issue);
        this.setEntity((HttpEntityEnclosingRequest)http, xmlBody);
        Response response = this.sendRequest((HttpRequest)http);
        if (response.getCode() == 404) {
            throw new NotFoundException("Project with key '" + projectKey + "' is not found.");
        }
        Issue newIssue = RedmineXMLParser.parseIssueFromXML(response.getBody());
        return newIssue;
    }

    private URI createURI(String query) {
        return this.createURI(query, new ArrayList<NameValuePair>());
    }

    private URI createURI(String query, NameValuePair ... param) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        NameValuePair[] nameValuePairArray = param;
        int n = param.length;
        int n2 = 0;
        while (n2 < n) {
            NameValuePair p = nameValuePairArray[n2];
            list.add(p);
            ++n2;
        }
        return this.createURI(query, list);
    }

    private URI createURI(String query, List<NameValuePair> params) {
        URI uri;
        if (!this.useBasicAuth) {
            params.add((NameValuePair)new BasicNameValuePair("key", this.apiAccessKey));
        }
        try {
            URL url = new URL(this.host);
            String path = url.getPath();
            if (!query.isEmpty()) {
                path = String.valueOf(path) + "/" + query;
            }
            uri = URIUtils.createURI((String)url.getProtocol(), (String)url.getHost(), (int)url.getPort(), (String)path, (String)URLEncodedUtils.format(params, (String)CHARSET), null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return uri;
    }

    public void updateIssue(Issue issue) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        URI uri = this.createURI("issues/" + issue.getId() + URL_POSTFIX);
        HttpPut httpRequest = new HttpPut(uri);
        String NO_PROJECT_KEY = null;
        String xmlBody = RedmineXMLGenerator.toXML(NO_PROJECT_KEY, issue);
        this.setEntity((HttpEntityEnclosingRequest)httpRequest, xmlBody);
        Response response = this.sendRequest((HttpRequest)httpRequest);
        if (response.getCode() == 404) {
            throw new NotFoundException("Issue with id=" + issue.getId() + " is not found.");
        }
    }

    private void setEntity(HttpEntityEnclosingRequest request, String xmlBody) throws UnsupportedEncodingException {
        StringEntity entity = new StringEntity(xmlBody, CHARSET);
        entity.setContentType(CONTENT_TYPE);
        request.setEntity((HttpEntity)entity);
    }

    private void configureProxy(DefaultHttpClient httpclient) {
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyHost != null && proxyPort != null) {
            int port = Integer.parseInt(proxyPort);
            HttpHost proxy = new HttpHost(proxyHost, port);
            httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            String proxyUser = System.getProperty("http.proxyUser");
            if (proxyUser != null) {
                String proxyPassword = System.getProperty("http.proxyPassword");
                httpclient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, port), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
            }
        }
    }

    private Response sendRequest(HttpRequest request) throws IOException, AuthenticationException, RedmineException {
        RedmineManager.debug(request.getRequestLine().toString());
        DefaultHttpClient httpclient = HttpUtil.getNewHttpClient();
        this.configureProxy(httpclient);
        if (this.useBasicAuth) {
            String credentials = String.valueOf(Base64Encoder.encode((byte[])(String.valueOf(this.login) + ':' + this.password).getBytes(CHARSET)));
            request.addHeader("Authorization", "Basic: " + credentials);
        }
        request.addHeader("Accept-Encoding", "gzip,deflate");
        HttpResponse httpResponse = httpclient.execute((HttpUriRequest)request);
        int responseCode = httpResponse.getStatusLine().getStatusCode();
        if (responseCode == 401) {
            throw new AuthenticationException("Authorization error. Please check if you provided a valid API access key or Login and Password and REST API service is enabled on the server.");
        }
        if (responseCode == 403) {
            throw new AuthenticationException("Forbidden. Please check the user has proper permissions.");
        }
        HttpEntity responseEntity = httpResponse.getEntity();
        String responseBody = EntityUtils.toString((HttpEntity)responseEntity);
        if (responseCode == 422) {
            List<String> errors = RedmineXMLParser.parseErrors(responseBody);
            throw new RedmineException(errors);
        }
        Response r = new Response(responseCode, responseBody);
        httpclient.getConnectionManager().shutdown();
        return r;
    }

    public List<Project> getProjects() throws IOException, AuthenticationException, RedmineException {
        HashSet<NameValuePair> params = new HashSet<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("include", "trackers"));
        try {
            return this.getObjectsList(Project.class, params);
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException("NotFoundException received, which should never happen in this request");
        }
    }

    public List<Issue> getIssuesBySummary(String projectKey, String summaryField) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        HashSet<NameValuePair> params = new HashSet<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("subject", summaryField));
        if (projectKey != null && projectKey.length() > 0) {
            params.add((NameValuePair)new BasicNameValuePair("project_id", projectKey));
        }
        return this.getObjectsList(Issue.class, params);
    }

    public List<Issue> getIssues(Map<String, String> pParameters) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        HashSet<NameValuePair> params = new HashSet<NameValuePair>();
        for (Map.Entry<String, String> param : pParameters.entrySet()) {
            params.add((NameValuePair)new BasicNameValuePair(param.getKey(), param.getValue()));
        }
        return this.getObjectsList(Issue.class, params);
    }

    public Issue getIssueById(Integer id, INCLUDE ... include) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        String value = RedmineManager.join(",", include);
        return this.getObject(Issue.class, id, new NameValuePair[]{new BasicNameValuePair("include", value)});
    }

    private static String join(String delimToUse, INCLUDE ... include) {
        String delim = "";
        StringBuilder sb = new StringBuilder();
        INCLUDE[] iNCLUDEArray = include;
        int n = include.length;
        int n2 = 0;
        while (n2 < n) {
            INCLUDE i = iNCLUDEArray[n2];
            sb.append(delim).append((Object)i);
            delim = delimToUse;
            ++n2;
        }
        return sb.toString();
    }

    public Project getProjectByKey(String projectKey) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        URI uri = this.createURI("projects/" + projectKey + URL_POSTFIX, new NameValuePair[]{new BasicNameValuePair("include", "trackers")});
        HttpGet http = new HttpGet(uri);
        Response response = this.sendRequest((HttpRequest)http);
        if (response.getCode() == 404) {
            throw new NotFoundException("Project with key '" + projectKey + "' is not found.");
        }
        return RedmineXMLParser.parseProjectFromXML(response.getBody());
    }

    public void deleteProject(String projectKey) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        this.deleteObject(Project.class, projectKey);
    }

    public void deleteIssue(Integer id) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        this.deleteObject(Issue.class, Integer.toString(id));
    }

    public List<Issue> getIssues(String projectKey, Integer queryId, INCLUDE ... include) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        HashSet<NameValuePair> params = new HashSet<NameValuePair>();
        if (queryId != null) {
            params.add((NameValuePair)new BasicNameValuePair("query_id", String.valueOf(queryId)));
        }
        if (projectKey != null && projectKey.length() > 0) {
            params.add((NameValuePair)new BasicNameValuePair("project_id", projectKey));
        }
        String includeStr = RedmineManager.join(",", include);
        params.add((NameValuePair)new BasicNameValuePair("include", includeStr));
        List<Issue> issues = this.getObjectsList(Issue.class, params);
        return issues;
    }

    private void addPagingParameters(Set<NameValuePair> params) {
        params.add((NameValuePair)new BasicNameValuePair("per_page", String.valueOf(this.objectsPerPage)));
    }

    private <T> List<T> getObjectsListV104(Class<T> objectClass, Set<NameValuePair> params) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        ArrayList<T> objects = new ArrayList<T>();
        int pageNum = 1;
        String firstPage = null;
        this.addPagingParameters(params);
        while (true) {
            ArrayList<NameValuePair> paramsList = new ArrayList<NameValuePair>(params);
            paramsList.add((NameValuePair)new BasicNameValuePair("page", String.valueOf(pageNum)));
            String query = String.valueOf(urls.get(objectClass)) + URL_POSTFIX;
            URI uri = this.createURI(query, paramsList);
            HttpGet http = new HttpGet(uri);
            Response response = this.sendRequest((HttpRequest)http);
            if (response.getCode() == 404) {
                throw new NotFoundException("Server returned '404 not found'. response body:" + response.getBody());
            }
            String body = response.getBody();
            if (pageNum == 1) {
                firstPage = body;
            } else if (firstPage.equals(body)) break;
            List<T> foundItems = RedmineXMLParser.parseObjectsFromXML(objectClass, body);
            if (foundItems.size() == 0) break;
            objects.addAll(foundItems);
            ++pageNum;
        }
        return objects;
    }

    private <T> List<T> getObjectsList(Class<T> objectClass, Set<NameValuePair> params) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        if (this.currentMode.equals((Object)MODE.REDMINE_1_1_OR_CHILIPROJECT_1_2)) {
            return this.getObjectsListV11(objectClass, params);
        }
        if (this.currentMode.equals((Object)MODE.REDMINE_1_0)) {
            return this.getObjectsListV104(objectClass, params);
        }
        throw new RuntimeException("unsupported mode:" + (Object)((Object)this.currentMode) + ". supported modes are: " + (Object)((Object)MODE.REDMINE_1_0) + " and " + (Object)((Object)MODE.REDMINE_1_1_OR_CHILIPROJECT_1_2));
    }

    private <T> List<T> getObjectsListV11(Class<T> objectClass, Set<NameValuePair> params) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        int totalObjectsFoundOnServer;
        List<T> foundItems;
        ArrayList<T> objects = new ArrayList<T>();
        int limit = 25;
        params.add((NameValuePair)new BasicNameValuePair("limit", String.valueOf(limit)));
        int offset = 0;
        do {
            ArrayList<NameValuePair> paramsList = new ArrayList<NameValuePair>(params);
            paramsList.add((NameValuePair)new BasicNameValuePair("offset", String.valueOf(offset)));
            String query = String.valueOf(urls.get(objectClass)) + URL_POSTFIX;
            URI uri = this.createURI(query, paramsList);
            RedmineManager.debug("URI = " + uri);
            HttpGet http = new HttpGet(uri);
            Response response = this.sendRequest((HttpRequest)http);
            if (response.getCode() == 404) {
                throw new NotFoundException("Server returned '404 not found'. response body:" + response.getBody());
            }
            String body = response.getBody();
            totalObjectsFoundOnServer = RedmineXMLParser.parseObjectsTotalCount(body);
            foundItems = RedmineXMLParser.parseObjectsFromXML(objectClass, body);
            if (foundItems.size() == 0) break;
            objects.addAll(foundItems);
        } while ((offset += foundItems.size()) < totalObjectsFoundOnServer);
        return objects;
    }

    private <T> T getObject(Class<T> objectClass, Integer id, NameValuePair ... params) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        String query = String.valueOf(urls.get(objectClass)) + "/" + id + URL_POSTFIX;
        URI uri = this.createURI(query, params);
        String body = this.sendGet(uri);
        return RedmineXMLParser.parseObjectFromXML(objectClass, body);
    }

    private <T> T createObject(Class<T> classs, T obj) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        URI uri = this.getCreateURI(obj.getClass());
        HttpPost http = new HttpPost(uri);
        String xml = RedmineXMLGenerator.toXML(obj);
        this.setEntity((HttpEntityEnclosingRequest)http, xml);
        Response response = this.sendRequest((HttpRequest)http);
        if (response.getCode() == 404) {
            throw new NotFoundException("Server returned '404 not found'. response body:" + response.getBody());
        }
        return RedmineXMLParser.parseObjectFromXML(classs, response.getBody());
    }

    private <T extends Identifiable> void updateObject(Class<T> classs, T obj) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        URI uri = this.getUpdateURI(obj.getClass(), Integer.toString(obj.getId()));
        HttpPut http = new HttpPut(uri);
        String xml = RedmineXMLGenerator.toXML(obj);
        this.setEntity((HttpEntityEnclosingRequest)http, xml);
        Response response = this.sendRequest((HttpRequest)http);
        if (response.getCode() == 404) {
            throw new NotFoundException("Server returned '404 not found'. response body:" + response.getBody());
        }
    }

    private <T extends Identifiable> void deleteObject(Class<T> classs, String id) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        URI uri = this.getUpdateURI(classs, id);
        HttpDelete http = new HttpDelete(uri);
        Response response = this.sendRequest((HttpRequest)http);
        if (response.getCode() == 404) {
            throw new NotFoundException("Server returned '404 not found'. response body:" + response.getBody());
        }
    }

    private URI getCreateURI(Class zz) throws MalformedURLException {
        String query = String.valueOf(urls.get(zz)) + URL_POSTFIX;
        return this.createURI(query);
    }

    private URI getUpdateURI(Class zz, String id) throws MalformedURLException {
        String query = String.valueOf(urls.get(zz)) + "/" + id + URL_POSTFIX;
        return this.createURI(query);
    }

    private String sendGet(URI uri) throws NotFoundException, IOException, AuthenticationException, RedmineException {
        HttpGet http = new HttpGet(uri);
        Response response = this.sendRequest((HttpRequest)http);
        if (response.getCode() == 404) {
            throw new NotFoundException("Server returned '404 not found'. response body:" + response.getBody());
        }
        return response.getBody();
    }

    public Project createProject(Project project) throws IOException, AuthenticationException, RedmineException {
        URI uri = this.createURI("projects.xml", new NameValuePair[]{new BasicNameValuePair("include", "trackers")});
        HttpPost httpPost = new HttpPost(uri);
        String createProjectXML = RedmineXMLGenerator.toXML(project);
        this.setEntity((HttpEntityEnclosingRequest)httpPost, createProjectXML);
        Response response = this.sendRequest((HttpRequest)httpPost);
        Project createdProject = RedmineXMLParser.parseProjectFromXML(response.getBody());
        return createdProject;
    }

    public void updateProject(Project project) throws IOException, AuthenticationException, RedmineException, NotFoundException {
        this.updateObject(Project.class, project);
    }

    public int getObjectsPerPage() {
        return this.objectsPerPage;
    }

    public void setObjectsPerPage(int pageSize) {
        this.objectsPerPage = pageSize;
    }

    public List<User> getUsers() throws IOException, AuthenticationException, NotFoundException, RedmineException {
        return this.getObjectsList(User.class, new HashSet<NameValuePair>());
    }

    public User getUserById(Integer userId) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        return this.getObject(User.class, userId, new NameValuePair[0]);
    }

    public User getCurrentUser() throws IOException, AuthenticationException, RedmineException {
        URI uri = this.createURI("users/current.xml");
        HttpGet http = new HttpGet(uri);
        Response response = this.sendRequest((HttpRequest)http);
        return RedmineXMLParser.parseUserFromXML(response.getBody());
    }

    public User createUser(User user) throws IOException, AuthenticationException, RedmineException, NotFoundException {
        return this.createObject(User.class, user);
    }

    public void updateUser(User user) throws IOException, AuthenticationException, RedmineException, NotFoundException {
        this.updateObject(User.class, user);
    }

    public List<TimeEntry> getTimeEntries() throws IOException, AuthenticationException, NotFoundException, RedmineException {
        return this.getObjectsList(TimeEntry.class, new HashSet<NameValuePair>());
    }

    public TimeEntry getTimeEntry(Integer id) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        return this.getObject(TimeEntry.class, id, new NameValuePair[0]);
    }

    public List<TimeEntry> getTimeEntriesForIssue(Integer issueId) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        HashSet<NameValuePair> params = new HashSet<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("issue_id", Integer.toString(issueId)));
        return this.getObjectsList(TimeEntry.class, params);
    }

    public TimeEntry createTimeEntry(TimeEntry obj) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        if (!this.isValidTimeEntry(obj)) {
            throw this.createIllegalTimeEntryException();
        }
        return this.createObject(TimeEntry.class, obj);
    }

    public void updateTimeEntry(TimeEntry obj) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        if (!this.isValidTimeEntry(obj)) {
            throw this.createIllegalTimeEntryException();
        }
        this.updateObject(TimeEntry.class, obj);
    }

    public void deleteTimeEntry(Integer id) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        this.deleteObject(TimeEntry.class, Integer.toString(id));
    }

    private boolean isValidTimeEntry(TimeEntry obj) {
        return obj.getProjectId() != null || obj.getIssueId() != null;
    }

    private IllegalArgumentException createIllegalTimeEntryException() {
        return new IllegalArgumentException("You have to either define a Project or Issue ID for a Time Entry. The given Time Entry object has neither defined.");
    }

    public List<SavedQuery> getSavedQueries(String projectKey) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        HashSet<NameValuePair> params = new HashSet<NameValuePair>();
        if (projectKey != null && projectKey.length() > 0) {
            params.add((NameValuePair)new BasicNameValuePair("project_id", projectKey));
        }
        return this.getObjectsList(SavedQuery.class, params);
    }

    public List<SavedQuery> getSavedQueries() throws IOException, AuthenticationException, NotFoundException, RedmineException {
        return this.getObjectsList(SavedQuery.class, new HashSet<NameValuePair>());
    }

    private static void debug(String string) {
    }

    public IssueRelation createRelation(String projectKey, Integer issueId, Integer issueToId, String type) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        URI uri = this.createURI("issues/" + issueId + "/relations.xml");
        HttpPost http = new HttpPost(uri);
        IssueRelation toCreate = new IssueRelation();
        toCreate.setIssueId(issueId);
        toCreate.setIssueToId(issueToId);
        toCreate.setType(type);
        String xml = RedmineXMLGenerator.toXML(toCreate);
        this.setEntity((HttpEntityEnclosingRequest)http, xml);
        Response response = this.sendRequest((HttpRequest)http);
        IssueRelation relation = RedmineXMLParser.parseRelationFromXML(response.getBody());
        return relation;
    }

    public static enum INCLUDE {
        journals,
        relations;

    }

    private static enum MODE {
        REDMINE_1_0,
        REDMINE_1_1_OR_CHILIPROJECT_1_2;

    }

    class Response {
        private int code;
        private String body;

        public Response(int code, String body) {
            this.code = code;
            this.body = body;
        }

        public int getCode() {
            return this.code;
        }

        public String getBody() {
            return this.body;
        }
    }
}

