/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.calculator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.util.PzGradient;

public class Calc
extends PzDialog {
    private static final long serialVersionUID = -2973347791865048453L;
    private JTextField text;
    String sText1;
    String sText2;
    double dReg1;
    double dReg2;
    double dMem;
    String sOperator;
    boolean isFixReg;

    public Calc(PzDialog parent) {
        super(parent);
        this.initGUI();
    }

    public Calc(JFrame frame, String parameter) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        PzPanel pFrame = new PzPanel();
        pFrame.setLayout(new FlowLayout());
        pFrame.setPaintGradient(true);
        if (this.getSession() != null && this.getSession().getParameter("gradient") != null) {
            pFrame.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            pFrame.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
        this.text = new JTextField();
        this.text.setEditable(false);
        PzPanel pCalc = new PzPanel();
        pCalc.setLayout(new BorderLayout(0, 10));
        pCalc.add("North", this.text);
        pCalc.setOpaque(false);
        this.text.setSize(new Dimension(12, 24));
        this.text.setFont(new Font("Tahoma", 0, 14));
        this.text.setHorizontalAlignment(4);
        this.text.setBackground(new Color(255, 255, 255));
        pFrame.add("Center", pCalc);
        PzPanel pKey = new PzPanel();
        pKey.setOpaque(false);
        pKey.setLayout(new GridLayout(5, 4, 5, 5));
        this.add("Center", pKey);
        pKey.add(new PzButton("C"));
        pKey.add(new PzButton("MR"));
        pKey.add(new PzButton("M-"));
        pKey.add(new PzButton("M+"));
        pKey.add(new PzButton("7"));
        pKey.add(new PzButton("8"));
        pKey.add(new PzButton("9"));
        pKey.add(new PzButton("/"));
        pKey.add(new PzButton("4"));
        pKey.add(new PzButton("5"));
        pKey.add(new PzButton("6"));
        pKey.add(new PzButton("*"));
        pKey.add(new PzButton("1"));
        pKey.add(new PzButton("2"));
        pKey.add(new PzButton("3"));
        pKey.add(new PzButton("-"));
        pKey.add(new PzButton("0"));
        pKey.add(new PzButton("."));
        pKey.add(new PzButton("="));
        pKey.add(new PzButton("+"));
        int i = 0;
        while (i < pKey.getComponents().length) {
            Component c = pKey.getComponents()[i];
            if (c instanceof PzButton) {
                ((PzButton)c).addActionListener(this);
                ((PzButton)c).setActionCommand(((PzButton)c).getText());
                ((PzButton)c).setFocusable(false);
                String text = ((PzButton)c).getText();
                if (text.length() == 1) {
                    try {
                        Integer.parseInt(text);
                        ((PzButton)c).setShortcut("NUMPAD" + text);
                    }
                    catch (Exception exception) {
                        String shortcut = ((PzButton)c).getText();
                        if (text.equals("-")) {
                            shortcut = "SUBTRACT";
                        } else if (text.equals("+")) {
                            shortcut = "ADD";
                        } else if (text.equals("/")) {
                            shortcut = "DIVIDE";
                        } else if (text.equals("*")) {
                            shortcut = "MULTIPLY";
                        } else if (text.equals(".")) {
                            shortcut = "DECIMAL";
                        } else if (text.equals("=")) {
                            shortcut = "ENTER";
                        }
                        ((PzButton)c).setShortcut(shortcut);
                    }
                }
            }
            ++i;
        }
        pCalc.add("South", pKey);
        this.setLayout(new BorderLayout(0, 0));
        this.add("Center", pFrame);
        this.setBackground(Color.darkGray);
        this.setResizable(false);
        this.dReg1 = 0.0;
        this.dReg2 = 0.0;
        this.dMem = 0.0;
        this.sOperator = "";
        this.text.setText("0");
        this.isFixReg = true;
        this.pack();
    }

    private double Calculation(String sOperator, double dReg1, double dReg2) {
        dReg1 = "+".equals(sOperator) ? (dReg1 += dReg2) : ("-".equals(sOperator) ? (dReg1 -= dReg2) : ("*".equals(sOperator) ? (dReg1 *= dReg2) : ("/".equals(sOperator) ? (dReg1 /= dReg2) : dReg2)));
        return dReg1;
    }

    public static void showCalculator(PzDialog parent) {
        Calc calc = new Calc(parent);
        calc.setModal(true);
        calc.setLocationRelativeTo(parent);
        calc.setSize(250, 250);
        calc.setVisible(true);
        calc.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String arg = ((PzButton)e.getSource()).getActionCommand();
        if ("C".equals(arg)) {
            this.dReg1 = 0.0;
            this.dReg2 = 0.0;
            this.sOperator = "";
            this.text.setText("0");
            this.isFixReg = true;
        } else if ("0".equals(arg) | "1".equals(arg) | "2".equals(arg) | "3".equals(arg) | "4".equals(arg) | "5".equals(arg) | "6".equals(arg) | "7".equals(arg) | "8".equals(arg) | "9".equals(arg) | ".".equals(arg)) {
            this.sText2 = this.isFixReg ? arg : String.valueOf(this.text.getText()) + arg;
            this.text.setText(this.sText2);
            this.isFixReg = false;
        } else if ("+".equals(arg) | "-".equals(arg) | "*".equals(arg) | "/".equals(arg) | "=".equals(arg)) {
            this.sText1 = this.text.getText();
            this.dReg2 = Double.valueOf(this.sText1);
            this.dReg1 = this.Calculation(this.sOperator, this.dReg1, this.dReg2);
            Double dTemp = new Double(this.dReg1);
            this.sText2 = dTemp.toString();
            this.text.setText(this.sText2);
            this.sOperator = arg;
            this.isFixReg = true;
        } else if ("MR".equals(arg)) {
            Double dTemp = new Double(this.dMem);
            this.sText2 = dTemp.toString();
            this.text.setText(this.sText2);
            this.sOperator = "";
            this.isFixReg = true;
        } else if ("M+".equals(arg)) {
            this.sText1 = this.text.getText();
            this.dReg2 = Double.valueOf(this.sText1);
            this.dReg1 = this.Calculation(this.sOperator, this.dReg1, this.dReg2);
            Double dTemp = new Double(this.dReg1);
            this.sText2 = dTemp.toString();
            this.text.setText(this.sText2);
            this.dMem += this.dReg1;
            this.sOperator = "";
            this.isFixReg = true;
        } else if ("M-".equals(arg)) {
            this.sText1 = this.text.getText();
            this.dReg2 = Double.valueOf(this.sText1);
            this.dReg1 = this.Calculation(this.sOperator, this.dReg1, this.dReg2);
            Double dTemp = new Double(this.dReg1);
            this.sText2 = dTemp.toString();
            this.text.setText(this.sText2);
            this.dMem -= this.dReg1;
            this.sOperator = "";
            this.isFixReg = true;
        }
    }
}

