/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.menu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rs.pezar.core.PzApplication;
import rs.pezar.core.PzGenericService;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogGeneralijeFirme
extends PzDialog {
    private static final long serialVersionUID = -5400802022141681511L;
    private static PzPanel pnlFields;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private PzTextField email;
    private PzTextField fax;
    private PzTextField telefoni;
    private PzTextField grad;
    private static PzButton btnPreuzmi;
    private JLabel jLabel7;
    private PzComboBox cbPDVObracun;
    private JCheckBox pdvObveznik;
    private PzTextField mestoReg;
    private PzNumericOnlyTextField sifDelatnosti;
    private PzTextField regBroj;
    private PzNumericOnlyTextField matBroj;
    private PzNumericOnlyTextField pib;
    private PzNumericOnlyTextField postBroj;
    private PzTextField adresa;
    private PzTextField naziv;
    private JLabel jLabel12;
    private JLabel jLabel11;
    private JLabel jLabel10;
    private JLabel jLabel9;
    private JLabel jLabel8;
    private JLabel jLabel6;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private static PzButton btnOK;
    private static JPanel pnlButtons;
    private Firma firma;
    private PzPanelHeader pzPanelHeader1;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogGeneralijeFirme inst = new PzDialogGeneralijeFirme(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogGeneralijeFirme(JFrame frame) {
        super(frame);
        this.initGUI();
        try {
            Firma firma;
            final Firma tmp = firma = PzFirma.getFirma();
            if (firma != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PzSwingUtility.fillForm(pnlFields, tmp);
                    }
                });
                if (firma.getPdvObveznik() == 1) {
                    this.pdvObveznik.setSelected(true);
                    this.setObracunskiPeriod();
                } else {
                    this.pdvObveznik.setSelected(false);
                }
            } else {
                firma = new Firma();
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(this, e);
        }
    }

    private void initGUI() {
        try {
            this.setTitle("Generalije firme");
            this.pzPanelHeader1 = new PzPanelHeader();
            this.pzPanelHeader1.setTitle("Generalije firme");
            this.getContentPane().add((Component)this.pzPanelHeader1, "North");
            pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.1};
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
            pnlFieldsLayout.columnWidths = new int[]{7, 80, 21, 7, 7};
            this.add((Component)pnlFields, "Center");
            pnlFields.setLayout(pnlFieldsLayout);
            pnlFields.setTransferFocusOnEnter(true);
            pnlFields.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            this.jLabel1 = new JLabel();
            pnlFields.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel1.setText("Naziv firme");
            this.jLabel2 = new JLabel();
            pnlFields.add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel2.setText("Adresa");
            this.jLabel3 = new JLabel();
            pnlFields.add((Component)this.jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel3.setText("Po\u0161tanski broj i grad");
            this.jLabel4 = new JLabel();
            pnlFields.add((Component)this.jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel4.setText("Telefoni");
            this.jLabel5 = new JLabel();
            pnlFields.add((Component)this.jLabel5, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel5.setText("Fax");
            this.jLabel6 = new JLabel();
            pnlFields.add((Component)this.jLabel6, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel6.setText("Email");
            this.jLabel8 = new JLabel();
            pnlFields.add((Component)this.jLabel8, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel8.setText("PIB");
            this.jLabel9 = new JLabel();
            pnlFields.add((Component)this.jLabel9, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel9.setText("Mati\u010dni broj");
            this.jLabel10 = new JLabel();
            pnlFields.add((Component)this.jLabel10, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel10.setText("Registracioni broj");
            this.jLabel11 = new JLabel();
            pnlFields.add((Component)this.jLabel11, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel11.setText("\u0160ifra delatnosti");
            this.jLabel12 = new JLabel();
            pnlFields.add((Component)this.jLabel12, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel12.setText("Registrovan u");
            this.naziv = new PzTextField();
            this.naziv.setName("naziv");
            this.naziv.setColumns(50);
            pnlFields.add((Component)this.naziv, new GridBagConstraints(1, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.adresa = new PzTextField();
            this.adresa.setName("adresa");
            pnlFields.add((Component)this.adresa, new GridBagConstraints(1, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.postBroj = new PzNumericOnlyTextField();
            this.postBroj.setName("postBroj");
            pnlFields.add((Component)this.postBroj, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.postBroj.setHorizontalAlignment(2);
            this.grad = new PzTextField();
            this.grad.setName("grad");
            pnlFields.add((Component)this.grad, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.telefoni = new PzTextField();
            this.telefoni.setName("telefoni");
            pnlFields.add((Component)this.telefoni, new GridBagConstraints(1, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.fax = new PzTextField();
            this.fax.setName("fax");
            pnlFields.add((Component)this.fax, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.email = new PzTextField();
            this.email.setName("email");
            pnlFields.add((Component)this.email, new GridBagConstraints(1, 5, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.pib = new PzNumericOnlyTextField();
            this.pib.setName("pib");
            pnlFields.add((Component)this.pib, new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.pib.setHorizontalAlignment(2);
            this.matBroj = new PzNumericOnlyTextField();
            this.matBroj.setName("matBroj");
            pnlFields.add((Component)this.matBroj, new GridBagConstraints(1, 7, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.matBroj.setHorizontalAlignment(2);
            this.regBroj = new PzTextField();
            this.regBroj.setName("regBroj");
            pnlFields.add((Component)this.regBroj, new GridBagConstraints(1, 8, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.regBroj.setHorizontalAlignment(2);
            this.sifDelatnosti = new PzNumericOnlyTextField();
            this.sifDelatnosti.setName("sifDelatnosti");
            pnlFields.add((Component)this.sifDelatnosti, new GridBagConstraints(1, 9, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.sifDelatnosti.setHorizontalAlignment(2);
            this.mestoReg = new PzTextField();
            this.mestoReg.setName("mestoReg");
            pnlFields.add((Component)this.mestoReg, new GridBagConstraints(1, 10, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.pdvObveznik = new JCheckBox();
            pnlFields.add((Component)this.pdvObveznik, new GridBagConstraints(1, 11, 3, 1, 0.0, 0.0, 17, 3, new Insets(5, 0, 5, 0), 0, 0));
            this.pdvObveznik.setText("Registrovan za PDV");
            this.pdvObveznik.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    PzDialogGeneralijeFirme.this.pdvObveznikStateChanged(evt);
                }
            });
            this.cbPDVObracun = new PzComboBox();
            this.cbPDVObracun.setFont(new Font("SansSerif", 0, 12));
            this.cbPDVObracun.addItem(new PzChoice("", ""));
            this.cbPDVObracun.addItem(new PzChoice("Jednomese\u010dni PDV obra\u010dun", "jednomesecni"));
            this.cbPDVObracun.addItem(new PzChoice("Tromese\u010dni PDV obra\u010dun", "tromesecni"));
            pnlFields.add((Component)this.cbPDVObracun, new GridBagConstraints(1, 12, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel7 = new JLabel();
            pnlFields.add((Component)this.jLabel7, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel7.setText("PDV period");
            pnlButtons = new JPanel();
            this.add((Component)pnlButtons, "South");
            btnOK = new PzButton();
            pnlButtons.add(btnOK);
            btnOK.setText("Potvrdi");
            btnOK.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/check.png")));
            btnOK.setActionCommand("update");
            btnOK.setFont(new Font("Tahoma", 1, 12));
            btnOK.setBounds(638, 7, 143, 30);
            btnOK.setPreferredSize(new Dimension(128, 31));
            btnOK.addActionListener(this);
            btnPreuzmi = new PzButton();
            pnlButtons.add(btnPreuzmi);
            btnPreuzmi.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/businessman_add_small.png")));
            btnPreuzmi.setPreferredSize(new Dimension(148, 31));
            btnPreuzmi.setBounds(638, 7, 143, 30);
            btnPreuzmi.setText("Preuzmi podatke");
            btnPreuzmi.addActionListener(this);
            btnPreuzmi.setActionCommand("preuzmi");
            this.setRestorable(false);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        try {
            int rez;
            if (actionCommand.equals("update")) {
                this.firma = (Firma)PzSwingUtility.createEntity(Firma.class, pnlFields);
                this.firma.setPdvObveznik((short)(this.pdvObveznik.isSelected() ? 1 : 0));
                if (this.pdvObveznik.isSelected() && ((String)((PzChoice)this.cbPDVObracun.getSelectedItem()).getValue()).equals("")) {
                    PzSwingUtility.showErrorMessage(this, "Polje obra\u010dunskog perioda ne mo\u017ee ostati prazno.");
                    return;
                }
                if (this.pdvObveznik.isSelected()) {
                    PzParameter.setParameter("OBRACUNSKI_PERIOD", (String)((PzChoice)this.cbPDVObracun.getSelectedItem()).getValue());
                } else {
                    PzParameter.setParameter("OBRACUNSKI_PERIOD", "");
                }
                this.firma.setAdresa(this.adresa.getVal());
                this.firma.setEmail(this.email.getVal());
                this.firma.setFax(this.fax.getVal());
                this.firma.setGrad(this.grad.getVal());
                this.firma.setMatBroj(this.matBroj.getVal());
                this.firma.setMestoReg(this.mestoReg.getVal());
                this.firma.setNaziv(this.naziv.getVal());
                this.firma.setPib(this.pib.getVal());
                this.firma.setPostBroj(this.postBroj.getVal());
                this.firma.setRegBroj(this.regBroj.getVal());
                this.firma.setSifDelatnosti(this.sifDelatnosti.getVal());
                this.firma.setTelefoni(this.telefoni.getVal());
                this.firma.setOznFirma(1);
                PzEntityManager.update(this.firma);
                this.dispose();
            } else if (actionCommand.equals("preuzmi") && (rez = PzSwingUtility.daNeDijalog(this, "<html>Ovom opcijom preuzimate podatke privrednih dru\u0161tava i preduzetnika iz sistama NBS po mati\u010dnom broju ili PIB-u.<br>Postoje\u0107i podaci \u0107e biti zamenjeni sa novim. Da li \u017eelite da nastavite?", "Informacija", null, false)) == 0) {
                if (this.matBroj.getVal().equals("0") && this.pib.getVal().equals("0")) {
                    PzSwingUtility.showInformationMessage(this, "Morate uneti mati\u010dni broj ili PIB");
                    return;
                }
                PzGenericService service = PzApplication.getApplication().getGenericServiceRegistry().getService("NBS_GETKOMITENT");
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                map.put("MBR", this.matBroj.getVal());
                map.put("PIB", this.pib.getVal());
                Vector komitenti = (Vector)service.run(map);
                if (komitenti.size() == 0) {
                    PzSwingUtility.showInformationMessage(this, "Nije prona\u0111en nijedan komitent.");
                    return;
                }
                Komitent k = (Komitent)komitenti.get(0);
                this.naziv.setVal(k.getNaziv());
                this.adresa.setVal(k.getAdresa());
                this.email.setVal(k.getEmail());
                this.fax.setVal(k.getBrFaxa());
                this.grad.setVal(k.getGrad());
                this.matBroj.setVal(k.getMatBroj());
                this.mestoReg.setVal(k.getGrad());
                this.pib.setVal(k.getPib());
                this.postBroj.setVal(k.getPostBroj());
                this.regBroj.setVal(k.getRegBroj());
                this.sifDelatnosti.setVal(k.getSifDelatnosti());
                this.telefoni.setVal(k.getTelefoni());
                this.pdvObveznik.setSelected(false);
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle(this, e1);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogGeneralijeFirme(Boolean.FALSE);
    }

    public PzDialogGeneralijeFirme(Boolean initGUI) {
    }

    private void pdvObveznikStateChanged(ChangeEvent evt) {
        if (this.pdvObveznik.isSelected()) {
            this.cbPDVObracun.setEnabled(true);
        } else {
            this.cbPDVObracun.setEnabled(false);
        }
    }

    private void setObracunskiPeriod() {
        try {
            int i = 0;
            while (i < this.cbPDVObracun.getComponentCount() + 1) {
                if (PzParameter.getParameterValue("OBRACUNSKI_PERIOD").equals(((PzChoice)this.cbPDVObracun.getItemAt(i)).getValue())) {
                    this.cbPDVObracun.setSelectedIndex(i);
                }
                ++i;
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(this, e);
        }
    }
}

