/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.menu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Tekuciracun;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;

public class PzDialogTekuciRacuni
extends PzDialog {
    private static final long serialVersionUID = -4308660859270885020L;
    private PzPanel pzPanel1;
    private JScrollPane jScrollPane1;
    private static PzTable pzTable1;
    private PzToolBarIcon iconSadrzaj;
    private PzToolBarIcon iconIzmena;
    private PzToolBarIcon iconDodavanje;
    private JToolBar toolbar;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogTekuciRacuni inst = new PzDialogTekuciRacuni(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogTekuciRacuni(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogTekuciRacuni(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Teku\u0107i ra\u010duni");
            this.toolbar = new JToolBar();
            this.getContentPane().add((Component)this.toolbar, "North");
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.iconDodavanje = new PzToolBarIcon();
            this.toolbar.add(this.iconDodavanje);
            this.iconDodavanje.setText("Dodavanje ra\u010duna |(INS)");
            this.iconDodavanje.setActionCommand("Dodavanje");
            this.iconDodavanje.addActionListener(this);
            this.iconDodavanje.setShortcut("INSERT");
            this.iconDodavanje.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/product_add.png")));
            this.iconIzmena = new PzToolBarIcon();
            this.toolbar.add(this.iconIzmena);
            this.iconIzmena.setActionCommand("Izmena");
            this.iconIzmena.addActionListener(this);
            this.iconIzmena.setShortcut("F3");
            this.iconIzmena.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/product_edit.png")));
            this.iconIzmena.setText("Izmena ra\u010duna|(F3)");
            this.iconSadrzaj = new PzToolBarIcon();
            this.toolbar.add(this.iconSadrzaj);
            this.iconSadrzaj.setText("Obri\u0161i ra\u010dun|(DEL)");
            this.iconSadrzaj.setActionCommand("Brisanje");
            this.iconSadrzaj.addActionListener(this);
            this.iconSadrzaj.setShortcut("Delete");
            this.iconSadrzaj.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/product_delete.png")));
            this.jScrollPane1 = new JScrollPane();
            this.getContentPane().add((Component)this.jScrollPane1, "Center");
            this.jScrollPane1.setPreferredSize(new Dimension(382, 535));
            String query = "SELECT t FROM Tekuciracun t WHERE t.firma.oznFirma=1";
            Vector<PzEntity> data = PzEntityManager.select(query);
            pzTable1 = new PzTable(data, Tekuciracun.class);
            pzTable1.getColumn(0).setCellRenderer(new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel renderer = new JLabel();
                    if (new Short(1).equals(value)) {
                        renderer.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/check_small.png")));
                    }
                    return renderer;
                }
            });
            this.jScrollPane1.setViewportView((Component)((Object)pzTable1));
            this.pzPanel1 = new PzPanel();
            this.getContentPane().add((Component)this.pzPanel1, "West");
            this.setSize(400, 300);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        PzTable data1 = null;
        PzEntity data2 = null;
        boolean izmena = false;
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equalsIgnoreCase("Izmena")) {
            if (pzTable1.getSelectedEntity() == null) return;
            actionCommand = "Dodavanje";
            izmena = true;
        } else if (actionCommand.equalsIgnoreCase("Brisanje")) {
            pzTable1.removeSelectedEntity(true, true);
            return;
        }
        data1 = pzTable1;
        data2 = pzTable1.getSelectedEntity();
        this.showDialog("tekuciRacuni.TekuciRacuni" + actionCommand, izmena, (Object)data1, (Object)data2);
    }

    public void focusTable() {
        pzTable1.requestFocusInWindow();
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogTekuciRacuni(Boolean.FALSE);
    }

    public PzDialogTekuciRacuni(Boolean initGUI) {
    }

    public static Tekuciracun getTekuciRacun(PzDialog parent, String title) {
        PzDialogTekuciRacuni inst = new PzDialogTekuciRacuni(parent);
        if (title != null) {
            inst.setTitle(title);
        }
        pzTable1.setEnterAction(new AbstractAction(){
            private static final long serialVersionUID = 5975659041376928753L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PzDialogTekuciRacuni.this.dispose();
                PzApplication.getApplication().getSession().getRuntimeStore().put("tr", pzTable1.getSelectedEntity());
            }
        });
        inst.setModal(true);
        inst.setVisible(true);
        return (Tekuciracun)PzApplication.getApplication().getSession().getRuntimeStore().get("tr");
    }
}

