/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.menu.standardnePoruke;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Standardnaporuka;
import rs.pezar.globals.TipDokumentStructure;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzButtonPanel;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextArea;
import rs.pezar.swing.fields.PzTextField;

public class StandardnePorukeDodavanje
extends PzDialogInsert {
    private PzPanel panel;
    private PzButtonPanel pzButtonPanel1;
    private PzPanelHeader header;
    private PzTextArea txtSadrzaj;
    private JScrollPane txtSadrzajScroll;
    private JLabel lblSadrzaj;
    private PzTextField txtNaziv;
    private JLabel lblNaziv;
    private PzButton btnPotvrdi;
    private PzPanel pnlContent;
    private JComboBox tipDokumenta;
    private JLabel lblTipDokumenta;
    private PzTextField txtUslov;
    private JLabel lblUslov;
    private Standardnaporuka poruka;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                StandardnePorukeDodavanje inst = new StandardnePorukeDodavanje(frame);
                inst.setVisible(true);
            }
        });
    }

    public StandardnePorukeDodavanje() {
        this.initGUI();
    }

    public StandardnePorukeDodavanje(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public StandardnePorukeDodavanje(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    public StandardnePorukeDodavanje(PzDialog dialog, boolean izmena, Object data1, Object data2) {
        super(dialog, izmena, (PzTable)((Object)data1), data2);
        this.popuniTipoveDokumenata();
        if (izmena) {
            this.poruka = (Standardnaporuka)this.getTable().getSelectedEntity();
            int i = 0;
            while (i < this.tipDokumenta.getItemCount()) {
                if (((TipDokumentStructure.Tip)this.tipDokumenta.getItemAt(i)).getTip() != null && ((TipDokumentStructure.Tip)this.tipDokumenta.getItemAt(i)).getTip().equals(this.poruka.getTipDokumenta())) {
                    this.tipDokumenta.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    protected void initGUI() {
        try {
            this.header = new PzPanelHeader();
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.pnlContent = new PzPanel();
            this.pnlContent.setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.pnlContent, "Center");
            this.pnlContent.add((Component)this.header, "North");
            this.panel = new PzPanel();
            this.panel.setBorder(new EmptyBorder(10, 10, 10, 10));
            GridBagLayout panelLayout = new GridBagLayout();
            this.pnlContent.add((Component)this.panel, "Center");
            panelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            int[] nArray = new int[4];
            nArray[0] = 30;
            nArray[2] = 25;
            nArray[3] = 7;
            panelLayout.rowHeights = nArray;
            panelLayout.columnWeights = new double[]{0.0, 0.0, 1.0};
            panelLayout.columnWidths = new int[]{85, 169, 20};
            this.panel.setLayout(panelLayout);
            this.lblTipDokumenta = new JLabel("Tip dokumenta:");
            GridBagConstraints gbc_lblTipDokumenta = new GridBagConstraints();
            gbc_lblTipDokumenta.insets = new Insets(0, 0, 5, 5);
            gbc_lblTipDokumenta.anchor = 13;
            gbc_lblTipDokumenta.gridx = 0;
            gbc_lblTipDokumenta.gridy = 0;
            this.panel.add((Component)this.lblTipDokumenta, gbc_lblTipDokumenta);
            this.tipDokumenta = new JComboBox();
            this.panel.add((Component)this.tipDokumenta, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
            this.tipDokumenta.setFont(new Font("Tahoma", 0, 14));
            this.tipDokumenta.setBounds(766, 26, 102, 25);
            this.lblUslov = new JLabel("Uslov:");
            GridBagConstraints gbc_lblUslov = new GridBagConstraints();
            gbc_lblUslov.insets = new Insets(0, 0, 5, 5);
            gbc_lblUslov.anchor = 13;
            gbc_lblUslov.gridx = 0;
            gbc_lblUslov.gridy = 1;
            this.panel.add((Component)this.lblUslov, gbc_lblUslov);
            this.txtUslov = new PzTextField();
            GridBagConstraints gbc_txtUslov = new GridBagConstraints();
            gbc_txtUslov.gridwidth = 2;
            gbc_txtUslov.insets = new Insets(0, 0, 5, 0);
            gbc_txtUslov.fill = 2;
            gbc_txtUslov.gridx = 1;
            gbc_txtUslov.gridy = 1;
            this.panel.add((Component)this.txtUslov, gbc_txtUslov);
            this.lblNaziv = new JLabel();
            this.panel.add((Component)this.lblNaziv, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 5, 5), 0, 0));
            this.lblNaziv.setText("Naziv poruke:");
            this.txtNaziv = new PzTextField();
            this.panel.add((Component)this.txtNaziv, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.lblSadrzaj = new JLabel();
            this.panel.add((Component)this.lblSadrzaj, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 10, 0, 5), 0, 0));
            this.lblSadrzaj.setText("Sadr\u017eaj poruke:");
            this.txtSadrzajScroll = new JScrollPane();
            this.panel.add((Component)this.txtSadrzajScroll, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.txtSadrzaj = new PzTextArea();
            this.txtSadrzaj.setWrapStyleWord(true);
            this.txtSadrzaj.setLineWrap(true);
            this.txtSadrzajScroll.setViewportView(this.txtSadrzaj);
            this.txtSadrzaj.setRows(3);
            this.pzButtonPanel1 = new PzButtonPanel();
            this.pnlContent.add((Component)this.pzButtonPanel1, "South");
            this.btnPotvrdi = new PzButton();
            this.pzButtonPanel1.add(this.btnPotvrdi);
            this.btnPotvrdi.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/check.png")));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.addActionListener(this);
            this.pzButtonPanel1.add(this.btnPotvrdi);
            this.setSize(400, 300);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        try {
            if (actionCommand.equalsIgnoreCase("Dodaj") || actionCommand.equalsIgnoreCase("Izmeni")) {
                if (actionCommand.equalsIgnoreCase("Dodaj")) {
                    this.poruka = new Standardnaporuka();
                    Integer id = (Integer)PzEntityManager.getList("SELECT MAX(p.oznPoruka) FROM Standardnaporuka p").get(0);
                    this.poruka.setOznPoruka(id + 1);
                    this.poruka.setNaziv(this.txtNaziv.getVal());
                    this.poruka.setSadrzaj(this.txtSadrzaj.getVal().toString());
                    this.poruka.setTipDokumenta(((TipDokumentStructure.Tip)this.tipDokumenta.getSelectedItem()).getTip());
                    this.poruka.setUslov(this.txtUslov.getVal());
                    this.getTable().insert((PzEntity)this.poruka, true);
                    this.dispose();
                } else {
                    this.poruka.setNaziv(this.txtNaziv.getVal());
                    this.poruka.setSadrzaj(this.txtSadrzaj.getVal().toString());
                    this.poruka.setTipDokumenta(((TipDokumentStructure.Tip)this.tipDokumenta.getSelectedItem()).getTip());
                    this.poruka.setUslov(this.txtUslov.getVal());
                    this.getTable().updateSelectedEntity((PzEntity)this.poruka, true);
                    this.dispose();
                }
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle(this, e1);
        }
    }

    @Override
    protected void onInsert() {
        this.setTitle("Dodavanje poruke");
        this.btnPotvrdi.setActionCommand("Dodaj");
    }

    @Override
    protected void onUpdate() {
        this.setTitle("Izmena poruke");
        this.btnPotvrdi.setActionCommand("Izmeni");
        Standardnaporuka poruka = (Standardnaporuka)this.getTable().getSelectedEntity();
        this.txtNaziv.setVal(poruka.getNaziv());
        this.txtSadrzaj.setVal(poruka.getSadrzaj());
        this.txtUslov.setVal(poruka.getUslov());
    }

    @Override
    public void setEntity(PzEntity entity, Component component) {
    }

    @Override
    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Dodavanje standardne poruke");
    }

    @Override
    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Izmena standardne poruke");
    }

    public static Object getGUIBuilderInstance() {
        return new StandardnePorukeDodavanje(Boolean.FALSE);
    }

    public StandardnePorukeDodavanje(Boolean initGUI) {
    }

    private void popuniTipoveDokumenata() {
        List<TipDokumentStructure.Tip> tipovi = TipDokumentStructure.loadStructure();
        TipDokumentStructure.Tip t = new TipDokumentStructure.Tip();
        t.setNaziv("");
        t.setTip(null);
        tipovi.add(0, t);
        for (TipDokumentStructure.Tip tip : tipovi) {
            this.tipDokumenta.addItem(tip);
        }
    }
}

