/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.menu.upravljanjeDokumentima;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.DokumentLog;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class History
extends PzDialog {
    private JScrollPane scp;
    private PzPanel mainPanel;
    private PzTable table;
    private DefaultTableModel tableModel;
    private Dokument dokument;

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public History(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                this.dokument = (Dokument)this.getSession().getParameter("dokument");
                this.setTitle("Istorija dokumenta sa identifikacionim brojem: " + this.dokument.getIdDok());
                Query q = em.createQuery("SELECT d FROM DokumentLog d WHERE d.dokument.idDok=" + this.dokument.getIdDok() + " order by d.vrsta");
                List log = q.getResultList();
                this.table.setData(log, DokumentLog.class);
                this.setRenderer();
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle(this, e);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private void initGUI() {
        BorderLayout bLayout = new BorderLayout();
        this.setLayout(bLayout);
        this.mainPanel = new PzPanel();
        BorderLayout mainPanelLayout = new BorderLayout();
        this.mainPanel.setLayout(mainPanelLayout);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.scp = new JScrollPane();
        this.mainPanel.add((Component)this.scp, "Center");
        this.table = new PzTable();
        this.scp.setViewportView((Component)((Object)this.table));
        this.table.setFilter(new PzEntityFilter(){

            @Override
            public Object[] getValues(PzEntity entity) {
                DokumentLog dok = (DokumentLog)entity;
                return new Object[]{dok.getPzuser().getFullName(), dok.getVreme().toString(), dok.getVrsta()};
            }

            @Override
            public String[] getColumnNames() {
                return new String[]{"Korisnik", "Vreme", "Opis"};
            }
        });
        this.pack();
        this.setResizable(false);
        this.setRestorable(false);
        this.setSize(700, 400);
    }

    private void setRenderer() {
        if (this.table.getColumnByName("Opis") == null) {
            return;
        }
        this.table.getColumnByName("Opis").setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable arg0, Object value, boolean isSelected, boolean arg3, int arg4, int arg5) {
                JLabel renderer = new JLabel();
                Integer ind = (Integer)value;
                if (ind == 1) {
                    renderer.setText("Otvoren novi dokument");
                } else if (ind == 2) {
                    renderer.setText("Dokument arhiviran");
                } else if (ind == 3) {
                    renderer.setText("Dokument izra\u0111en i arhiviran");
                } else if (ind == 4) {
                    renderer.setText("Dokument obrisan");
                } else if (ind == 5) {
                    renderer.setText("Dokument vra\u0107en u pripremu");
                } else if (ind == 6) {
                    renderer.setText("Modifikovano zaglavlje dokumenta");
                } else if (ind == 7) {
                    renderer.setText("Modifikovane stavke dokumenta");
                } else if (ind == 8) {
                    renderer.setText("Dokument storniran");
                } else if (ind == 9) {
                    renderer.setText("Izdat nalog magacinu za izdavanje robe");
                } else if (ind == 10) {
                    renderer.setText("Dokument izbrisan sa naloga za knjizenje");
                }
                if (isSelected) {
                    Color col = History.this.table.getDefaultRenderer(Object.class).getTableCellRendererComponent((JTable)((Object)History.this.table), value, isSelected, arg3, arg4, arg5).getBackground();
                    renderer.setBackground(col);
                    renderer.setForeground(Color.white);
                } else {
                    renderer.setBackground(Color.WHITE);
                }
                renderer.setFont(new Font("SansSerif", 1, 12));
                renderer.setOpaque(true);
                renderer.setHorizontalAlignment(2);
                return renderer;
            }
        });
    }
}

