/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.pretraga.criteria;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.beanutils.BeanUtils;
import rs.pezar.core.gui.pretraga.criteria.CriteriaComponent;
import rs.pezar.db.entity.KondGrupa;
import rs.pezar.util.PzExpressionParser;

@XmlRootElement
public class Condition {
    public static final int EXPRESSION_SQL = 1;
    public static final int EXPRESSION_JEVAL = 0;
    private boolean active;
    private String field;
    private String value;
    private Condition nextCondition;
    private Condition previousCondition;
    private boolean connectedToNext;
    private String expression;
    private String link;

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Condition getNextCondition() {
        return this.nextCondition;
    }

    public void setNextCondition(Condition nextCondition) {
        this.nextCondition = nextCondition;
        if (nextCondition != null) {
            this.nextCondition.setPreviousCondition(this);
        }
    }

    @XmlTransient
    public Condition getPreviousCondition() {
        return this.previousCondition;
    }

    public void setPreviousCondition(Condition previousCondition) {
        this.previousCondition = previousCondition;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setConnectedToNext(boolean connectedToNext) {
        this.connectedToNext = connectedToNext;
    }

    public boolean isConnectedToNext() {
        return this.connectedToNext;
    }

    public boolean hasNextActiveCondition() {
        if (this.nextCondition == null) {
            return false;
        }
        if (this.nextCondition.isActive()) {
            return true;
        }
        return this.nextCondition.hasNextActiveCondition();
    }

    public boolean isConnectedToPrev() {
        if (this.getPreviousCondition() == null) {
            return false;
        }
        return this.getPreviousCondition().isConnectedToNext();
    }

    public static Condition getRootCondition(CriteriaComponent criteria) {
        if (criteria == null) {
            return null;
        }
        if (!criteria.isActive()) {
            return Condition.getRootCondition(criteria.getNextCriteriaComponent());
        }
        if (criteria.getValue().equals("")) {
            Condition.getRootCondition(criteria.getNextCriteriaComponent());
        }
        Condition condition = new Condition();
        condition.setActive(criteria.isActive());
        condition.setExpression(criteria.getExpression());
        condition.setValue(criteria.getValue().toString());
        condition.setField(criteria.getField());
        condition.setLink(criteria.hasNextActiveComponent() ? criteria.getLink() : null);
        condition.setConnectedToNext(criteria.connectedToNextComponent());
        condition.setNextCondition(Condition.getRootCondition(criteria.getNextCriteriaComponent()));
        return condition;
    }

    public static Condition getRootCondition(KondGrupa grupa) throws JAXBException {
        if (grupa == null) {
            return new Condition();
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Condition.class});
        Unmarshaller unMarshaller = context.createUnmarshaller();
        Condition condition = (Condition)unMarshaller.unmarshal((InputStream)new ByteArrayInputStream(grupa.getUslov().getBytes()));
        return condition;
    }

    public String getExpression(int choice) {
        if (!this.isActive()) {
            return this.getNextCondition() != null ? this.getNextCondition().getExpression(choice) : null;
        }
        if (this.getValue().equals("")) {
            return this.getNextCondition() != null ? this.getNextCondition().getExpression(choice) : null;
        }
        String query = "";
        if (this.isConnectedToNext() && !this.isConnectedToPrev()) {
            query = String.valueOf(query) + " (";
        }
        String expression = this.getExpression().split(";")[choice];
        query = String.valueOf(query) + " " + expression.replace("<field>", this.getField()).replace("<value>", this.getValue().toString().toUpperCase()) + " ";
        if (this.isConnectedToPrev() && !this.isConnectedToNext()) {
            query = String.valueOf(query) + ") ";
        }
        if (this.getLink() != null && this.hasNextActiveCondition()) {
            query = String.valueOf(query) + " " + this.getLink() + " ";
        }
        if (choice == 0) {
            query = query.replace(" AND ", " && ").replace(" OR ", " || ");
        }
        return String.valueOf(query) + (this.getNextCondition() != null ? this.getNextCondition().getExpression(choice) : "");
    }

    public boolean satisfies(Object o) throws Exception {
        String expression = this.getExpression(0);
        if (expression == null) {
            return true;
        }
        Boolean b = Condition.parseBooleanExpression(expression, o);
        return b;
    }

    private static Boolean parseBooleanExpression(String expression, Object o) throws Exception {
        String expRes = new String(expression);
        Pattern pattern = Pattern.compile("\\[x\\..+?\\]");
        Matcher m = pattern.matcher(expression);
        new Vector();
        while (m.find()) {
            String oName = m.group();
            String fName = oName.replaceAll("\\[x\\.|\\]", "");
            try {
                String value = BeanUtils.getNestedProperty((Object)o, (String)fName);
                if (value == null) {
                    value = "";
                }
                expRes = expRes.replace(oName, value.toString());
            }
            catch (Exception e) {
                throw new Exception("Greska prilikom pristupa polju '" + fName + "' dokumenta " + o.getClass().getSimpleName(), e);
            }
        }
        expRes = expRes.replaceAll("x\\..+?'", "0");
        try {
            return PzExpressionParser.getBoolean(expRes);
        }
        catch (Exception e) {
            throw new Exception("Greska prilikom izracunavanja izraza : " + expression, e);
        }
    }

    public boolean isConditionValid() {
        if (this.getNextCondition() == null) {
            return !this.value.equals("");
        }
        return !this.value.equals("") && this.getNextCondition().isConditionValid();
    }

    public static void main(String[] args) throws PzExpressionParser.PzExpressionParserException {
        System.out.println(PzExpressionParser.getBoolean("(indexOf(toUpperCase('AC PUMPA AUDI 80,100'), 'AMORT', 0) == 0) "));
    }
}

