/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.log;

import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFrame;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import rs.pezar.core.PzApplication;

public class PzLogReader
implements LogListener {
    private LogReaderService reader;
    private PrintWriter printWriter;
    private FileWriter writer;

    public void logged(LogEntry entry) {
        if (this.printWriter == null) {
            return;
        }
        if (entry.getLevel() == 1) {
            String time = new SimpleDateFormat("[dd.MM.yyyy hh:mm:ss]").format(new Date(entry.getTime()));
            this.printWriter.format("%s ------ MESSAGE ------\n", time);
            this.printWriter.format("%s Bundle - %s : %s \n", time, entry.getBundle().getSymbolicName(), entry.getMessage());
            if (entry.getException() != null) {
                Throwable e = entry.getException();
                this.printWriter.format("%s ------ STACKTRACE ------\n", time);
                e.printStackTrace(this.printWriter);
                this.printWriter.write("\n");
            }
        }
    }

    public void setReader(LogReaderService value) {
        this.reader = value;
        this.reader.addLogListener((LogListener)this);
    }

    public void shutdown() {
        if (this.reader != null) {
            this.reader.removeLogListener((LogListener)this);
        }
        this.printWriter.close();
    }

    public void startup() {
        try {
            String logDirPath = String.valueOf(PzApplication.getApplication().getDataFolder().getAbsolutePath()) + File.separator + "log" + File.separator;
            File logDir = new File(logDirPath);
            if (!logDir.exists()) {
                logDir.mkdir();
            }
            File file = new File(String.valueOf(logDirPath) + "errLog" + new SimpleDateFormat("dd-MM-yyyy").format(new Date()) + ".log");
            this.printWriter = new PrintWriter(file);
        }
        catch (IOException e) {
            JXErrorPane.showDialog((Component)new JFrame(), (ErrorInfo)new ErrorInfo("Gre\u0161ka!", e.getMessage(), null, null, (Throwable)e, null, null));
        }
    }
}

