/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db;

import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import rs.pezar.core.PzApplication;

public class PzEntityManagerFactory {
    private static PzEntityManagerFactory instance;
    private EntityManagerFactory emf;
    private String address;

    public static void initFactory() {
        if (instance == null || PzEntityManagerFactory.instance.emf == null || !PzEntityManagerFactory.instance.emf.isOpen()) {
            instance = new PzEntityManagerFactory();
        } else {
            instance.init();
        }
    }

    public static void closeFactory() {
        instance.close();
    }

    public static PzEntityManagerFactory getInstance() {
        return instance;
    }

    public PzEntityManagerFactory() {
        this.init();
    }

    public void init() {
        try {
            if (this.emf != null && this.address != null && !this.address.equals(PzApplication.getApplication().getLocalMachineUserSettings().getString("SERVER_ADDRESS"))) {
                this.emf.close();
                this.emf = null;
            }
            if (this.emf == null || this.address == null) {
                this.address = PzApplication.getApplication().getLocalMachineUserSettings().getString("SERVER_ADDRESS");
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("eclipselink.classloader", PzEntityManagerFactory.class.getClassLoader());
                props.put("javax.persistence.jdbc.url", this.address);
                this.emf = Persistence.createEntityManagerFactory((String)"pezardb", props);
            }
        }
        catch (Exception e) {
            System.out.print("Problem sa konekcijom: " + e);
        }
    }

    public void close() {
        this.emf.close();
    }

    public EntityManager createEm() {
        return this.emf.createEntityManager();
    }
}

