/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Akonstaksa;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.ArtikalkonsignacijaPK;
import rs.pezar.db.entity.Konsignacija;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Usluga;

@Entity
@Table(name="ArtikalKonsignacija")
public class Artikalkonsignacija
extends PzArtikalDokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private ArtikalkonsignacijaPK id;
    @Column(length=255)
    private String bliziOpis;
    @Column(nullable=false)
    private double cenaBezPoreza;
    @Column(nullable=false)
    private double cenaSaPorezom;
    @Column(nullable=false, length=255)
    private String jm;
    @Column(nullable=false)
    private double kolicina;
    @Column(length=40)
    private String lokacija;
    @Column(nullable=false, length=255)
    private String naziv;
    @Column(nullable=false)
    private double procRabata;
    private int sort;
    @OneToMany(mappedBy="artikalkonsignacija", cascade={CascadeType.ALL})
    private List<Akonstaksa> akonstaksas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sfrProizvod", nullable=false, insertable=false, updatable=false)
    private Artikal artikal;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Konsignacija konsignacija;

    @Override
    public ArtikalkonsignacijaPK getId() {
        return this.id;
    }

    public void setId(ArtikalkonsignacijaPK id) {
        this.id = id;
    }

    @Override
    public String getBliziOpis() {
        return this.bliziOpis;
    }

    @Override
    public void setBliziOpis(String bliziOpis) {
        this.bliziOpis = bliziOpis;
    }

    public double getCenaBezPoreza() {
        return this.cenaBezPoreza;
    }

    public void setCenaBezPoreza(double cenaBezPoreza) {
        this.cenaBezPoreza = cenaBezPoreza;
    }

    public double getCenaSaPorezom() {
        return this.cenaSaPorezom;
    }

    public void setCenaSaPorezom(double cenaSaPorezom) {
        this.cenaSaPorezom = cenaSaPorezom;
    }

    @Override
    public String getJm() {
        return this.jm;
    }

    @Override
    public void setJm(String jm) {
        this.jm = jm;
    }

    @Override
    public double getKolicina() {
        return this.kolicina;
    }

    @Override
    public void setKolicina(double kolicina) {
        this.kolicina = kolicina;
    }

    public String getLokacija() {
        return this.lokacija;
    }

    public void setLokacija(String lokacija) {
        this.lokacija = lokacija;
    }

    @Override
    public String getNaziv() {
        return this.naziv;
    }

    @Override
    public void setNaziv(String nazivArt) {
        this.naziv = nazivArt;
    }

    @Override
    public double getProcRabata() {
        return this.procRabata;
    }

    @Override
    public void setProcRabata(double procRabata) {
        this.procRabata = procRabata;
    }

    @Override
    public int getSort() {
        return this.sort;
    }

    @Override
    public void setSort(int sort) {
        this.sort = sort;
    }

    public List<Akonstaksa> getAkonstaksas() {
        return this.akonstaksas;
    }

    public void setAkonstaksas(List<Akonstaksa> akonstaksas) {
        this.akonstaksas = akonstaksas;
    }

    @Override
    public Artikal getArtikal() {
        return this.artikal;
    }

    @Override
    public void setArtikal(Artikal artikal) {
        this.artikal = artikal;
    }

    public Konsignacija getKonsignacija() {
        return this.konsignacija;
    }

    public void setKonsignacija(Konsignacija konsignacija) {
        this.konsignacija = konsignacija;
    }

    @Override
    public double getCena() {
        if (this.konsignacija.getTip().equals("KONSIGNACIJA_PRIJEM_V") || this.konsignacija.getTip().equals("KONSIGNACIJA_POVRATNICA_V")) {
            return this.getCenaBezPoreza();
        }
        if (this.konsignacija.getTip().equals("KONSIGNACIJA_PRIJEM_M") || this.konsignacija.getTip().equals("KONSIGNACIJA_POVRATNICA_M")) {
            return this.getCenaSaPorezom();
        }
        return 0.0;
    }

    @Override
    public String[] getColumnNames() {
        if (this.konsignacija.getTip().equals("KONSIGNACIJA_PRIJEM_V") || this.konsignacija.getTip().equals("KONSIGNACIJA_POVRATNICA_V")) {
            return new String[]{"\u0160ifra", "Naziv", "JM", "Koli\u010dina", "Cena", "Kataloski broj."};
        }
        if (this.konsignacija.getTip().equals("KONSIGNACIJA_PRIJEM_M") || this.konsignacija.getTip().equals("KONSIGNACIJA_POVRATNICA_M")) {
            return new String[]{"\u0160ifra", "Naziv", "JM", "Koli\u010dina", "Cena bez PDV-a", "Cena sa PDV-om"};
        }
        return null;
    }

    @Override
    public Object[] getKValues() {
        return null;
    }

    @Override
    public String getSifra() {
        return this.getId().getSfrProizvod();
    }

    @Override
    public Object[] getValues() {
        if (this.konsignacija.getTip().equals("KONSIGNACIJA_PRIJEM_V") || this.konsignacija.getTip().equals("KONSIGNACIJA_POVRATNICA_V")) {
            return new Object[]{this.id.getSfrProizvod(), this.naziv, this.jm, this.kolicina, this.cenaBezPoreza, this.getArtikal().getDobSifra()};
        }
        if (this.konsignacija.getTip().equals("KONSIGNACIJA_PRIJEM_M") || this.konsignacija.getTip().equals("KONSIGNACIJA_POVRATNICA_M")) {
            return new Object[]{this.id.getSfrProizvod(), this.naziv, this.jm, this.kolicina, this.cenaBezPoreza, this.cenaSaPorezom};
        }
        return null;
    }

    @Override
    public PzDokument getDokument() {
        return this.konsignacija;
    }

    @Override
    public void setDokument(PzDokument dokument) {
        this.konsignacija = (Konsignacija)dokument;
    }

    @Override
    public void addTaksa(Tarifnagrupa tgr) {
        if (this.akonstaksas == null) {
            this.akonstaksas = new IndirectList();
        }
        this.akonstaksas.add(new Akonstaksa(this, tgr));
    }

    @Override
    public void setCena(double cena) {
        this.setCenaBezPoreza(cena);
    }

    @Override
    public void setId(int dokId, String artId, int rBroj) {
        this.id = new ArtikalkonsignacijaPK(dokId, artId, rBroj);
    }

    @Override
    public Usluga getUsluga() {
        return null;
    }

    @Override
    public void setUsluga(Usluga usluga) {
    }

    @Override
    public List<? extends PzADTaksa> getTaksas() {
        return this.akonstaksas;
    }

    @Override
    public BigDecimal getProdCena() {
        return null;
    }

    @Override
    public void setProdCena(BigDecimal prodCena) {
    }

    @Override
    public BigDecimal getProsNabCena() {
        return null;
    }

    @Override
    public void setProsNabCena(BigDecimal prosNabCena) {
    }
}

