/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.eclipse.persistence.annotations.PrivateOwned;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Antaksa;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.ArtikalnivelacijaPK;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Usluga;
import rs.pezar.globals.TipDokumentConfig;

@Entity
@Table(name="ArtikalNivelacija")
public class Artikalnivelacija
extends PzArtikalDokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private ArtikalnivelacijaPK id;
    @Column(length=255)
    private String bliziOpis;
    @Column(nullable=false)
    private double cenaNova;
    @Column(nullable=false)
    private double cenaStara;
    @Column(nullable=false, length=255)
    private String jm;
    @Column(nullable=false)
    private double kolicina;
    @Column(nullable=false, length=255)
    private String naziv;
    private int sort;
    @OneToMany(mappedBy="artikalnivelacija", cascade={CascadeType.ALL})
    @PrivateOwned
    private List<Antaksa> antaksas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Nivelacija nivelacija;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sfrProizvod", nullable=false, insertable=false, updatable=false)
    private Artikal artikal;
    private BigDecimal vrednost;

    @Override
    public ArtikalnivelacijaPK getId() {
        return this.id;
    }

    public void setId(ArtikalnivelacijaPK id) {
        this.id = id;
    }

    @Override
    public String getBliziOpis() {
        return this.bliziOpis;
    }

    @Override
    public void setBliziOpis(String bliziOpis) {
        this.bliziOpis = bliziOpis;
    }

    public double getCenaNova() {
        return this.cenaNova;
    }

    public void setCenaNova(double cenaNova) {
        this.cenaNova = cenaNova;
    }

    public double getCenaStara() {
        return this.cenaStara;
    }

    public void setCenaStara(double cenaStara) {
        this.cenaStara = cenaStara;
    }

    @Override
    public String getJm() {
        return this.jm;
    }

    @Override
    public void setJm(String jm) {
        this.jm = jm;
    }

    @Override
    public double getKolicina() {
        return this.kolicina;
    }

    @Override
    public void setKolicina(double kolicina) {
        this.kolicina = kolicina;
    }

    @Override
    public String getNaziv() {
        return this.naziv;
    }

    @Override
    public void setNaziv(String nazivArt) {
        this.naziv = nazivArt;
    }

    @Override
    public int getSort() {
        return this.sort;
    }

    @Override
    public void setSort(int sort) {
        this.sort = sort;
    }

    public List<Antaksa> getAntaksas() {
        return this.antaksas;
    }

    public void setAntaksas(List<Antaksa> antaksas) {
        this.antaksas = antaksas;
    }

    public Nivelacija getNivelacija() {
        return this.nivelacija;
    }

    public void setNivelacija(Nivelacija nivelacija) {
        this.nivelacija = nivelacija;
    }

    @Override
    public Artikal getArtikal() {
        return this.artikal;
    }

    @Override
    public void setArtikal(Artikal artikal) {
        this.artikal = artikal;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"\u0160ifra", "Naziv", "JM", "Kolicina", "Stara cena", "Nova cena", "Razl.u ceni"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.id.getSfrProizvod(), this.naziv, this.jm, this.kolicina, this.cenaStara, this.cenaNova, BDConverter.getProdCena(this.cenaNova - this.cenaStara).multiply(BDConverter.getKolicina(this.kolicina))};
    }

    @Override
    public Object[] getKValues() {
        String nivel = new String();
        nivel = String.format("Nivelacija: %s", this.nivelacija.getOznDokumenta());
        Object[] objectArray = new Object[15];
        objectArray[0] = this.nivelacija.getDatum();
        objectArray[1] = "";
        objectArray[2] = this.nivelacija.getOznDokumenta();
        objectArray[3] = "NIVELACIJA";
        objectArray[5] = 0.0;
        objectArray[6] = 0.0;
        objectArray[7] = 0.0;
        objectArray[9] = 0.0;
        objectArray[10] = this.getCenaNova();
        objectArray[11] = 0.0;
        objectArray[14] = nivel;
        return objectArray;
    }

    @Override
    public double getCena() {
        return this.cenaNova;
    }

    @Override
    public String getSifra() {
        return this.id.getSfrProizvod();
    }

    @Override
    public PzDokument getDokument() {
        return this.nivelacija;
    }

    @Override
    public void setDokument(PzDokument dokument) {
        this.nivelacija = (Nivelacija)dokument;
    }

    @Override
    public double getProcRabata() {
        return 0.0;
    }

    public double getStaraCenaBezPdv() {
        Double rez = 0.0;
        double stoProc = 100.0 + this.artikal.getTarifnaGrupa("PDV").getStopa();
        rez = 100.0 * this.cenaStara / stoProc;
        return rez;
    }

    public double getNovaCenaBezPdv() {
        Double rez = 0.0;
        double stoProc = 100.0 + this.artikal.getTarifnaGrupa("PDV").getStopa();
        rez = 100.0 * this.cenaNova / stoProc;
        return rez;
    }

    @Override
    public void addTaksa(Tarifnagrupa tgr) {
        if (this.antaksas == null) {
            this.antaksas = new IndirectList();
        }
        this.antaksas.add(new Antaksa(this, tgr));
    }

    @Override
    public void setCena(double cena) {
    }

    @Override
    public void setId(int dokId, String artId, int rBroj) {
        this.id = new ArtikalnivelacijaPK(dokId, artId, rBroj);
    }

    @Override
    public void setProcRabata(double procRabata) {
    }

    @Override
    public Usluga getUsluga() {
        return null;
    }

    @Override
    public void setUsluga(Usluga usluga) {
    }

    @Override
    public List<? extends PzADTaksa> getTaksas() {
        return this.antaksas;
    }

    public void setVrednost(BigDecimal vrednost) {
        this.vrednost = vrednost;
    }

    @Override
    public BigDecimal getVrednost() {
        return this.vrednost;
    }

    @Override
    public BigDecimal calculateOsnovica(String vrsta) {
        if (TipDokumentConfig.get().PODTIP_NIVELACIJA_VREDNOSNA.equals(this.nivelacija.getPodTip())) {
            return BDConverter.getProdCena(this.getVrednost().doubleValue());
        }
        BigDecimal cn = BDConverter.getProdCena(this.getCenaNova());
        BigDecimal cs = BDConverter.getProdCena(this.getCenaStara());
        BigDecimal k = BDConverter.getKolicina(this.getKolicina());
        return BDConverter.getIznos(k.multiply(cn)).subtract(BDConverter.getIznos(k.multiply(cs)));
    }

    @Override
    public BigDecimal calculateTaksa(String vrsta) {
        BigDecimal stopa = BDConverter.getStopaPDVProc(this.getTaksa(vrsta).getStopa());
        return BDConverter.getIznos(this.calculateOsnovica(vrsta).multiply(stopa.multiply(new BigDecimal(100))).doubleValue() / new BigDecimal(100).add(stopa.multiply(new BigDecimal(100))).doubleValue());
    }

    @Override
    public BigDecimal getProdCena() {
        return null;
    }

    @Override
    public void setProdCena(BigDecimal prodCena) {
    }

    @Override
    public BigDecimal getProsNabCena() {
        return null;
    }

    @Override
    public void setProsNabCena(BigDecimal prosNabCena) {
    }
}

