/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Transient;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Aftaksa;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Pfrtaksa;
import rs.pezar.db.entity.Proizvodfiskalniracun;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Taksafiskalniracun;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.util.PzDateUtility;
import rs.pezar.util.PzMathUtility;

@Entity
public class Fiskalniracun
extends PzDokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    private int idDok;
    private String adresa;
    private short arhiviran;
    private String brFiskalnogIsecka;
    private Timestamp vreme;
    private String grad;
    private BigDecimal iznos;
    private String nazivKupca;
    private String oznDokumenta;
    private String pib;
    @Transient
    private String mbr;
    private String poruka;
    private int rBroj;
    private int storno;
    private BigDecimal stornoIznos = new BigDecimal(0);
    private BigDecimal vrednostRobe = new BigDecimal(0);
    private BigDecimal vrednostUsluga = new BigDecimal(0);
    private BigDecimal gotovina;
    private BigDecimal cekovi;
    private BigDecimal kartice;
    @Transient
    BigDecimal primljeno;
    @Transient
    BigDecimal popust = new BigDecimal(0);
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Dokument dokument;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sfrKomitent")
    private Komitent komitent;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pzusername")
    private Pzuser pzuser;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="original")
    private Fiskalniracun original;
    @OneToMany(mappedBy="original")
    private List<Fiskalniracun> originals;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="oznOgranak", referencedColumnName="OZNOGRANAK"), @JoinColumn(name="oznRj", referencedColumnName="OZNRJ")})
    private Radnajedinica radnajedinica;
    @OneToMany(mappedBy="fiskalniracun", cascade={CascadeType.ALL})
    @OrderBy(value="sort ASC")
    private List<Proizvodfiskalniracun> proizvodfiskalniracuns;
    @OneToMany(mappedBy="fiskalniracun", cascade={CascadeType.ALL})
    private List<Taksafiskalniracun> taksafiskalniracuns;

    public Taksafiskalniracun createEmptytakTaksafiskalniracun(String oznTarGr, String tip) {
        return new Taksafiskalniracun(this.idDok, oznTarGr, tip);
    }

    @Override
    public int getIdDok() {
        return this.idDok;
    }

    @Override
    public void setIdDok(int idracun) {
        this.idDok = idracun;
    }

    public String getAdresa() {
        return this.adresa;
    }

    public void setAdresa(String adresa) {
        this.adresa = adresa;
    }

    @Override
    public short getArhiviran() {
        return this.arhiviran;
    }

    @Override
    public void setArhiviran(short arhiviran) {
        this.arhiviran = arhiviran;
    }

    public String getBrFiskalnogIsecka() {
        return this.brFiskalnogIsecka;
    }

    public void setBrFiskalnogIsecka(String brfiskalnogisecka) {
        this.brFiskalnogIsecka = brfiskalnogisecka;
    }

    public Timestamp getVreme() {
        return this.vreme;
    }

    public void setVreme(Timestamp datum) {
        this.vreme = datum;
    }

    public String getGrad() {
        return this.grad;
    }

    public void setGrad(String grad) {
        this.grad = grad;
    }

    @Override
    public BigDecimal getIznos() {
        return this.iznos;
    }

    @Override
    public void setIznos(BigDecimal iznos) {
        this.iznos = iznos;
    }

    public String getNazivKupca() {
        return this.nazivKupca;
    }

    public void setNazivKupca(String nazivkupca) {
        this.nazivKupca = nazivkupca;
    }

    @Override
    public String getOznDokumenta() {
        return this.oznDokumenta;
    }

    @Override
    public void setOznDokumenta(String ozndokumenta) {
        this.oznDokumenta = ozndokumenta;
    }

    public String getPib() {
        return this.pib;
    }

    public void setPib(String pib) {
        this.pib = pib;
    }

    public String getMbr() {
        return this.mbr;
    }

    public void setMbr(String mbr) {
        this.mbr = mbr;
    }

    public String getPoruka() {
        return this.poruka;
    }

    public void setPoruka(String poruka) {
        this.poruka = poruka;
    }

    @Override
    public int getrBroj() {
        return this.rBroj;
    }

    public void setrBroj(Integer rbroj) {
        this.rBroj = rbroj;
    }

    @Override
    public int getStorno() {
        return this.storno;
    }

    @Override
    public void setStorno(int storno) {
        this.storno = storno;
    }

    @Override
    public BigDecimal getStornoIznos() {
        return this.stornoIznos == null ? new BigDecimal(0) : this.stornoIznos;
    }

    @Override
    public void setStornoIznos(BigDecimal stornoiznos) {
        this.stornoIznos = stornoiznos;
    }

    public BigDecimal getGotovina() {
        return this.gotovina;
    }

    public void setGotovina(BigDecimal gotovina) {
        this.gotovina = gotovina;
    }

    public BigDecimal getCekovi() {
        return this.cekovi;
    }

    public void setCekovi(BigDecimal cekovi) {
        this.cekovi = cekovi;
    }

    public BigDecimal getKartice() {
        return this.kartice;
    }

    public void setKartice(BigDecimal kartice) {
        this.kartice = kartice;
    }

    @Override
    public Komitent getKomitent() {
        return this.komitent;
    }

    @Override
    public void setKomitent(Komitent komitent) {
        this.komitent = komitent;
    }

    public Pzuser getPzuser() {
        return this.pzuser;
    }

    public void setPzuser(Pzuser pzuser) {
        this.pzuser = pzuser;
    }

    @Override
    public Radnajedinica getRadnajedinica() {
        return this.radnajedinica;
    }

    @Override
    public void setRadnajedinica(Radnajedinica radnajedinica) {
        this.radnajedinica = radnajedinica;
    }

    public List<Proizvodfiskalniracun> getProizvodfiskalniracuns() {
        return this.proizvodfiskalniracuns;
    }

    public void setProizvodfiskalniracuns(List<Proizvodfiskalniracun> proizvodfiskalniracuns) {
        this.proizvodfiskalniracuns = proizvodfiskalniracuns;
    }

    public List<Taksafiskalniracun> getTaksafiskalniracuns() {
        return this.taksafiskalniracuns;
    }

    public void setTaksafiskalniracuns(List<Taksafiskalniracun> taksafiskalniracuns) {
        this.taksafiskalniracuns = taksafiskalniracuns;
    }

    public BigDecimal getIznosRacuna() {
        BigDecimal rez = new BigDecimal(0);
        for (Proizvodfiskalniracun pf : this.proizvodfiskalniracuns) {
            rez = rez.add(pf.getVrednost());
        }
        return PzMathUtility.round(rez);
    }

    @Override
    public void adjust() {
        if (this.getProizvodfiskalniracuns() != null) {
            for (Proizvodfiskalniracun af : this.getProizvodfiskalniracuns()) {
                af.getId().setIdDok(this.getIdDok());
                if (af.getPfrtaksas() == null) continue;
                for (Pfrtaksa taksa : af.getPfrtaksas()) {
                    taksa.getId().setIdDok(this.getIdDok());
                    taksa.getId().setrBroj(af.getId().getrBroj());
                }
            }
        }
        this.setIznos(this.getIznosRacuna());
    }

    public Proizvodfiskalniracun getProizvod(String sfrP, int idRacuna, double cena, double rabat) {
        for (Proizvodfiskalniracun proizvod : this.proizvodfiskalniracuns) {
            if (!proizvod.getId().getSfrProizvod().equals(sfrP) || proizvod.getId().getIdDok() != idRacuna || proizvod.getCena() == cena && proizvod.getProcRabata() == rabat) continue;
            return proizvod;
        }
        return null;
    }

    @Override
    public void formirajOznaku() {
        String rbroj = PzEntityUtil.strZero("" + this.getrBroj(), 5);
        this.setOznDokumenta(String.valueOf(this.radnajedinica.getId().getOznRj()) + "-" + rbroj + "/" + PzDateUtility.getCurrentYear());
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Oznaka dokumenta", "Iznos dokumenta", "Datum dokumenta"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.oznDokumenta, this.iznos, this.vreme};
    }

    @Override
    public String[] getDokColumnNames() {
        return null;
    }

    @Override
    public Object[] getDokValues() {
        return null;
    }

    @Override
    public short getCvProdajna() {
        return 1;
    }

    @Override
    public void setCvProdajna(short cvProdajna) {
    }

    @Override
    public String getTip() {
        return TipDokumentConfig.get().FISKALNI_RACUN;
    }

    @Override
    public void setTip(String tip) {
    }

    @Override
    public void setrBroj(int rBroj) {
        this.rBroj = rBroj;
    }

    @Override
    public void setRbrDok(int rbrdok) {
        if (this.getDokument() != null) {
            this.getDokument().setRbrDok(rbrdok);
        }
    }

    @Override
    public int getRbrDok() {
        if (this.getDokument() != null) {
            return this.getDokument().getRbrDok();
        }
        return 0;
    }

    @Override
    public void setDatum(Date datum) {
    }

    @Override
    public Date getDatum() {
        return this.vreme != null ? new Date(this.vreme.getTime()) : null;
    }

    @Override
    public void setDatValute(Date datum) {
    }

    @Override
    public Date getDatValute() {
        return null;
    }

    @Override
    public Date getDatArh() {
        return this.vreme != null ? new Date(this.vreme.getTime()) : null;
    }

    @Override
    public void setDatArh(Date datum) {
    }

    @Override
    public short getProknjizen() {
        return 0;
    }

    @Override
    public void setProknjizen(short proknjizen) {
    }

    @Override
    public Pzuser getUserKraj() {
        return this.getPzuser();
    }

    @Override
    public void setUserKraj(Pzuser user) {
    }

    @Override
    public Pzuser getUserPoc() {
        return this.getPzuser();
    }

    @Override
    public void setUserPoc(Pzuser user) {
    }

    @Override
    public Object[] getKValues(byte type) {
        return null;
    }

    @Override
    public List<? extends PzTaksaDokument> getTaksadokuments() {
        return this.getTaksafiskalniracuns();
    }

    @Override
    public String getPodTip() {
        return null;
    }

    @Override
    public void setPodTip(String podTip) {
    }

    @Override
    public void setTaksadokuments(List<? extends PzTaksaDokument> taksaDokuments) {
        this.setTaksafiskalniracuns(taksaDokuments);
    }

    @Override
    public String getOpis() {
        return "Ra\u010dun maloprodaje";
    }

    @Override
    public void setOpis(String opis) {
    }

    @Override
    public Dokument getDokument() {
        return this.dokument;
    }

    @Override
    public void setDokument(Dokument dokument) {
        this.dokument = dokument;
    }

    @Override
    public List<? extends PzArtikalDokument> getArtikalDocuments() {
        return this.getProizvodfiskalniracuns();
    }

    @Override
    public void setVrsta(String vrsta) {
    }

    @Override
    public String getVrsta() {
        return "I";
    }

    @Override
    public PzTaksaDokument createEmptyTaksaDokument(String oznTarGr, String tip) {
        return new Taksafiskalniracun(this.idDok, oznTarGr, tip);
    }

    @Override
    public Date getDatPrometa() {
        return new Date(this.vreme.getTime());
    }

    @Override
    public void setArtikalDokuments(List<? extends PzArtikalDokument> list) {
        this.proizvodfiskalniracuns = list;
    }

    @Override
    public Fiskalniracun getOriginal() {
        return this.original;
    }

    public void setOriginal(Fiskalniracun original) {
        this.original = original;
    }

    @Override
    public void setOriginal(PzDokument original) {
        this.original = (Fiskalniracun)original;
    }

    public List<Fiskalniracun> getOriginals() {
        return this.originals;
    }

    public void setOriginals(List<Fiskalniracun> originals) {
        this.originals = originals;
    }

    public BigDecimal getPrimljeno() {
        return this.primljeno;
    }

    public void setPrimljeno(BigDecimal primljeno) {
        this.primljeno = primljeno;
    }

    @Override
    public BigDecimal getVrednostRobe() {
        return this.vrednostRobe;
    }

    @Override
    public BigDecimal getVrednostUsluga() {
        return this.vrednostUsluga;
    }

    @Override
    public void setVrednostRobe(BigDecimal vrednostRobe) {
        this.vrednostRobe = vrednostRobe;
    }

    @Override
    public void setVrednostUsluga(BigDecimal vrednostUsluga) {
        this.vrednostUsluga = vrednostUsluga;
    }

    public BigDecimal getPopust() {
        return this.popust;
    }

    public void setPopust(BigDecimal popust) {
        this.popust = popust;
    }

    public void sumirajPopust() {
        for (Proizvodfiskalniracun p : this.proizvodfiskalniracuns) {
            if (p.getProcRabata() == 0.0) continue;
            this.setPopust(this.getPopust().add(p.getPopust()));
        }
    }

    public void primeniPopustNaCene() {
        for (Proizvodfiskalniracun p : this.proizvodfiskalniracuns) {
            if (p.getProcRabata() == 0.0) continue;
            p.setCena(BDConverter.getProdCena(p.getCena()).subtract(BDConverter.getProdCena(p.getCena() * p.getProcRabata() / 100.0)).doubleValue());
        }
    }

    public void kopirajArtikleSaFakture(Faktura f) throws Exception {
        for (Artikalfaktura af : f.getArtikalfakturas()) {
            Proizvodfiskalniracun kopija = new Proizvodfiskalniracun(af);
            kopija.getId().setrBroj(this.getNextRBrojArtikli());
            this.proizvodfiskalniracuns.add(kopija);
            kopija.setFiskalniracun(this);
            for (Aftaksa taksa : af.getAftaksas()) {
                Pfrtaksa taksaKopija = new Pfrtaksa(taksa);
                taksaKopija.setProizvodfiskalniracun(kopija);
                if (kopija.getPfrtaksas() == null) {
                    kopija.setPfrtaksas(new ArrayList<Pfrtaksa>());
                }
                kopija.getPfrtaksas().add(taksaKopija);
            }
        }
        this.adjust();
        this.iznos = new BigDecimal(0);
    }
}

